package cn.com.duiba.dao.custom.impl;

import cn.com.duiba.constant.DatabaseSchema;
import cn.com.duiba.dao.BaseDAO;
import cn.com.duiba.dao.custom.VirtualSupplierProcessingOrderLogDao;
import cn.com.duiba.domain.VirtualSupplierProcessingOrderLogEntity;
import cn.com.duiba.wolf.utils.DateUtils;
import org.springframework.stereotype.Repository;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Repository
public class VirtualSupplierProcessingOrderLogDaoImpl extends BaseDAO implements VirtualSupplierProcessingOrderLogDao {

    @Override
    protected DatabaseSchema chooseSchema() {
        return DatabaseSchema.DUIBA_CUSTOM;
    }

    @Override
    public int save(VirtualSupplierProcessingOrderLogEntity virtualSupplierProcessingOrderLogEntity) {
        return insert("save", virtualSupplierProcessingOrderLogEntity);
    }

    @Override
    public int deleteByAppIdOrderId(Long appId, Long orderId) {
        Map<String, Object> map = new HashMap<>();
        map.put("appId", appId);
        map.put("orderId", orderId);
        return delete("deleteByAppIdOrderId", map);
    }


    @Override
    public List<VirtualSupplierProcessingOrderLogEntity> selectNeedRepeatQueryList(Long appId, int offset, int pageSize) {
        Map<String, Object> map = new HashMap<>();
        map.put("appId", appId);
        map.put("processStatus", 0);
        map.put("hasQueryTimes", 3);
        Date time = DateUtils.minutesAddOrSub(new Date(), -15);
        map.put("gmtCreate", DateUtils.getSecondStr(time));
        map.put("offset", offset);
        map.put("pageSize", pageSize);
        return selectList("selectNeedRepeatQueryList", map);
    }

    @Override
    public Integer countNeedRepeatQuery(Long appId) {
        Map<String, Object> map = new HashMap<>();
        map.put("appId", appId);
        map.put("processStatus", 0);
        map.put("hasQueryTimes", 3);
        Date time = DateUtils.minutesAddOrSub(new Date(), -15);
        map.put("gmtCreate", DateUtils.getSecondStr(time));
        return selectOne("countNeedRepeatQuery", map);
    }

    @Override
    public int updateById(VirtualSupplierProcessingOrderLogEntity virtualSupplierProcessingOrderLogEntity) {
        return update("updateById", virtualSupplierProcessingOrderLogEntity);
    }

    @Override
    public int deleteById(Long id) {
        Map<String, Object> map = new HashMap<>();
        map.put("id", id);
        return delete("deleteById", map);
    }


    @Override
    public VirtualSupplierProcessingOrderLogEntity getById(Long id) {
        Map<String, Object> map = new HashMap<>();
        map.put("id", id);
        return selectOne("getById", map);
    }


}
