package cn.com.duiba.service;

import cn.com.duiba.dao.MessageUniqueCheckDAO;
import cn.com.duiba.domain.MessageUniqueCheckDO;
import com.aliyun.openservices.ons.api.Message;
import com.aliyun.openservices.ons.api.Producer;
import com.aliyun.openservices.ons.api.SendResult;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.stereotype.Component;

import java.nio.charset.Charset;

/**
 * 消息服务 发送消息到ons
 *
 * Ons迁移至rocketmq 2018年6月27日16:07:58
 */
@Component
public class MessageService {

	private static Logger log = LoggerFactory.getLogger(MessageService.class);

	@Autowired
	private MessageUniqueCheckDAO messageUniqueCheckDAO;
	@Autowired
	private Producer producer;

	/**
	 * 发送消息ons
	 *
	 * @param topic
	 *            队列名单
	 * @param tag
	 *            标签
	 * @param key
	 *            消息key
	 * @param message
	 *            消息
	 * @return
	 */
	public String sendMsg(String topic, String tag, String key, String message) {
		Message msg = new Message(topic, tag, message.getBytes(Charset.forName("utf-8")));
		if (StringUtils.isNotEmpty(key)) {
			msg.setKey(key);
		}
		SendResult ret = producer.send(msg);
		return ret.getMessageId();
	}

	/**
	 * 数据库唯一索引验证
	 *
	 * @param relationId
	 * @param relationType
	 * @return
	 */
	public boolean messageUniqueCheck(String relationId, String relationType) {
		try {
			MessageUniqueCheckDO check = new MessageUniqueCheckDO();
			check.setRelationId(relationId);
			check.setRelationType(relationType);
			messageUniqueCheckDAO.insert(check);
			return true;
		} catch (DuplicateKeyException e) {
			log.error("重复向上游请求 supplierOrderId:" + relationId + " DuplicateKeyException", e);
		}
		return false;
	}

}
