package cn.com.duiba.tool;

import cn.com.duiba.biz.Exception.ThirdpatyException;
import cn.com.duiba.tool.sn.InitData;
import cn.com.duiba.tool.sn.Permutation;
import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import net.sf.json.JSONObject;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.http.Header;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.message.BasicNameValuePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/**
 * 参数转换URL
 */
public class AssembleTool {

	private static Logger log = LoggerFactory.getLogger(AssembleTool.class);

    /**
     * 请求类型
     */
    private static final String POSTTYPE = "postType";
    /**
     * 请求类型方式--搜狐需要post以raw串的方式请求，因公用方法是kv，故该处加上raw标识，请求单独调用接口处理
     */
    private static final String RAW = "raw";

	private static final String UTF8 = "utf-8";

	private static final String SPERATOR = "/";

	private static final List<String> TRANSCODE_LIST = Arrays.asList("snb.duiba.market.active.sign","snb.duiba.market.active.exchange");

	private AssembleTool() {

	}

	/**
	 * URL参数转换为MAP
	 * 
	 * @param urlParams
	 * @return
	 */
	public static Map<String, String> getUrlParams(String urlParams) {
		Map<String, String> map = new HashMap<>();
		if (StringUtils.isBlank(urlParams)) {
			return map;
		}
		String[] params = urlParams.split("&");
		for (int i = 0; i < params.length; i++) {
			String[] p = params[i].split("=");
			if (p.length != 2) {
				continue;
			}
			String key = p[0];
			String value = p[1];
			if (StringUtils.isNotEmpty(value)) {
				try {
					value = URLDecoder.decode(value, UTF8);
				} catch (UnsupportedEncodingException e) {
					log.error("URLDecoder.decode error:" + value, e);
				}
			}
			map.put(key, value);
		}
		return map;
	}

	/**
	 * 参数拼接URL
	 * 
	 * @param urlPar
	 * @param params
	 * @return
	 */
	public static String assembleUrl(String urlPar, Map<String, String> params) {
		StringBuilder str = new StringBuilder(urlPar);
		if (str.toString().contains("?")) {
			str.append("&");
		} else {
			str.append("?");
		}
		for (Map.Entry<String, String> entry : params.entrySet()) {
			try {
				if (entry.getValue() == null || entry.getValue().length() == 0) {
					str.append(entry.getKey()).append("=").append(entry.getValue()).append("&");
				} else {
					str.append(entry.getKey()).append("=").append(URLEncoder.encode(entry.getValue(), UTF8)).append("&");
				}
			} catch (UnsupportedEncodingException e) {
				log.error("assembleUrl", e);
			}
		}
		return str.toString();
	}


	/**
	 * 参数拼接URL,并对url参数进行两次encode操作
	 *
	 * @param urlPar
	 * @param params
	 * @return
	 */
	public static String assembleUrlEncodeTwice(String urlPar, Map<String, String> params) {
		StringBuilder str = new StringBuilder(urlPar);
		if (str.toString().contains("?")) {
			str.append("&");
		} else {
			str.append("?");
		}
		for (Map.Entry<String, String> entry : params.entrySet()) {
			try {
				if (StringUtils.isBlank(entry.getValue())) {
					str.append(entry.getKey()).append("=").append(entry.getValue()).append("&");
				} else {
					str.append(entry.getKey()).append("=").append(URLEncoder.encode(URLEncoder.encode(entry.getValue(), UTF8),UTF8)).append("&");
				}
			} catch (UnsupportedEncodingException e) {
				log.error("assembleUrlEncodeTwice", e);
			}
		}
		return str.toString();
	}

	private static HttpPost getSnsHttpPost(String url, Map<String, String> argParams){
		String finalUrl = url.endsWith(SPERATOR) ? url : url+SPERATOR;
		HttpPost post = new HttpPost(finalUrl+argParams.get("transCode"));
		try{
			String sendStr = Permutation.sort(argParams,InitData.CHARSET_UTF8);
			post.setEntity(new ByteArrayEntity(sendStr.getBytes()));
		}catch (Exception e){
			log.error("assembleRequest", e);
		}
		return post;
	}

	private static HttpPost getSouHuHttpPost(HttpPost post, Map<String, String> argParams) throws Exception{
		Boolean isUtfUnicode = StringUtils.isNotBlank(argParams.get("unicodeType")) && argParams.get("unicodeType").equals("UTF-8");
		argParams.remove(POSTTYPE);
		argParams.remove("unicodeType");
		String storeCode = argParams.get("storeCode");
		JSONObject jsonObject;
		if (StringUtils.isNotBlank(storeCode)) {
			//久久丫app内容签名必须去除,但httpHead又必须要
			argParams.remove("storeCode");
			jsonObject = net.sf.json.JSONObject.fromObject(argParams);
			argParams.put("storeCode", storeCode);
		} else {
			jsonObject = net.sf.json.JSONObject.fromObject(argParams);
		}
		String json = jsonObject.toString();
		StringEntity postingString = isUtfUnicode ? new StringEntity(json,Charset.forName(UTF8)) : new StringEntity(json);// json传递
		post.setHeader("Content-Type", "application/json");
		post.setEntity(postingString);
		return post;
	}

	/**
	 * Map拼接URL
	 * 
	 * @param url
	 * @param argParams
	 * @return
	 */
	public static HttpPost assembleRequest(String url, Map<String, String> argParams){
		//如果定制需要post json方式请求，或者定制处理 单独在自己的api 工具中自己处理
		Pair<Boolean,HttpPost> customeResult = customAssebleRequest(url,argParams);
		if(customeResult.getLeft()){
			return customeResult.getRight();
		}

		//苏宁银行
		if(MapUtils.isNotEmpty(argParams) && argParams.containsKey("transCode") && TRANSCODE_LIST.contains(argParams.get("transCode"))) {
			return getSnsHttpPost(url,argParams);
		}
        HttpPost post = new HttpPost(url);
		if (argParams == null) {
			argParams = new HashMap<>();
		}
        //需要post以raw串的方式请求,该处为适配，将json串string化   ---暂搜狐资讯使用，故没加入公有工具类
        if (StringUtils.isNotBlank(argParams.get(POSTTYPE)) && argParams.get(POSTTYPE).equals(RAW)) {
            try {
				return getSouHuHttpPost(post,argParams);
            } catch (Exception e) {
                log.error("assembleRequest", e);
            }
        }
        if (argParams.get("isZhCreditsRequest") != null) {
        	// 如果是中宏的积分请求 封装请求参数
			StringEntity postEntity = new StringEntity(argParams.get("body"), "utf-8");
			log.info(argParams.get("body"));
			postEntity.setContentEncoding("utf-8");
			postEntity.setContentType("application/json");
			post.setEntity(postEntity);
			return post;
		}
		List<NameValuePair> pairs = new ArrayList<>(argParams.size());
		for (Map.Entry<String, String> entry : argParams.entrySet()) {
			String value = entry.getValue();
			if (value != null) {
				pairs.add(new BasicNameValuePair(entry.getKey(), value));
			}
		}
		post.setEntity(new UrlEncodedFormEntity(pairs, Charset.forName(UTF8)));
		return post;
	}


	/**
	 * Map拼接URL
	 * 处理Map<String, Object> argParams 类型参数的处理
	 * @param url
	 * @param argParams
	 * @return
	 */
	public static HttpPost assembleRequestForObjectParam(String url, Map<String, Object> argParams) {
		//如果定制需要post json方式请求，或者定制处理 单独在自己的api 工具中自己处理
		Pair<Boolean, HttpPost> customeResult = customAssebleRequestForObjectParam(url, argParams);
		if (customeResult.getLeft()) {
			return customeResult.getRight();
		}
		HttpPost post = new HttpPost(url);
		if (argParams == null) {
			argParams = new HashMap<>();
		}
		List<NameValuePair> pairs = new ArrayList<>(argParams.size());
		for (Map.Entry<String, Object> entry : argParams.entrySet()) {
			String value = String.valueOf(entry.getValue());
			if (value != null) {
				pairs.add(new BasicNameValuePair(entry.getKey(), value));
			}
		}
		post.setEntity(new UrlEncodedFormEntity(pairs, Charset.forName(UTF8)));
		return post;
	}

	private static Pair<Boolean, HttpPost> customAssebleRequest(String url, Map<String, String> argParams) {
		Pair result = Pair.of(false,null);
		//处理定制逻辑：
		if(argParams.get("isJiuYangRequest")!=null && "ok".equals(argParams.get("isJiuYangRequest"))){
			//定制逻辑的标示请求的不会带上，判断之后删除
			argParams.remove("isJiuYangRequest");
			HttpPost method = new HttpPost(url);

			StringEntity entity = new StringEntity(JSON.toJSONString(argParams),UTF8);
			entity.setContentEncoding(UTF8);
			entity.setContentType("application/json");
			method.setEntity(entity);
			return Pair.of(true,method);
		}
		return result;
	}

	private static Pair<Boolean, HttpPost> customAssebleRequestForObjectParam(String url, Map<String, Object> argParams) {
		Pair result = Pair.of(false,null);
		//处理定制逻辑：
		if(argParams.get("isJiuYangRequest")!=null && "ok".equals(argParams.get("isJiuYangRequest"))){
			//定制逻辑的标示请求的不会带上，判断之后删除
			argParams.remove("isJiuYangRequest");
			HttpPost method = new HttpPost(url);

			StringEntity entity = new StringEntity(JSON.toJSONString(argParams),UTF8);
			entity.setContentEncoding(UTF8);
			entity.setContentType("application/json");
			method.setEntity(entity);
			return Pair.of(true,method);
		}
		return result;
	}

	public static HttpPost assembleRequestJson(String url,String argParams){
		HttpPost method = new HttpPost(url);
		StringEntity entity = new StringEntity(argParams,UTF8);//解决中文乱码问题
		entity.setContentEncoding("UTF-8");
		entity.setContentType("application/json");
		method.setEntity(entity);
		return method;
	}

	public static HttpPost assembleRequestJsonWithHeaders(String url,String json, Header[] headers){
		HttpPost httpPost = assembleRequestJson(url, json);
		if (headers != null && headers.length > 0) {
			httpPost.setHeaders(headers);
		}
		return httpPost;
	}

	public static HttpPost assemblePostRequest(String url, String jsonParam){
		HttpPost post = new HttpPost(url);
		if(StringUtils.isBlank(jsonParam)){
			return post;
		}

		try {
			//规避收货人姓名： 李+1， 发送给对方响应签名会报错
			String encoderJson = URLEncoder.encode(jsonParam, "UTF-8");
			StringEntity postingString = new StringEntity(encoderJson, ContentType.create("application/json", "UTF-8"));// json传递
			post.setEntity(postingString);
			return post;
		} catch (Exception e) {
			log.error("assembleRequest", e);
			throw new ThirdpatyException(e);
		}
	}

	/**
	 * 拼接参数
	 * 例如传入map,转化为uid=1&cid=2&credits=3
	 * @param params
	 * @return
     */
	public static String paramSplic(Map<String, String> params){

		StringBuilder paramStr = new StringBuilder();
		Iterator iterator = params.keySet().iterator();

		while(iterator.hasNext()) {
			String key = (String) iterator.next();

			try {
				if(params.get(key) != null && (params.get(key)).length() != 0) {
					paramStr = paramStr.append(key).append("=").append(URLEncoder.encode(params.get(key), "utf-8")).append("&");
				} else {
					paramStr = paramStr.append(key).append("=").append(params.get(key)).append("&");
				}
			} catch (UnsupportedEncodingException var5) {
				log.error("参数={}",paramStr,var5.getMessage());
			}
		}
		//去掉末尾的&
		if(paramStr.lastIndexOf("&") == paramStr.length() - 1) {
			paramStr = paramStr.deleteCharAt(paramStr.length() - 1);
		}
		return paramStr.toString();
	}

	/**
	 * 解析URL，获取请求地址和参数串
	 *
	 * @param url
	 * @return java.lang.String
	 * @throw
	 */
	public static List<String> analysisUrl(String url) {
		List<String> analysisList = Lists.newArrayList();
		if (StringUtils.isNotBlank(url)) {
			int index = url.indexOf('?');
			if (index != -1) {
				analysisList.add(url.substring(0, index));
				analysisList.add(url.substring(index + 1, url.length()));
			}else {
				analysisList.add(url);
				analysisList.add("");
			}
		}
		return analysisList;
	}

}
