/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.biz.credits;

import cn.com.duiba.credits.sdk.CreditNotifyParams;
import cn.com.duiba.dao.AppDAO;
import cn.com.duiba.domain.AppDO;
import cn.com.duiba.domain.SubCreditsMsgWrapper;
import cn.com.duiba.domain.TopSecretDO;
import cn.com.duiba.notifycenter.domain.NotifyQueueDO;
import cn.com.duiba.order.center.api.dto.CreditsMessage;
import cn.com.duiba.thirdparty.dto.HttpRequestMessageDto;
import cn.com.duiba.tool.CaiNiaoTool;
import cn.com.duiba.tool.HttpRequestLog;
import cn.com.duiba.wolf.utils.DateUtils;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.methods.HttpRequestBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CainiaoApi {
    private static final Logger logger = LoggerFactory.getLogger(CainiaoApi.class);
    private static final ImmutableSet<Long> CAINIAO_APP_IDS = ImmutableSet.of((Object)39305L, (Object)40229L);
    private static final ImmutableMap<String, String> CREDITS_ID_MAP;
    private static final ImmutableMap<String, String> CREDITS_FEILD_MAP;
    public static final String SUB_CREDITS_METHOD = "cainiao.nbmarketcenter.duiba.credits.consume";
    public static final String CREDIT_CONSUMER_REQUEST_PARAM = "credit_consumer_request";
    public static final String NOTIFY_CALLBACK_METHOD = "cainiao.nbmarketcenter.duiba.credits.notify.callback";
    public static final String CREDIT_EXCHANGE_RECORD_PARAM = "credit_exchange_record_params";
    public static final String CRECORD_NOTIFY_METHOD = "cainiao.nbmarketcenter.duiba.credits.exchange.record";
    public static final String CREDIT_NOTIFY_PARAM = "credit_notify_params";
    @Autowired
    private AppDAO appDAO;

    private TopSecretDO getTopSecretDO(Long appId) {
        String appKey = "24327934";
        String secret = "c290043acee4a46c99c47c6382b99f2c";
        if (appId == 39305L) {
            appKey = "1024327934";
            secret = "sandboxacee4a46c99c47c6382b99f2c";
        }
        TopSecretDO topSecretDO = new TopSecretDO();
        topSecretDO.setAppKey(appKey);
        topSecretDO.setAppSecret(secret);
        return topSecretDO;
    }

    public static boolean isCainiao(Long appId) {
        return CAINIAO_APP_IDS.contains((Object)appId);
    }

    public CreditsMessage getRequestCredits(CreditsMessage request) {
        TopSecretDO topSecretDO = this.getTopSecretDO(Long.valueOf(request.getAppId()));
        topSecretDO.setAddPrefix(false);
        Map authParams = request.getAuthParams();
        if (MapUtils.isEmpty((Map)authParams)) {
            throw new IllegalStateException("cainiao api authParams is empty!");
        }
        String credits = (String)authParams.get("credits");
        String creditsId = (String)CREDITS_ID_MAP.get((Object)credits);
        if (creditsId != null) {
            authParams.put("creditsId", creditsId);
        } else {
            logger.warn("cainiao api credits[()] is invalid!", (Object)credits);
        }
        authParams.remove("sign");
        Map<String, String> params = CaiNiaoTool.buildParamMap(authParams, SUB_CREDITS_METHOD, CREDIT_CONSUMER_REQUEST_PARAM, CREDITS_FEILD_MAP, topSecretDO);
        String url = request.getHttpUrl().substring(0, request.getHttpUrl().indexOf(63));
        request.setHttpUrl(url);
        request.setHttpType("post");
        request.setAuthParams(params);
        return request;
    }

    public SubCreditsMsgWrapper getRequestCredits(SubCreditsMsgWrapper request) {
        TopSecretDO topSecretDO = this.getTopSecretDO(request.getSubCreditsMsg().getAppId());
        topSecretDO.setAddPrefix(false);
        Map authParams = request.getSubCreditsMsg().getAuthParams();
        if (MapUtils.isEmpty((Map)authParams)) {
            throw new IllegalStateException("cainiao api authParams is empty!");
        }
        String credits = (String)authParams.get("credits");
        String creditsId = (String)CREDITS_ID_MAP.get((Object)credits);
        if (creditsId != null) {
            authParams.put("creditsId", creditsId);
        } else {
            logger.warn("cainiao api credits[()] is invalid!", (Object)credits);
        }
        authParams.remove("sign");
        Map<String, String> params = CaiNiaoTool.buildParamMap(authParams, SUB_CREDITS_METHOD, CREDIT_CONSUMER_REQUEST_PARAM, CREDITS_FEILD_MAP, topSecretDO);
        String url = request.getHttpUrl().substring(0, request.getHttpUrl().indexOf(63));
        request.setHttpUrl(url);
        request.getSubCreditsMsg().setHttpType(2);
        request.getSubCreditsMsg().setAuthParams(params);
        return request;
    }

    public HttpRequestBase getRequestNotify(String notifyUrl, NotifyQueueDO record, AppDO app, CreditNotifyParams notifyParams) {
        TopSecretDO topSecretDO = this.getTopSecretDO(record.getAppId());
        topSecretDO.setAddPrefix(false);
        HashMap<String, String> authParams = new HashMap<String, String>();
        authParams.put("success", String.valueOf(notifyParams.isSuccess()));
        authParams.put("error_message", notifyParams.getErrorMessage());
        authParams.put("biz_id", notifyParams.getBizId());
        authParams.put("duiba_app_key", app.getAppKey());
        authParams.put("appSecret", this.appDAO.getAppSecret(app));
        authParams.put("duiba_timestamp", DateUtils.getSecondStr((Date)new Date()));
        authParams.put("uid", record.getPartnerUserId());
        authParams.put("order_num", notifyParams.getOrderNum());
        Map<String, String> params = CaiNiaoTool.buildParamMap(authParams, NOTIFY_CALLBACK_METHOD, CREDIT_NOTIFY_PARAM, null, topSecretDO);
        HttpRequestBase http = CaiNiaoTool.setHttpRequestHeader(notifyUrl, params);
        return http;
    }

    public HttpRequestBase getCrecordNotify(HttpRequestMessageDto msg, AppDO app) {
        TopSecretDO topSecretDO = this.getTopSecretDO(app.getId());
        topSecretDO.setAddPrefix(false);
        HashMap<String, String> authParams = new HashMap<String, String>();
        authParams.put("uid", (String)msg.getHttpParams().get("uid"));
        authParams.put("title", (String)msg.getHttpParams().get("title"));
        authParams.put("record_detail_url", (String)msg.getHttpParams().get("recordDetailUrl"));
        authParams.put("credits", (String)msg.getHttpParams().get("credits"));
        authParams.put("appSecret", this.appDAO.getAppSecret(app));
        if (StringUtils.isBlank((String)((String)msg.getHttpParams().get("timestamp")))) {
            authParams.put("duiba_timestamp", DateUtils.getSecondStr((Date)new Date()));
        } else {
            authParams.put("duiba_timestamp", DateUtils.getSecondStr((long)Long.valueOf((String)msg.getHttpParams().get("timestamp"))));
        }
        authParams.put("duiba_app_key", app.getAppKey());
        authParams.put("logo_url", (String)msg.getHttpParams().get("logoUrl"));
        authParams.put("record_id", (String)msg.getHttpParams().get("recordId"));
        if (msg.getHttpParams().get("orderNum") != null) {
            authParams.put("order_num", (String)msg.getHttpParams().get("orderNum"));
        }
        Map<String, String> params = CaiNiaoTool.buildParamMap(authParams, CRECORD_NOTIFY_METHOD, CREDIT_EXCHANGE_RECORD_PARAM, null, topSecretDO);
        HttpRequestBase http = CaiNiaoTool.setHttpRequestHeader(app.getRecordNotifyUrl(), params);
        HttpRequestLog.logUrl("[action crecord] [request url " + app.getRecordNotifyUrl() + "][param " + JSONObject.toJSONString(params) + "]");
        return http;
    }

    public String parseCreditsRsp(String body) {
        JSONObject jsonObject;
        try {
            if (StringUtils.isBlank((String)body)) {
                return body;
            }
            jsonObject = JSONObject.parseObject((String)body);
        }
        catch (Exception e) {
            logger.error("JSON.parseObject:", (Throwable)e);
            return body;
        }
        JSONObject duibaRspJsonWrap = jsonObject.getJSONObject("cainiao_nbmarketcenter_duiba_credits_consume_response");
        if (duibaRspJsonWrap == null) {
            return body;
        }
        String duibaRspJson = duibaRspJsonWrap.getString("result");
        if (StringUtils.isBlank((String)duibaRspJson)) {
            return body;
        }
        return duibaRspJson;
    }

    static {
        HashMap<String, String> tempMap = new HashMap<String, String>();
        tempMap.put("0", "121");
        tempMap.put("50", "92");
        tempMap.put("100", "93");
        tempMap.put("200", "94");
        tempMap.put("300", "95");
        tempMap.put("400", "96");
        tempMap.put("500", "97");
        tempMap.put("600", "98");
        tempMap.put("700", "99");
        tempMap.put("800", "100");
        tempMap.put("900", "101");
        tempMap.put("1000", "102");
        tempMap.put("1500", "103");
        tempMap.put("2000", "104");
        tempMap.put("3000", "105");
        tempMap.put("5000", "106");
        tempMap.put("10000", "107");
        CREDITS_ID_MAP = ImmutableMap.copyOf(tempMap);
        CREDITS_FEILD_MAP = new ImmutableMap.Builder().put((Object)"uid", (Object)"uid").put((Object)"credits", (Object)"credits").put((Object)"creditsId", (Object)"credits_id").put((Object)"itemCode", (Object)"item_code").put((Object)"appKey", (Object)"duiba_app_key").put((Object)"timestamp", (Object)"duiba_timestamp").put((Object)"description", (Object)"description").put((Object)"orderNum", (Object)"order_num").put((Object)"type", (Object)"type").put((Object)"actualPrice", (Object)"actual_price").put((Object)"facePrice", (Object)"face_price").put((Object)"ip", (Object)"ip").put((Object)"waitAudit", (Object)"wait_audit").put((Object)"params", (Object)"params").put((Object)"appSecret", (Object)"appSecret").build();
    }
}

