/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.biz.credits;

import cn.com.duiba.config.HaidilaoConfigBean;
import cn.com.duiba.credits.sdk.CreditNotifyParams;
import cn.com.duiba.credits.sdk.SignTool;
import cn.com.duiba.dao.AppDAO;
import cn.com.duiba.domain.AppDO;
import cn.com.duiba.domain.SubCreditsMsgWrapper;
import cn.com.duiba.domain.SupplierRequest;
import cn.com.duiba.notifycenter.domain.NotifyQueueDO;
import cn.com.duiba.order.center.api.dto.CreditsMessage;
import cn.com.duiba.thirdparty.dto.CreditsMessageDto;
import cn.com.duiba.tool.AssembleTool;
import cn.com.duiba.tool.HaidilaoSignTool;
import cn.com.duiba.tool.JsonTool;
import cn.com.duiba.vo.CouponSendRequestVO;
import cn.com.duiba.vo.HaidilaoVirtualVO;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class HaidilaoApi {
    private static final Logger logger = LoggerFactory.getLogger(HaidilaoApi.class);
    private static final String DELIMITER = "?";
    private static final String VIRTUAL_ADDCREDITS = "addCredits";
    private static final String VIRTUAL_SEND = "send";
    private static final String VIRTUAL_ADD_TYPE = "reward";
    @Autowired
    private AppDAO appDAO;
    @Autowired
    HaidilaoConfigBean haidilaoConfigBean;

    public CreditsMessage getSubCreditsMessage(CreditsMessage request) {
        try {
            String url = request.getHttpUrl();
            String host = this.getGateway(url);
            Map originalParams = request.getAuthParams();
            Map<String, String> paramsMap = this.bulidParms(originalParams);
            request.setAuthParams(paramsMap);
            request.setHttpType("get");
            request.setHttpUrl(AssembleTool.assembleUrl(host, paramsMap));
        }
        catch (Exception e) {
            logger.error("[HaidilaoApi-getSubCreditsMessage]error:{}", (Throwable)e);
        }
        return request;
    }

    public SubCreditsMsgWrapper getRequestCredits(SubCreditsMsgWrapper request) {
        String url = request.getHttpUrl();
        String host = url.substring(0, url.indexOf(63));
        Map originalParams = request.getSubCreditsMsg().getAuthParams();
        Map<String, String> paramsMap = this.bulidParms(originalParams);
        request.getSubCreditsMsg().setAuthParams(paramsMap);
        request.getSubCreditsMsg().setHttpType(1);
        request.setHttpUrl(AssembleTool.assembleUrl(host, paramsMap));
        return request;
    }

    public CreditsMessageDto getAddCreditsMessage(CreditsMessageDto request) {
        try {
            String url = request.getHttpUrl();
            String host = this.getGateway(url);
            Map originalParams = request.getAuthParams();
            Map<String, String> paramsMap = this.bulidAddParms(originalParams);
            request.setAuthParams(paramsMap);
            request.setHttpType("get");
            request.setHttpUrl(AssembleTool.assembleUrl(host, paramsMap));
        }
        catch (Exception e) {
            logger.error("[HaidilaoApi-getAddCreditsMessage]error:{}", (Throwable)e);
        }
        return request;
    }

    public SupplierRequest getVirtualRequest(SupplierRequest request) {
        String url = request.getHttpUrl();
        String urlParams = url.substring(url.indexOf(63) + 1, url.length());
        Map<String, String> crediMap = AssembleTool.getUrlParams(urlParams);
        String keys = crediMap.get("params").trim();
        if (keys.startsWith(this.haidilaoConfigBean.getVirtualAddPre())) {
            crediMap.put("type", VIRTUAL_ADD_TYPE);
            crediMap.put("credits", keys.substring(this.haidilaoConfigBean.getVirtualAddPre().trim().length()).trim());
            CreditsMessageDto dto = new CreditsMessageDto();
            dto.setHttpUrl(this.haidilaoConfigBean.getVirtualAddCreditsUrl());
            dto.setAuthParams(crediMap);
            CreditsMessageDto messageDto = this.getAddCreditsMessage(dto);
            request.setAuthParams(messageDto.getAuthParams());
            request.setHttpUrl(messageDto.getHttpUrl());
            request.setBizType(VIRTUAL_ADDCREDITS);
            return request;
        }
        if (keys.startsWith(this.haidilaoConfigBean.getHuowuGamePre())) {
            HashMap authParams = Maps.newHashMap();
            authParams.put("appKey", crediMap.get("appKey"));
            authParams.put("orderNum", crediMap.get("orderNum"));
            authParams.put("uid", crediMap.get("uid"));
            authParams.put("params", crediMap.get("params"));
            if (StringUtils.isNotBlank((String)crediMap.get("description"))) {
                authParams.put("description", crediMap.get("description"));
            }
            authParams.put("timestamp", String.valueOf(System.currentTimeMillis()));
            authParams.put("developBizId", crediMap.get("developBizId"));
            authParams.put("sign", this.sign(authParams, Long.valueOf(request.getAppId())));
            authParams.remove("appSecret");
            request.setHttpUrl(this.haidilaoConfigBean.getHuowuGameUrl().trim());
            request.setAuthParams(authParams);
            request.setBizType(this.haidilaoConfigBean.getHuowuGamePre());
            return request;
        }
        CouponSendRequestVO csrDto = new CouponSendRequestVO();
        csrDto.setOut_trade_no(crediMap.get("orderNum"));
        csrDto.setTemplate_id(keys);
        csrDto.setUid(crediMap.get("uid"));
        HashMap authParams = Maps.newHashMap();
        authParams.put("method", "coupon_send");
        authParams.put("coupon_send_request", JSONObject.toJSONString((Object)csrDto));
        request.setHttpUrl(this.haidilaoConfigBean.getSendVirtualUrl());
        request.setAuthParams(authParams);
        request.setBizType(VIRTUAL_SEND);
        return request;
    }

    public HttpRequestBase getRequestNotify(String notifyUrl, NotifyQueueDO record, AppDO app, CreditNotifyParams notifyParams) {
        HashMap<String, String> authParams = new HashMap<String, String>();
        Long timestamp = System.currentTimeMillis();
        authParams.put("success", String.valueOf(notifyParams.isSuccess()));
        authParams.put("bizId", notifyParams.getBizId());
        authParams.put("timestamp", String.valueOf(timestamp));
        authParams.put("uid", record.getPartnerUserId());
        authParams.put("orderNum", notifyParams.getOrderNum());
        authParams.put("appKey", this.haidilaoConfigBean.getHaidilaoAppKey());
        if (!record.getResult().booleanValue()) {
            authParams.put("errorMessage", org.apache.commons.lang3.StringUtils.isBlank((CharSequence)record.getError4developer()) ? "\u672a\u77e5\u539f\u56e0" : record.getError4developer());
        }
        HttpGet http = new HttpGet(AssembleTool.assembleUrl(notifyUrl, authParams));
        this.setNotifyHttpHeader(authParams, record.getAppId(), (HttpRequestBase)http, notifyUrl);
        return http;
    }

    public void setNotifyHttpHeader(Map<String, String> authParams, Long appId, HttpRequestBase http, String notifyUrl) {
        CreditsMessage dto = new CreditsMessage();
        dto.setAppId(appId.toString());
        dto.setHttpType("get");
        dto.setHttpUrl(notifyUrl);
        dto.setAuthParams(authParams);
        this.setHttpHeader(dto, http, true);
    }

    public HttpRequestBase setHaidilaoVirtualHttpHeader(SupplierRequest request, HttpRequestBase http) {
        CreditsMessage dto = new CreditsMessage();
        dto.setHttpUrl(request.getHttpUrl());
        dto.setAuthParams(request.getAuthParams());
        dto.setAppId(request.getAppId());
        if (StringUtils.equals((String)VIRTUAL_ADDCREDITS, (String)request.getBizType())) {
            http = new HttpGet(request.getHttpUrl());
            dto.setHttpType("get");
            this.setHttpHeader(dto, http, true);
        } else if (StringUtils.equals((String)this.haidilaoConfigBean.getHuowuGamePre(), (String)request.getBizType())) {
            http = new HttpGet(AssembleTool.assembleUrl(request.getHttpUrl(), request.getAuthParams()));
        } else {
            http = AssembleTool.assembleRequestJson(request.getHttpUrl(), this.getSendDto(request.getAuthParams()));
            dto.setHttpType("post");
            this.setHttpHeader(dto, http, false);
        }
        return http;
    }

    public void setHttpHeader(CreditsMessage request, HttpRequestBase http, boolean isFormType) {
        long timestemp = System.currentTimeMillis();
        Map<String, String> headersParams = this.getHeaders(timestemp, isFormType);
        for (Map.Entry<String, String> entry : headersParams.entrySet()) {
            http.setHeader(entry.getKey(), entry.getValue());
        }
        if (!isFormType) {
            String contentMd5 = HaidilaoSignTool.getContentMd5(this.getSendDto(request.getAuthParams()));
            headersParams.put("Content-MD5", contentMd5);
            http.setHeader("Content-MD5", contentMd5);
        }
        headersParams.remove("X-Ca-Signature-Headers");
        Map queryParams = request.getHttpType().toLowerCase().equals("get") ? request.getAuthParams() : null;
        String path = this.getPath(request);
        http.setHeader("X-Ca-Signature", HaidilaoSignTool.sign(request.getHttpType().toUpperCase(), this.haidilaoConfigBean.getHaidilaoAppSecret(), headersParams, path, queryParams, null));
    }

    private String getSendDto(Map<String, String> authParams) {
        CouponSendRequestVO csrDto = (CouponSendRequestVO)JSONObject.parseObject((String)authParams.get("coupon_send_request"), CouponSendRequestVO.class);
        HaidilaoVirtualVO hvDto = new HaidilaoVirtualVO();
        hvDto.setCoupon_send_request(csrDto);
        hvDto.setMethod(authParams.get("method"));
        return JSONObject.toJSONString((Object)hvDto);
    }

    public String getPath(CreditsMessage request) {
        String uri = request.getHttpUrl();
        if (StringUtils.isNotBlank((String)uri)) {
            int begin = uri.indexOf("com/") + 3;
            int end = uri.indexOf(DELIMITER);
            if (-1 == begin) {
                return null;
            }
            return -1 != end ? uri.substring(begin, end) : uri.substring(begin);
        }
        return null;
    }

    private Map<String, String> getHeaders(long timestamp, boolean isFormType) {
        HashMap headersMap = Maps.newHashMap();
        headersMap.put("X-Ca-Key", this.haidilaoConfigBean.getHaidilaoAppKey());
        headersMap.put("X-Ca-Timestamp", String.valueOf(timestamp));
        headersMap.put("X-Ca-Nonce", String.valueOf(UUID.randomUUID()) + String.valueOf(System.currentTimeMillis()));
        headersMap.put("X-Ca-Signature-Headers", "X-Ca-Key,X-Ca-Timestamp,X-Ca-Nonce");
        headersMap.put("Accept", "text/xml,text/javascript");
        headersMap.put("User-Agent", "top-sdk-java");
        if (isFormType) {
            headersMap.put("Content-Type", "application/x-www-form-urlencoded;charset=utf-8");
        } else {
            headersMap.put("Content-Type", "application/json; charset=UTF-8");
        }
        headersMap.put("Accept-Encoding", "gzip");
        return headersMap;
    }

    public String getVirtualRespone(SupplierRequest message, String body) {
        JSONObject jsonBody;
        try {
            jsonBody = JSON.parseObject((String)body);
        }
        catch (Exception e) {
            logger.error("JSON.parseObject:", (Throwable)e);
            return body;
        }
        JSONObject json = JsonTool.getAllJson(jsonBody);
        HashMap<String, String> duibaDoc = new HashMap<String, String>();
        if (VIRTUAL_ADDCREDITS.equals(message.getBizType())) {
            String status = "ok".equals(json.getString("status")) ? "success" : "fail";
            duibaDoc.put("status", status);
            duibaDoc.put("errorMessage", json.getString("errorMessage"));
            duibaDoc.put("supplierBizId", json.getString("bizId"));
            duibaDoc.put("credits", json.getString("credits"));
        } else if (this.haidilaoConfigBean.getHuowuGamePre().equals(message.getBizType())) {
            duibaDoc.put("status", json.getString("status"));
            duibaDoc.put("errorMessage", json.getString("errorMessage"));
            duibaDoc.put("supplierBizId", json.getString("supplierBizId"));
        } else {
            String supplierBizId = "";
            if (null != json.get((Object)"coupon_template")) {
                String jsonString = JSONObject.toJSONString((Object)json.get((Object)"coupon_template"));
                JSONObject couponJson = JSON.parseObject((String)jsonString);
                supplierBizId = couponJson.getString("template_id");
            }
            String status = "0".equals(json.getString("status").trim()) ? "success" : "fail";
            duibaDoc.put("status", status);
            duibaDoc.put("errorMessage", json.getString("msg"));
            duibaDoc.put("supplierBizId", supplierBizId);
        }
        return JsonTool.objectToJson(duibaDoc);
    }

    private String getGateway(String url) {
        int index;
        if (StringUtils.isNotBlank((String)url) && (index = url.indexOf(DELIMITER)) != -1) {
            return url.substring(0, index);
        }
        return url;
    }

    private Map<String, String> bulidParms(Map<String, String> originalParams) {
        HashMap paramsMap = Maps.newHashMap();
        paramsMap.put("uid", originalParams.get("uid"));
        paramsMap.put("description", originalParams.get("description"));
        paramsMap.put("credits", originalParams.get("credits"));
        paramsMap.put("orderNum", originalParams.get("orderNum"));
        if (StringUtils.isNotBlank((String)originalParams.get("itemCode"))) {
            paramsMap.put("itemCode", originalParams.get("itemCode"));
        }
        paramsMap.put("appKey", this.haidilaoConfigBean.getHaidilaoAppKey());
        paramsMap.put("timestamp", originalParams.get("timestamp"));
        paramsMap.put("type", originalParams.get("type"));
        paramsMap.put("facePrice", originalParams.get("facePrice"));
        paramsMap.put("actualPrice", originalParams.get("actualPrice"));
        if (StringUtils.isNotBlank((String)originalParams.get("ip"))) {
            paramsMap.put("ip", originalParams.get("ip"));
        }
        if (StringUtils.isNotBlank((String)originalParams.get("params"))) {
            paramsMap.put("params", originalParams.get("params"));
        }
        paramsMap.put("waitAudit", originalParams.get("waitAudit"));
        return paramsMap;
    }

    private Map<String, String> bulidAddParms(Map<String, String> originalParams) {
        HashMap paramsMap = Maps.newHashMap();
        paramsMap.put("appKey", this.haidilaoConfigBean.getHaidilaoAppKey());
        paramsMap.put("description", originalParams.get("description"));
        paramsMap.put("uid", originalParams.get("uid"));
        paramsMap.put("credits", originalParams.get("credits"));
        paramsMap.put("type", originalParams.get("type"));
        paramsMap.put("orderNum", originalParams.get("orderNum"));
        paramsMap.put("timestamp", originalParams.get("timestamp"));
        if (StringUtils.isNotBlank((String)originalParams.get("ip"))) {
            paramsMap.put("ip", originalParams.get("ip"));
        }
        return paramsMap;
    }

    public String parseCreditsRsp(String body) {
        try {
            JSONObject jsonBody = JSON.parseObject((String)body);
            JSONObject json = JsonTool.getAllJson(jsonBody);
            HashMap<String, String> duibaDoc = new HashMap<String, String>();
            duibaDoc.put("status", json.getString("status"));
            duibaDoc.put("errorMessage", json.getString("errorMessage"));
            duibaDoc.put("bizId", json.getString("bizId"));
            duibaDoc.put("credits", json.getString("credits"));
            return JsonTool.objectToJson(duibaDoc);
        }
        catch (Exception e) {
            logger.error("[HaidilaoApi-parseCreditsRsp]\u6d77\u5e95\u635e\u8bf7\u6c42\u5f02\u5e38\uff0c\u54cd\u5e94\u4fe1\u606f\uff1a" + body + ",\u54cd\u5e94\u89e3\u6790\u51fa\u9519:{}", (Throwable)e);
            return body;
        }
    }

    private String sign(Map<String, String> params, Long appId) {
        AppDO app = this.appDAO.getAppByCache(appId);
        String appSecret = this.appDAO.getAppSecret(app);
        params.put("appSecret", appSecret.trim());
        return SignTool.sign(params);
    }
}

