/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.biz.credits;

import cn.com.duiba.constant.HongQiConfig;
import cn.com.duiba.credits.sdk.CreditNotifyParams;
import cn.com.duiba.credits.sdk.SignTool;
import cn.com.duiba.dao.AppDAO;
import cn.com.duiba.domain.AppDO;
import cn.com.duiba.domain.SubCreditsMsgWrapper;
import cn.com.duiba.enums.redis.RedisKeyEnum;
import cn.com.duiba.notifycenter.domain.NotifyQueueDO;
import cn.com.duiba.thirdparty.dto.CreditsMessageDto;
import cn.com.duiba.tool.AssembleTool;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.annotation.JSONField;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class HongQiApi {
    private static final Logger LOGGER = LoggerFactory.getLogger(HongQiApi.class);
    private static final String CHARACTER_ENCODE = "UTF-8";
    @Autowired
    private HongQiConfig hongQiConfig;
    @Autowired
    private AppDAO appDAO;
    @Resource(name="httpClient")
    private CloseableHttpClient httpClient;
    @Resource(name="stringRedisTemplate")
    private StringRedisTemplate redisTemplate;

    public Boolean isHongQiAppid(Long appId) {
        return this.hongQiConfig.isHongQiAppId(appId);
    }

    public HttpRequestBase getMqSubCreditsHttpRequest(SubCreditsMsgWrapper message) {
        String url = message.getHttpUrl();
        String host = url.substring(0, url.indexOf(63));
        String params = url.substring(url.indexOf(63) + 1);
        message.getSubCreditsMsg().setHttpType(2);
        message.setHttpUrl(host);
        AppDO appByCache = this.appDAO.getAppByCache(message.getSubCreditsMsg().getAppId());
        return this.buildHttpRequest(host, params, appByCache);
    }

    public HttpRequestBase getAddCreditsMessage(CreditsMessageDto request) {
        request.setHttpType("post");
        String url = request.getHttpUrl();
        String host = url.substring(0, url.indexOf(63));
        String params = url.substring(url.indexOf(63) + 1);
        AppDO appByCache = this.appDAO.getAppByCache(Long.parseLong(request.getAppId()));
        return this.buildHttpRequest(host, params, appByCache);
    }

    public HttpRequestBase getRequestNotify(String notifyUrl, NotifyQueueDO record, CreditNotifyParams param) {
        HttpPost request = new HttpPost(notifyUrl);
        AppDO appByCache = this.appDAO.getAppByCache(record.getAppId());
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("clientId", this.hongQiConfig.getClientId());
        map.put("tacticsCode", this.hongQiConfig.getTacticsCode());
        map.put("success", Boolean.toString(param.isSuccess()));
        map.put("errorMessage", param.getErrorMessage());
        map.put("bizId", param.getBizId());
        map.put("appKey", param.getAppKey());
        map.put("appSecret", this.appDAO.getAppSecret(appByCache));
        map.put("timestamp", String.valueOf(param.getTimestamp().getTime()));
        map.put("uid", record.getPartnerUserId());
        map.put("orderNum", param.getOrderNum());
        map.put("transfer", param.getTransfer());
        String sign = SignTool.sign(map);
        map.remove("appSecret");
        map.put("sign", sign);
        LOGGER.info("hongqi body:{}", (Object)JSON.toJSONString(map));
        request.setEntity((HttpEntity)new StringEntity(JSON.toJSONString(map), "utf-8"));
        this.setHttpHeader((HttpRequestBase)request);
        return request;
    }

    private HttpPost buildHttpRequest(String host, String params, AppDO appByCache) {
        Map<String, String> paramMap = AssembleTool.getUrlParams(params);
        paramMap.put("clientId", this.hongQiConfig.getClientId());
        paramMap.put("tacticsCode", this.hongQiConfig.getTacticsCode());
        paramMap.remove("sign");
        paramMap.put("appSecret", this.appDAO.getAppSecret(appByCache));
        paramMap.put("sign", SignTool.sign(paramMap));
        paramMap.remove("appSecret");
        HttpPost request = new HttpPost(host);
        LOGGER.info("hongqi body:{}", (Object)JSON.toJSONString(paramMap));
        request.setEntity((HttpEntity)new StringEntity(JSON.toJSONString(paramMap), "utf-8"));
        this.setHttpHeader((HttpRequestBase)request);
        LOGGER.info("hongqi header:{}", (Object)JSON.toJSONString((Object)request.getAllHeaders()));
        return request;
    }

    public void setHttpHeader(HttpRequestBase http) {
        TokenResponData tokenData;
        String redisKey = RedisKeyEnum.K004.toString();
        String token = (String)this.redisTemplate.opsForValue().get((Object)redisKey);
        if (StringUtils.isBlank((String)token) && null != (tokenData = this.getToken())) {
            token = tokenData.getAccessToken();
            this.redisTemplate.opsForValue().set((Object)redisKey, (Object)tokenData.getAccessToken(), (long)(tokenData.getExpiresIn() - 100), TimeUnit.SECONDS);
        }
        http.setHeader("Content-Type", "application/json");
        http.setHeader("charset", CHARACTER_ENCODE);
        http.setHeader("Authorization", token);
    }

    public TokenResponData getToken() {
        Object res = null;
        try {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("grant_type", "client_credentials");
            map.put("client_id", this.hongQiConfig.getAuthClientId());
            map.put("client_secret", this.hongQiConfig.getAuthSecret());
            String url = this.hongQiConfig.getAuthServerUrl() + this.hongQiConfig.getRealms() + "/protocol/openid-connect/token";
            return HongQiApi.sendPost((HttpClient)this.httpClient, url, map);
        }
        catch (Exception e) {
            LOGGER.warn("\u7ea2\u65d7token\u503c\u5f02\u5e38, result={}", res, (Object)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static TokenResponData sendPost(HttpClient httpClient, String url, Map<String, String> authParams) {
        HttpPost httpPost = new HttpPost(url);
        ArrayList<BasicNameValuePair> pairs = new ArrayList<BasicNameValuePair>(authParams.size());
        for (Map.Entry<String, String> entry : authParams.entrySet()) {
            String value = entry.getValue();
            if (value == null) continue;
            pairs.add(new BasicNameValuePair(entry.getKey(), value));
        }
        httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(pairs, Charset.forName(CHARACTER_ENCODE)));
        CloseableHttpResponse response = null;
        try {
            response = (CloseableHttpResponse)httpClient.execute((HttpUriRequest)httpPost);
            if (response.getStatusLine().getStatusCode() != 200) {
                Map.Entry<String, String> entry;
                LOGGER.warn("\u4e00\u6c7d\u7ea2\u65d7\u83b7\u53d6token\u53d1\u9001\u8bf7\u6c42\u5931\u8d25\uff0curl={}", (Object)url);
                entry = null;
                return entry;
            }
            String resp = EntityUtils.toString((HttpEntity)response.getEntity(), (String)CHARACTER_ENCODE);
            LOGGER.info("\u4e00\u6c7d\u7ea2\u65d7\u83b7\u53d6token\u8bf7\u6c42\u8fd4\u56de\u7ed3\u679c\uff0curl={},res:{}", (Object)url, (Object)resp);
            TokenResponData tokenResponData = (TokenResponData)JSON.parseObject((String)resp, TokenResponData.class);
            if (StringUtils.isNotBlank((String)tokenResponData.getError())) {
                LOGGER.warn("\u4e00\u6c7d\u7ea2\u65d7\u83b7\u53d6token\u53d1\u9001\u8bf7\u6c42\u5931\u8d25\uff0curl={},res:{}", (Object)url, (Object)resp);
                TokenResponData tokenResponData2 = null;
                return tokenResponData2;
            }
            TokenResponData tokenResponData3 = tokenResponData;
            return tokenResponData3;
        }
        catch (Exception e) {
            LOGGER.warn("\u4e00\u6c7d\u7ea2\u65d7\u83b7\u53d6token\u53d1\u9001\u8bf7\u6c42\u5931\u8d25\uff0curl={}", (Object)url, (Object)e);
        }
        finally {
            if (response != null) {
                try {
                    response.close();
                }
                catch (IOException e) {
                    LOGGER.warn("\u4e00\u6c7d\u7ea2\u65d7\u83b7\u53d6token\u5173\u95edresponse\u5931\u8d25", (Throwable)e);
                }
            }
        }
        return null;
    }

    public static class TokenResponData {
        @JSONField(name="access_token")
        private String accessToken;
        private String type;
        @JSONField(name="expires_in")
        private Integer expiresIn;
        private String error;
        @JSONField(name="error_description")
        private String errorDescription;

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }

        public String getErrorDescription() {
            return this.errorDescription;
        }

        public void setErrorDescription(String errorDescription) {
            this.errorDescription = errorDescription;
        }

        public String getAccessToken() {
            return this.accessToken;
        }

        public void setAccessToken(String accessToken) {
            this.accessToken = accessToken;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public Integer getExpiresIn() {
            return this.expiresIn;
        }

        public void setExpiresIn(Integer expiresIn) {
            this.expiresIn = expiresIn;
        }
    }
}

