/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.biz.credits;

import cn.com.duiba.constant.IcbcElifeConfig;
import cn.com.duiba.domain.SupplierRequest;
import cn.com.duiba.tool.AssembleTool;
import cn.com.duiba.tool.icbc.RSAUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class IcbcElifeApi {
    private Logger logger = LoggerFactory.getLogger(IcbcElifeApi.class);
    @Autowired
    private IcbcElifeConfig icbcElifeConfig;

    public boolean isIcbcApp(Long appId) {
        return null != appId && this.icbcElifeConfig.getAppIds().contains(appId);
    }

    public HttpRequestBase getVirtualRequest(SupplierRequest request) {
        String encryptData;
        String url = request.getHttpUrl();
        String newUrl = url.substring(0, url.indexOf(63));
        String queryString = url.substring(newUrl.length() + 1);
        Map<String, String> params = AssembleTool.getUrlParams(queryString);
        Map<String, String> extra = request.getParams();
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("couponCode", params.get("params"));
        data.put("customerId", extra.get("customerId"));
        data.put("mobile", extra.get("mobile"));
        data.put("outOrderNo", params.get("orderNum"));
        data.put("deductAmount", extra.get("amount"));
        data.put("customCouponName", extra.get("couponName"));
        String json = JSON.toJSONString(data);
        try {
            encryptData = RSAUtils.encodeByPublicKeyFormat(json, this.icbcElifeConfig.getPublicKey());
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        HashMap<String, String> requestParams = new HashMap<String, String>();
        requestParams.put("platformCode", this.icbcElifeConfig.getPlatformCode());
        requestParams.put("data", encryptData);
        String requestJson = JSON.toJSONString(requestParams);
        HttpPost httpPost = new HttpPost(newUrl);
        httpPost.setEntity((HttpEntity)new StringEntity(requestJson, ContentType.APPLICATION_JSON));
        request.setHttpUrl(newUrl);
        request.setAuthParams(requestParams);
        return httpPost;
    }

    public String getVirtualResponse(SupplierRequest message, String body) {
        JSONObject result = new JSONObject();
        try {
            ResponeData responeData = (ResponeData)JSON.parseObject((String)body, ResponeData.class);
            result.put("status", (Object)(responeData.getCode() == 200 ? "success" : "fail"));
            result.put("errorMessage", (Object)responeData.getMsg());
            if (responeData.getData() != null) {
                result.put("supplierBizId", (Object)responeData.getData().getCouponDetailNo());
            }
        }
        catch (Exception e) {
            this.logger.warn("icbc-elife \u5de5\u884c\u5361\u4e2d\u5fc3\u7acb\u51cf\u91d1\u53d1\u653e\u7ed3\u679c\u89e3\u6790\u5931\u8d25", (Throwable)e);
            result.put("status", (Object)"fail");
            result.put("errorMessage", (Object)"\u5f00\u53d1\u8005\u865a\u62df\u5546\u54c1\u5145\u503c\u7ed3\u679c\u89e3\u6790\u5931\u8d25");
        }
        return result.toJSONString();
    }

    static class Data {
        private String couponDetailNo;

        Data() {
        }

        public String getCouponDetailNo() {
            return this.couponDetailNo;
        }

        public void setCouponDetailNo(String couponDetailNo) {
            this.couponDetailNo = couponDetailNo;
        }
    }

    static class ResponeData {
        private int code;
        private String msg;
        private Data data;

        ResponeData() {
        }

        public int getCode() {
            return this.code;
        }

        public void setCode(int code) {
            this.code = code;
        }

        public String getMsg() {
            return this.msg;
        }

        public void setMsg(String msg) {
            this.msg = msg;
        }

        public Data getData() {
            return this.data;
        }

        public void setData(Data data) {
            this.data = data;
        }
    }
}

