/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.biz.credits;

import cn.com.duiba.api.bo.subcredits.SubCreditsMsgDto;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.constant.MiaojieConfig;
import cn.com.duiba.domain.SubCreditsMsgWrapper;
import cn.com.duiba.notifycenter.domain.NotifyQueueDO;
import cn.com.duiba.order.center.api.dto.CreditsMessage;
import cn.com.duiba.thirdparty.dto.CreditsMessageDto;
import cn.com.duiba.tool.HttpRequestLog;
import cn.com.duiba.tool.JsonTool;
import cn.com.duiba.wolf.utils.DateUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicHeader;
import org.apache.http.util.EntityUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MiaojieApi {
    private static final Logger LOGGER = LoggerFactory.getLogger(MiaojieApi.class);
    private static final String CHARACTER_ENCODE = "UTF-8";
    private static final String APPLICATION_JSON = "application/json";
    @Autowired
    private MiaojieConfig miaojieConfig;
    @Resource(name="httpClient")
    private CloseableHttpClient httpClient;

    public boolean isMiaojieApp(Long appId) {
        return this.miaojieConfig.getAppIds().contains(appId);
    }

    public CreditsMessage getSubCreditsMessage(CreditsMessage request) throws BizException {
        Map originAuthParams = request.getAuthParams();
        String orderNum = (String)originAuthParams.get("orderNum");
        String credits = (String)originAuthParams.get("credits");
        String transfer = (String)originAuthParams.get("transfer");
        String[] transfers = transfer.split("#");
        if (transfers.length != 2) {
            LOGGER.error("MiaojieApi call getSubCreditsMessage transfers error , CreditsMessage = {},transfers={}", (Object)JSONObject.toJSONString((Object)request), (Object)transfers);
            throw new BizException("\u5999\u6d01\u6263\u79ef\u5206\u6d41\u7a0b\u4e2d\u65ad");
        }
        String openIdStr = transfers[0];
        String openId = openIdStr.substring(openIdStr.indexOf("openId=") + 7);
        String mobileStr = transfers[1];
        String mobile = mobileStr.substring(mobileStr.indexOf("mobile=") + 7);
        String type = (String)originAuthParams.get("type");
        String content = StringUtils.equals((String)"hdtool", (String)type) ? "\u5151\u5427\u53c2\u4e0e\u6d3b\u52a8\u6263\u51cf" : (StringUtils.equals((String)"game", (String)type) ? "\u5151\u5427\u53c2\u4e0e\u6e38\u620f\u6263\u51cf" : (StringUtils.equals((String)"alipay", (String)type) || StringUtils.equals((String)"qb", (String)type) || StringUtils.equals((String)"coupon", (String)type) || StringUtils.equals((String)"object", (String)type) || StringUtils.equals((String)"phonebill", (String)type) || StringUtils.equals((String)"phoneflow", (String)type) || StringUtils.equals((String)"virtual", (String)type) ? "\u5151\u5427\u7ebf\u4e0a\u6d88\u8d39\u6263\u51cf" : (StringUtils.equals((String)"sign", (String)type) ? "\u5151\u5427\u7b7e\u5230\u7c7b\u6d3b\u52a8\u6263\u51cf" : "\u5151\u5427\u6263\u51cf")));
        HashMap authParams = Maps.newHashMap();
        authParams.put("type", "1");
        authParams.put("mobile", mobile);
        authParams.put("pointInt", credits);
        authParams.put("recordId", orderNum);
        authParams.put("openId", openId);
        authParams.put("content", content);
        request.setAuthParams((Map)authParams);
        request.setHttpType("post");
        return request;
    }

    public HttpRequestBase getSubCreditsHttpRequestBase(CreditsMessage message) {
        Map params = message.getAuthParams();
        HttpPost httpPost = this.getHttpPost(params, this.miaojieConfig.getCreditsRequestPath());
        return httpPost;
    }

    public HttpRequestBase getSubCreditsHttpRequestBase(SubCreditsMsgWrapper subCreditsMsgWrapper) {
        Map params = subCreditsMsgWrapper.getSubCreditsMsg().getAuthParams();
        HttpPost httpPost = this.getHttpPost(params, this.miaojieConfig.getCreditsRequestPath());
        return httpPost;
    }

    public HttpRequestBase getAddCreditsHttpRequestBase(CreditsMessageDto message) {
        Map params = message.getAuthParams();
        HttpPost httpPost = this.getHttpPost(params, this.miaojieConfig.getCreditsRequestPath());
        return httpPost;
    }

    @NotNull
    private HttpPost getHttpPost(Map<String, String> params, String requestPath) {
        String serviceName = this.miaojieConfig.getServiceName();
        String serviceSecret = this.miaojieConfig.getServiceSecret();
        String host = this.miaojieConfig.getHost();
        String contextPath = this.miaojieConfig.getContextPath();
        String version = this.miaojieConfig.getVersion();
        BasicHeader[] headers = this.getHeaders(requestPath, serviceName, serviceSecret, contextPath, version);
        String url = host + "/" + contextPath + "/" + version + requestPath;
        HttpPost httpPost = new HttpPost(url);
        StringEntity stringEntity = new StringEntity(JSONObject.toJSONString(params), CHARACTER_ENCODE);
        stringEntity.setContentEncoding(CHARACTER_ENCODE);
        stringEntity.setContentType(APPLICATION_JSON);
        httpPost.setHeaders((Header[])headers);
        httpPost.setEntity((HttpEntity)stringEntity);
        return httpPost;
    }

    public SubCreditsMsgWrapper getSubCreditsMessage(SubCreditsMsgWrapper subCreditsMsgWrapper) throws BizException {
        SubCreditsMsgDto msg = subCreditsMsgWrapper.getSubCreditsMsg();
        Map originAuthParams = msg.getAuthParams();
        String orderNum = (String)originAuthParams.get("orderNum");
        String credits = (String)originAuthParams.get("credits");
        String transfer = (String)originAuthParams.get("transfer");
        String[] transfers = transfer.split("#");
        if (transfers.length != 2) {
            LOGGER.error("MiaojieApi call getSubCreditsMessage transfers error , subCreditsMsgWrapper = {},transfers={}", (Object)JSONObject.toJSONString((Object)subCreditsMsgWrapper), (Object)transfers);
            throw new BizException("\u5999\u6d01\u6263\u79ef\u5206\u6d41\u7a0b\u4e2d\u65ad");
        }
        String openIdStr = transfers[0];
        String openId = openIdStr.substring(openIdStr.indexOf("openId=") + 7);
        String mobileStr = transfers[1];
        String mobile = mobileStr.substring(mobileStr.indexOf("mobile=") + 7);
        String type = (String)originAuthParams.get("type");
        String content = StringUtils.equals((String)"hdtool", (String)type) ? "\u5151\u5427\u53c2\u4e0e\u6d3b\u52a8\u6263\u51cf" : (StringUtils.equals((String)"game", (String)type) ? "\u5151\u5427\u53c2\u4e0e\u6e38\u620f\u6263\u51cf" : (StringUtils.equals((String)"alipay", (String)type) || StringUtils.equals((String)"qb", (String)type) || StringUtils.equals((String)"coupon", (String)type) || StringUtils.equals((String)"object", (String)type) || StringUtils.equals((String)"phonebill", (String)type) || StringUtils.equals((String)"phoneflow", (String)type) || StringUtils.equals((String)"virtual", (String)type) ? "\u5151\u5427\u7ebf\u4e0a\u6d88\u8d39\u6263\u51cf" : (StringUtils.equals((String)"sign", (String)type) ? "\u5151\u5427\u7b7e\u5230\u7c7b\u6d3b\u52a8\u6263\u51cf" : "\u5151\u5427\u6263\u51cf")));
        HashMap authParams = Maps.newHashMap();
        authParams.put("type", "1");
        authParams.put("mobile", mobile);
        authParams.put("pointInt", credits);
        authParams.put("recordId", orderNum);
        authParams.put("openId", openId);
        authParams.put("content", content);
        msg.setAuthParams((Map)authParams);
        msg.setHttpType(2);
        return subCreditsMsgWrapper;
    }

    public CreditsMessageDto getAddCreditsMessage(CreditsMessageDto request) throws BizException {
        Map originAuthParams = request.getAuthParams();
        String orderNum = (String)originAuthParams.get("orderNum");
        String credits = (String)originAuthParams.get("credits");
        String transfer = (String)originAuthParams.get("transfer");
        String[] transfers = transfer.split("#");
        if (transfers.length != 2) {
            LOGGER.error("MiaojieApi call getAddCreditsMessage transfers error , request = {},transfers={}", (Object)JSONObject.toJSONString((Object)request), (Object)transfers);
            throw new BizException("\u5999\u6d01\u52a0\u79ef\u5206\u6d41\u7a0b\u4e2d\u65ad");
        }
        String openIdStr = transfers[0];
        String openId = openIdStr.substring(openIdStr.indexOf("openId=") + 7);
        String mobileStr = transfers[1];
        String mobile = mobileStr.substring(mobileStr.indexOf("mobile=") + 7);
        String type = (String)originAuthParams.get("type");
        String content = StringUtils.equals((String)"hdtool", (String)type) ? "\u5151\u5427\u53c2\u4e0e\u6d3b\u52a8\u8d60\u9001" : (StringUtils.equals((String)"game", (String)type) ? "\u5151\u5427\u53c2\u4e0e\u6e38\u620f\u8d60\u9001" : (StringUtils.equals((String)"sign", (String)type) ? "\u5151\u5427\u7b7e\u5230\u8d60\u9001" : "\u5151\u5427\u8d60\u9001"));
        String failType = (String)originAuthParams.get("failType");
        if (failType != null) {
            if (StringUtils.equals((String)"1", (String)failType)) {
                content = "\u5151\u5427\u8ba2\u5355\u5931\u8d25\u8fd4\u8fd8\u79ef\u5206";
            } else if (StringUtils.equals((String)"2", (String)failType)) {
                content = "\u5151\u5427\u8ba2\u5355\u53d6\u6d88\u8fd4\u8fd8\u79ef\u5206";
            }
        }
        HashMap authParams = Maps.newHashMap();
        authParams.put("type", "2");
        authParams.put("mobile", mobile);
        authParams.put("pointInt", credits);
        authParams.put("recordId", orderNum);
        authParams.put("openId", openId);
        authParams.put("content", content);
        request.setAuthParams((Map)authParams);
        request.setHttpType("post");
        return request;
    }

    public String getMiaojieResponseCredis(String body, Map<String, String> authParams) {
        JSONObject jsonBody;
        try {
            jsonBody = JSON.parseObject((String)body);
        }
        catch (Exception e) {
            LOGGER.error("JSON.parseObject:body={},error={}", (Object)body, (Object)e.getMessage());
            return body;
        }
        JSONObject json = JsonTool.getAllJson(jsonBody);
        HashMap<String, String> duibaDoc = new HashMap<String, String>();
        String code = json.getString("code");
        String pointCode = json.getString("point_code");
        if ("SUCCESS".equals(code) && "SUC".equals(pointCode)) {
            duibaDoc.put("status", "ok");
        } else {
            duibaDoc.put("status", "fail");
        }
        duibaDoc.put("errorMessage", json.getString("message"));
        duibaDoc.put("bizId", authParams.get("recordId") + "_miaojie");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("openId", authParams.get("openId"));
        params.put("mobile", authParams.get("mobile"));
        String credits = this.getCredits(params);
        duibaDoc.put("credits", credits);
        return JsonTool.objectToJson(duibaDoc);
    }

    private String getCredits(Map<String, String> params) {
        String credits = null;
        try {
            HttpPost httpPost = this.getHttpPost(params, this.miaojieConfig.getGradeRequestPath());
            try (CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)httpPost);){
                String jsondata;
                JSONObject jsondataJ;
                String result = EntityUtils.toString((HttpEntity)response.getEntity());
                JSONObject jsonret = JSONObject.parseObject((String)result);
                String code = jsonret.getString("code");
                if (StringUtils.equals((String)"SUCCESS", (String)code) && (jsondataJ = JSONObject.parseObject((String)(jsondata = jsonret.getString("jsondata")))) != null) {
                    credits = jsondataJ.getString("point");
                }
            }
            catch (Exception e) {
                LOGGER.info("\u5999\u6d01\u5b9a\u5236\u79ef\u5206\u67e5\u8be2\u63a5\u53e3\u8c03\u7528\u5f02\u5e38 params={},error={}", (Object)JSONObject.toJSONString(params), (Object)e.getMessage());
            }
            return credits;
        }
        catch (Exception e) {
            LOGGER.info("\u5999\u6d01\u5b9a\u5236\u79ef\u5206\u67e5\u8be2\u63a5\u53e3\u8c03\u7528\u5f02\u5e38 params={},error={}", (Object)JSONObject.toJSONString(params), (Object)e.getMessage());
            return null;
        }
    }

    public HttpRequestBase getMiaojieRequestNotify(NotifyQueueDO record) throws BizException {
        if (StringUtils.isBlank((String)record.getError4developer())) {
            return new HttpPost("http://test.lianwangshenqi.com");
        }
        String transfer = record.getTransfer();
        String[] transfers = transfer.split("#");
        if (transfers.length != 2) {
            LOGGER.error("MiaojieApi call getMiaojieRequestNotify transfers error , NotifyQueueDO = {},transfers={}", (Object)JSONObject.toJSONString((Object)record), (Object)transfers);
            throw new BizException("\u5999\u6d01\u52a0\u79ef\u5206\u6d41\u7a0b\u4e2d\u65ad");
        }
        String mobileStr = transfers[1];
        String mobile = mobileStr.substring(mobileStr.indexOf("mobile=") + 7);
        Map param = (Map)JSONObject.parseObject((String)record.getError4developer(), Map.class);
        param.put("mobile", mobile);
        HttpRequestLog.logUrl("[action notify request][bizId " + record.getDuibaOrderNum() + "] [param " + JSONObject.toJSONString((Object)param) + "]");
        HttpPost httpPost = this.getHttpPost(param, this.miaojieConfig.getNotifyRequestPath());
        return httpPost;
    }

    public String getMiaojieResponseNotify(String body) {
        JSONObject jsonBody;
        try {
            jsonBody = JSON.parseObject((String)body);
        }
        catch (Exception e) {
            LOGGER.error("JSON.parseObject:", (Throwable)e);
            return body;
        }
        JSONObject json = JsonTool.getAllJson(jsonBody);
        String code = json.getString("code");
        String orderPutCode = json.getString("orderPut_code");
        if ("SUCCESS".equals(code) && "SUC".equals(orderPutCode)) {
            return "ok";
        }
        return body;
    }

    @NotNull
    private BasicHeader[] getHeaders(String requestPath, String serviceName, String serviceSecret, String contextPath, String version) {
        BasicHeader[] headers = new BasicHeader[4];
        headers[0] = new BasicHeader("X-Caller-Service", serviceName);
        String timestamp = DateUtils.getSecondStr((Date)new Date());
        headers[1] = new BasicHeader("X-Caller-Timestamp", timestamp);
        String sign = MiaojieApi.generateSign(serviceName, contextPath, version, timestamp, serviceSecret, requestPath);
        headers[2] = new BasicHeader("X-Caller-Sign", sign);
        headers[3] = new BasicHeader("Content-Type", "application/json;charset=utf-8");
        return headers;
    }

    public static String generateSign(String callerService, String contextPath, String version, String timestamp, String serviceSecret, String requestPath) {
        String sign = "";
        if (callerService == null || callerService.equals("") || contextPath == null || contextPath.equals("") || timestamp == null || timestamp.equals("") || serviceSecret == null || serviceSecret.equals("")) {
            return sign;
        }
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("callerService", callerService);
        map.put("contextPath", contextPath);
        try {
            if (requestPath != null) {
                StringBuilder sb = new StringBuilder();
                for (String part : requestPath.split("/")) {
                    sb.append("/").append(URLEncoder.encode(part, "utf-8"));
                }
                map.put("requestPath", sb.toString().substring(1));
            }
            map.put("timestamp", timestamp);
            map.put("v", version);
            sign = MiaojieApi.generateMD5Sign(serviceSecret, map);
        }
        catch (UnsupportedEncodingException | NoSuchAlgorithmException e) {
            e.printStackTrace();
            return "";
        }
        return sign;
    }

    private static String generateMD5Sign(String secret, Map<String, String> parameters) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        byte[] bytes = md5.digest(MiaojieApi.generateConcatSign(secret, parameters).getBytes("utf-8"));
        return MiaojieApi.byteToHex(bytes);
    }

    private static String generateConcatSign(String secret, Map<String, String> parameters) {
        StringBuilder sb = new StringBuilder().append(secret);
        Set<String> keys = parameters.keySet();
        for (String key : keys) {
            sb.append(key).append(parameters.get(key));
        }
        return sb.append(secret).toString();
    }

    private static String byteToHex(byte[] bytesIn) {
        StringBuilder sb = new StringBuilder();
        for (byte byteIn : bytesIn) {
            String bt = Integer.toHexString(byteIn & 0xFF);
            if (bt.length() == 1) {
                sb.append(0).append(bt);
                continue;
            }
            sb.append(bt);
        }
        return sb.toString().toUpperCase();
    }
}

