/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.biz.credits;

import cn.com.duiba.constant.ShanXiSecuritiesConfig;
import cn.com.duiba.domain.SubCreditsMsgWrapper;
import cn.com.duiba.thirdparty.dto.CreditsMessageDto;
import cn.com.duiba.tool.AssembleTool;
import cn.com.duiba.tool.MD5;
import cn.com.duiba.wolf.utils.UUIDUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ShanXiSecuritiesApi {
    private static final Logger logger = LoggerFactory.getLogger(ShanXiSecuritiesApi.class);
    public static final String ADD_FLAG = "1";
    public static final String SUB_FLAG = "3";
    public static final String RESULT_CODE = "resultCode";
    public static final String INSERT_RESULT = "insertResult";
    public static final String POINT = "point";
    public static final String DATA = "data";
    public static final int SUCCESS = 1000;
    public static final String UID = "uid";
    @Autowired
    private ShanXiSecuritiesConfig shanXiSecuritiesConfig;
    @Resource(name="httpClient")
    private CloseableHttpClient httpClient;

    public boolean isAppId(Long appId) {
        return this.shanXiSecuritiesConfig.getAppIds().contains(appId);
    }

    public HttpRequestBase getSubCreditsHttpRequest(SubCreditsMsgWrapper message) {
        Long credits = message.getSubCreditsMsg().getCreditConsumeParams().getCredits();
        String uid = (String)message.getSubCreditsMsg().getAuthParams().get(UID);
        String remark = (String)message.getSubCreditsMsg().getAuthParams().get("description");
        String url = message.getHttpUrl();
        String newUrl = url.substring(0, url.indexOf(63));
        return this.getCreditsHttpRequest(SUB_FLAG, String.valueOf(credits), uid, newUrl, remark);
    }

    public HttpRequestBase getAddCreditsHttpRequest(CreditsMessageDto message) {
        String httpUrl = message.getHttpUrl();
        String paramsStr = httpUrl.substring(httpUrl.indexOf(63) + 1);
        Map<String, String> authParams = AssembleTool.getUrlParams(paramsStr);
        String credits = authParams.get("credits");
        String uid = authParams.get(UID);
        String remark = authParams.get("description");
        String newUrl = httpUrl.substring(0, httpUrl.indexOf(63));
        return this.getCreditsHttpRequest(ADD_FLAG, credits, uid, newUrl, remark);
    }

    public String getResponseCredits(String body, Map<String, String> authParams) {
        logger.info("getResponseCredits body:{}", (Object)body);
        JSONObject jsonObject = JSON.parseObject((String)body);
        if (jsonObject == null || jsonObject.getInteger(RESULT_CODE) != 1000) {
            logger.warn("MingYuJiuDian sub credits error,body:{}", (Object)body);
            return body;
        }
        JSONObject data = jsonObject.getJSONObject(DATA);
        if (data == null || data.getInteger(INSERT_RESULT) != 1) {
            logger.warn("MingYuJiuDian sub credits error,body:{}", (Object)body);
            return body;
        }
        HashMap param = Maps.newHashMap();
        param.put("status", "ok");
        param.put("bizId", UUIDUtils.createUUID());
        String uid = authParams.get(UID);
        String credits = this.getCredits(uid);
        if (StringUtils.isNotBlank((CharSequence)credits)) {
            param.put("credits", credits);
        }
        String result = JSON.toJSONString((Object)param);
        logger.info("getResponseCredits result:{}", (Object)result);
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getCredits(String uid) {
        HashMap newParams = Maps.newHashMap();
        newParams.put("phoneNo", uid);
        newParams.put("detailId", String.valueOf(System.currentTimeMillis()));
        newParams.put("appCode", this.shanXiSecuritiesConfig.getAppCode());
        String sign = this.getSign(newParams);
        newParams.put("sign", sign);
        String url = AssembleTool.assembleUrl(this.shanXiSecuritiesConfig.getGetCustomerPointUrl(), newParams);
        logger.info("getCredits url:{}", (Object)url);
        HttpPost httpPost = new HttpPost(url);
        try (CloseableHttpResponse httpResponse = this.httpClient.execute((HttpUriRequest)httpPost);){
            String responseEntity = EntityUtils.toString((HttpEntity)httpResponse.getEntity());
            logger.info("getCredits uid:{},responseEntity:{}", (Object)uid, (Object)responseEntity);
            JSONObject jsonObject = JSON.parseObject((String)responseEntity);
            if (!Objects.equals(1000, jsonObject.getInteger(RESULT_CODE))) {
                String string = null;
                return string;
            }
            JSONObject data = jsonObject.getJSONObject(DATA);
            if (data == null || !data.containsKey((Object)POINT)) {
                String string = null;
                return string;
            }
            String string = String.valueOf(data.getInteger(POINT));
            return string;
        }
        catch (Exception e) {
            logger.error("getCredits error:", (Throwable)e);
            return null;
        }
    }

    private HttpGet getCreditsHttpRequest(String isAddFlag, String credits, String uid, String newUrl, String remark) {
        HashMap newParams = Maps.newHashMap();
        newParams.put("phoneNo", uid);
        newParams.put(POINT, String.valueOf(credits));
        newParams.put("isAddFlag", isAddFlag);
        newParams.put("accessChannel", "4");
        newParams.put("type", SUB_FLAG);
        newParams.put("detailId", String.valueOf(System.currentTimeMillis()));
        if (StringUtils.isNotBlank((CharSequence)remark) && remark.length() > this.shanXiSecuritiesConfig.getLength()) {
            remark = remark.substring(0, this.shanXiSecuritiesConfig.getLength()) + "...";
        }
        newParams.put("remark", remark);
        newParams.put("appCode", this.shanXiSecuritiesConfig.getAppCode());
        String sign = this.getSign(newParams);
        newParams.put("sign", sign);
        String url = AssembleTool.assembleUrl(newUrl, newParams);
        logger.info("getCreditsHttpRequest url:{}", (Object)url);
        return new HttpGet(url);
    }

    private String getSign(Map<String, String> params) {
        ArrayList<String> sortKey = new ArrayList<String>(params.keySet());
        sortKey.sort(String::compareTo);
        StringBuilder sb = new StringBuilder();
        for (String key : sortKey) {
            sb.append(key).append("=").append(params.get(key)).append("&");
        }
        sb.append("apiSecret=").append(this.shanXiSecuritiesConfig.getApiSecret());
        String str = sb.toString();
        logger.info("getSign old str:{}", (Object)str);
        try {
            return MD5.md5(str);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.warn("\u7b7e\u540d\u8ba1\u7b97\u5931\u8d25\uff0c\u539f\u4e32\uff1a{}", (Object)str);
            return null;
        }
    }
}

