/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.biz.credits;

import cn.com.duiba.api.bo.subcredits.SubCreditsMsgDto;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.constant.SuningConfig;
import cn.com.duiba.domain.SubCreditsMsgWrapper;
import cn.com.duiba.domain.SupplierRequest;
import cn.com.duiba.order.center.api.dto.CreditsMessage;
import cn.com.duiba.tool.AssembleTool;
import cn.com.duiba.tool.JsonTool;
import cn.com.duiba.tool.suning.EncryptUtil;
import cn.com.duiba.tool.suning.SuningSignUtils;
import com.alibaba.fastjson.JSONObject;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SuningApi {
    private static final Logger LOGGER = LoggerFactory.getLogger(SuningApi.class);
    private static final SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
    @Autowired
    private SuningConfig suningConfig;
    @Resource(name="httpClient")
    private CloseableHttpClient httpClient;

    public boolean isSuningApp(Long appId) {
        return this.suningConfig.getAppIds().contains(appId);
    }

    public CreditsMessage getSubCreditsMessage(CreditsMessage request) throws BizException {
        Map originAuthParams = request.getAuthParams();
        JSONObject params = new JSONObject();
        params.put("openId", originAuthParams.get("uid"));
        params.put("sceneCode", (Object)"01");
        params.put("deductionCatFood", originAuthParams.get("credits"));
        params.put("reqNo", originAuthParams.get("orderNum"));
        request.setHttpUrl(this.suningConfig.getDeductionUrl());
        Map<String, String> authParams = this.signParams(params);
        authParams.put("postType", "raw");
        authParams.put("unicodeType", "UTF-8");
        request.setAuthParams(authParams);
        request.setHttpType("post");
        return request;
    }

    public SubCreditsMsgWrapper getSubCreditsMessage(SubCreditsMsgWrapper subCreditsMsgWrapper) throws BizException {
        SubCreditsMsgDto msg = subCreditsMsgWrapper.getSubCreditsMsg();
        Map originAuthParams = msg.getAuthParams();
        JSONObject params = new JSONObject();
        params.put("openId", originAuthParams.get("uid"));
        params.put("sceneCode", (Object)"01");
        params.put("deductionCatFood", originAuthParams.get("credits"));
        params.put("reqNo", originAuthParams.get("orderNum"));
        subCreditsMsgWrapper.setHttpUrl(this.suningConfig.getDeductionUrl());
        Map<String, String> authParams = this.signParams(params);
        authParams.put("postType", "raw");
        authParams.put("unicodeType", "UTF-8");
        msg.setAuthParams(authParams);
        msg.setHttpType(2);
        return subCreditsMsgWrapper;
    }

    public Map<String, String> signParams(JSONObject params) {
        HashMap<String, Object> bizMap = new HashMap<String, Object>();
        bizMap.put("appId", this.suningConfig.getOpenAppId());
        bizMap.put("version", "1.0");
        bizMap.put("timestamp", SuningApi.getDateStr(new Date()));
        bizMap.put("signType", "RSA2");
        bizMap.put("signkeyIndex", this.suningConfig.getSignkeyIndex());
        String paramsJson = params.toJSONString();
        bizMap.put("params", paramsJson);
        SuningSignUtils.getSign(bizMap, this.suningConfig.getDuibaPrivateKey());
        String aesKey = this.suningConfig.getDuibaAesKey();
        SuningSignUtils.encrypt(aesKey, this.suningConfig.getSuningPublicKey(), bizMap);
        Map<String, String> map = SuningSignUtils.toStringMap(bizMap);
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getDateStr(Date date) {
        SimpleDateFormat simpleDateFormat = SuningApi.simpleDateFormat;
        synchronized (simpleDateFormat) {
            if (date == null) {
                return "";
            }
            return SuningApi.simpleDateFormat.format(date);
        }
    }

    public String getSuningResponseCredis(String body, Map<String, String> authParams) {
        String aesKey = this.suningConfig.getDuibaAesKey();
        HashMap<String, String> duibaDoc = new HashMap<String, String>();
        JSONObject ret = JSONObject.parseObject((String)body);
        Map<String, Object> paramMap = SuningSignUtils.decrypt(aesKey, (Map<String, Object>)ret);
        String code = String.valueOf(paramMap.get("responseCode"));
        if (StringUtils.equals((String)"0000", (String)code)) {
            duibaDoc.put("status", "ok");
        } else {
            duibaDoc.put("status", "fail");
        }
        duibaDoc.put("errorMessage", String.valueOf(paramMap.get("responseMsg")));
        String str = authParams.get("params");
        str = EncryptUtil.decryptBase64DecorateAES(str, aesKey);
        JSONObject requestParams = JSONObject.parseObject((String)str);
        JSONObject params = new JSONObject();
        duibaDoc.put("bizId", requestParams.get((Object)"reqNo") + "_suning");
        params.put("openId", requestParams.get((Object)"openId"));
        Map<String, String> creditsParams = this.signParams(params);
        String credits = this.getCredits(this.suningConfig.getUserInfoUrl(), creditsParams, aesKey);
        duibaDoc.put("credits", credits);
        return JsonTool.objectToJson(duibaDoc);
    }

    private String getCredits(String urlGrade, Map<String, String> params, String aesKey) {
        String credits = null;
        try {
            HttpPost post = new HttpPost(urlGrade);
            StringEntity entity = new StringEntity(JSONObject.toJSONString(params));
            entity.setContentEncoding("utf-8");
            entity.setContentType("application/json");
            post.setEntity((HttpEntity)entity);
            try (CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)post);){
                String result = EntityUtils.toString((HttpEntity)response.getEntity());
                JSONObject ret = JSONObject.parseObject((String)result);
                Map<String, Object> paramMap = SuningSignUtils.decrypt(aesKey, (Map<String, Object>)ret);
                String code = String.valueOf(paramMap.get("responseCode"));
                if (StringUtils.equals((String)"0000", (String)code)) {
                    credits = String.valueOf(paramMap.get("catFoodRemainNum"));
                }
            }
            catch (Exception e) {
                LOGGER.error("\u82cf\u5b81\u5b9a\u5236\u79ef\u5206\u67e5\u8be2\u63a5\u53e3\u8c03\u7528\u5f02\u5e38 params={},error={}", (Object)JSONObject.toJSONString(params), (Object)e.getMessage());
            }
            return credits;
        }
        catch (Exception e) {
            LOGGER.error("\u82cf\u5b81\u5b9a\u5236\u79ef\u5206\u67e5\u8be2\u63a5\u53e3\u8c03\u7528\u5f02\u5e38 params={},error={}", (Object)JSONObject.toJSONString(params), (Object)e.getMessage());
            return null;
        }
    }

    public SupplierRequest getVirtualRequest(SupplierRequest request) {
        String url = request.getHttpUrl();
        String requestParams = url.substring(url.indexOf(63) + 1, url.length());
        Map<String, String> crediMap = AssembleTool.getUrlParams(requestParams);
        JSONObject params = new JSONObject();
        params.put("openId", (Object)crediMap.get("uid"));
        params.put("source", (Object)"04");
        String code = crediMap.get("params");
        String[] codes = code.split("\\|");
        if (codes.length == 2) {
            params.put("activityCode", (Object)codes[0]);
            params.put("giftCode", (Object)codes[1]);
        } else {
            params.put("activityCode", (Object)crediMap.get("params"));
        }
        params.put("outOrderNo", (Object)crediMap.get("orderNum"));
        params.put("grantSource", (Object)this.suningConfig.getGrantSource());
        request.setHttpUrl(this.suningConfig.getVirtualUrl());
        Map<String, String> authParams = this.signParams(params);
        authParams.put("postType", "raw");
        authParams.put("unicodeType", "UTF-8");
        request.setAuthParams(authParams);
        return request;
    }

    public String getVirtualResponse(SupplierRequest message, String body) {
        HashMap<String, String> duibaDoc = new HashMap<String, String>();
        try {
            String aesKey = this.suningConfig.getDuibaAesKey();
            JSONObject ret = JSONObject.parseObject((String)body);
            if (null == ret) {
                throw new BizException("\u5f00\u53d1\u8005\u63a5\u53e3\u54cd\u5e94\u5185\u5bb9\u5f02\u5e38");
            }
            Map<String, Object> paramMap = SuningSignUtils.decrypt(aesKey, (Map<String, Object>)ret);
            String code = String.valueOf(paramMap.get("responseCode"));
            if (!StringUtils.equals((String)"0000", (String)code)) {
                throw new BizException(String.valueOf(paramMap.get("responseMsg")));
            }
            duibaDoc.put("status", "success");
            String data = JSONObject.toJSONString(paramMap);
            if (StringUtils.isNotBlank((String)data) && data.length() > 1900) {
                data = data.substring(0, 1900);
            }
            duibaDoc.put("data", data);
        }
        catch (Exception e) {
            duibaDoc.put("status", "fail");
            duibaDoc.put("errorMessage", e.getMessage());
            LOGGER.error("[SuningApi-getVirtualResponse] Params:[message={},body={}], Msg:\u82cf\u5b81\u91d1\u878d-\u865a\u62df\u5546\u54c1\u63a5\u53e3\u54cd\u5e94\u89e3\u6790\u5f02\u5e38", new Object[]{JSONObject.toJSONString((Object)message), body, e});
        }
        return JsonTool.objectToJson(duibaDoc);
    }
}

