/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.biz.credits;

import cn.com.duiba.biz.Exception.ThirdpatyException;
import cn.com.duiba.constant.UnionPayConstants;
import cn.com.duiba.domain.SupplierRequest;
import cn.com.duiba.tool.AssembleTool;
import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UnionPayApi {
    private static final Logger LOGGER = LoggerFactory.getLogger(UnionPayApi.class);
    @Autowired
    private UnionPayConstants unionPayConstants;

    public boolean isUnionPayApp(Long appId) {
        return this.unionPayConstants.getAppIds().contains(appId);
    }

    public HttpRequestBase getVirtualRequest(SupplierRequest request) {
        String url = request.getHttpUrl();
        String authParams = url.substring(url.indexOf(63) + 1);
        Map<String, String> authParamMap = AssembleTool.getUrlParams(authParams);
        String goodsNum = authParamMap.get("params");
        if (StringUtils.isBlank((CharSequence)goodsNum) || !goodsNum.startsWith(this.unionPayConstants.getPrefix())) {
            return new HttpGet(url);
        }
        Map<String, String> requestParams = this.buildVirtualRequestParams(authParamMap);
        HttpPost post = new HttpPost(this.unionPayConstants.getVirtualUrl());
        post.setEntity((HttpEntity)new StringEntity(JSON.toJSONString(requestParams), ContentType.APPLICATION_JSON));
        return post;
    }

    private Map<String, String> buildVirtualRequestParams(Map<String, String> authParamMap) {
        HashMap<String, String> requestParams = new HashMap<String, String>();
        requestParams.put("appId", this.unionPayConstants.getDeveloperId());
        requestParams.put("transSeqId", authParamMap.get("orderNum"));
        requestParams.put("transTs", DateUtil.format((Date)new Date(), (String)"yyyyMMdd"));
        requestParams.put("couponId", authParamMap.get("params").replaceAll(this.unionPayConstants.getPrefix(), ""));
        requestParams.put("openId", authParamMap.get("uid"));
        requestParams.put("acctEntityTp", "03");
        requestParams.put("couponNum", "1");
        requestParams.put("nonceStr", this.createNonceStr());
        requestParams.put("timestamp", Long.toString(System.currentTimeMillis() / 1000L));
        requestParams.put("signature", this.sign(requestParams, this.unionPayConstants.getPrivateKey()));
        return requestParams;
    }

    public String getVirtualResponse(SupplierRequest message, String body) {
        String url = message.getHttpUrl();
        String authParams = url.substring(url.indexOf(63) + 1);
        Map<String, String> authParamMap = AssembleTool.getUrlParams(authParams);
        String goodsNum = authParamMap.get("params");
        if (StringUtils.isBlank((CharSequence)goodsNum) || !goodsNum.startsWith(this.unionPayConstants.getPrefix())) {
            return body;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        if (StringUtils.isBlank((CharSequence)body)) {
            throw new ThirdpatyException("\u4e91\u95ea\u4ed8\uff0c\u865a\u62df\u5546\u54c1\u5b9a\u5236\uff0c\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a");
        }
        LOGGER.info("\u4e91\u95ea\u4ed8\u5b9a\u5236\u8fd4\u56de\u7ed3\u679c\u4e3a:{}", (Object)(body.length() > 500 ? body.substring(0, 500) : body));
        try {
            JSONObject jsonObject = JSON.parseObject((String)body);
            map.put("status", Objects.equals("00", jsonObject.getString("resp")) ? "success" : "fail");
            map.put("errorMessage", jsonObject.getString("msg"));
            map.put("supplierBizId", jsonObject.getString("transSeqId"));
        }
        catch (Exception e) {
            LOGGER.error("\u4e91\u95ea\u4ed8\uff0c\u865a\u62df\u5546\u54c1\u5b9a\u5236\uff0c\u7ed3\u679c\u89e3\u6790\u9519\u8bef:{}", (Object)body, (Object)e);
            map.put("status", "fail");
            map.put("errorMessage", "\u865a\u62df\u5546\u54c1\u5145\u503c\u63a5\u53e3\u54cd\u5e94\u89e3\u6790\u9519\u8bef");
        }
        return JSON.toJSONString(map);
    }

    public String createNonceStr() {
        String sl = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 16; ++i) {
            sb.append(sl.charAt(new Random().nextInt(sl.length())));
        }
        return sb.toString();
    }

    public String sign(Map<String, String> param, String signKey) {
        try {
            String value = UnionPayApi.sortMap(param);
            LOGGER.info("\u4e91\u95ea\u4ed8\u5b9a\u5236\u7b7e\u540d\u539f\u4e32\u4e3a:{}", (Object)value);
            byte[] keyBytes = Base64.decodeBase64((String)signKey);
            PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(keyBytes);
            KeyFactory keyf = KeyFactory.getInstance("RSA");
            PrivateKey priKey = keyf.generatePrivate(keySpec);
            Signature signature = Signature.getInstance("SHA256WithRSA");
            signature.initSign(priKey);
            signature.update(value.getBytes());
            byte[] signed = signature.sign();
            return Base64.encodeBase64String((byte[])signed);
        }
        catch (Exception e) {
            LOGGER.error("\u4e91\u95ea\u4ed8\u5b9a\u5236\u7b7e\u540d\u5931\u8d25", (Throwable)e);
            throw new ThirdpatyException("\u4e91\u95ea\u4ed8\u5b9a\u5236\u7b7e\u540d\u5931\u8d25");
        }
    }

    public static String sortMap(Map<String, String> param) {
        StringBuilder result = new StringBuilder();
        Set<String> keySet = param.keySet();
        ArrayList<String> list = new ArrayList<String>(keySet);
        Collections.sort(list);
        for (int i = 0; i < list.size(); ++i) {
            String key = (String)list.get(i);
            if ("symmetricKey".equals(key)) continue;
            result.append(key).append("=").append(param.get(key)).append("&");
        }
        String sortMap = result.substring(0, result.length() - 1);
        return sortMap;
    }
}

