/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.biz.credits;

import cn.com.duiba.biz.Exception.ThirdpatyException;
import cn.com.duiba.domain.SubCreditsMsgWrapper;
import cn.com.duiba.dto.WjrcbCreditsRequestDto;
import cn.com.duiba.dto.WjrcbCreditsResultDto;
import cn.com.duiba.dto.WjrcbRequestMessage;
import cn.com.duiba.dto.WjrcbRequestMessageHead;
import cn.com.duiba.dto.WjrcbRequestNotifyDto;
import cn.com.duiba.dto.WjrcbResponseMessage;
import cn.com.duiba.notifycenter.domain.NotifyQueueDO;
import cn.com.duiba.order.center.api.dto.CreditsMessage;
import cn.com.duiba.tool.AssembleTool;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.fasterxml.jackson.dataformat.xml.ser.ToXmlGenerator;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import javax.annotation.PostConstruct;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class WjrcbApi {
    private static final Logger log = LoggerFactory.getLogger(WjrcbApi.class);
    private static final String SUCCESS_CODE = "000000";
    private XmlMapper xmlMapper = new XmlMapper();

    @PostConstruct
    public void initXmlMapper() {
        this.xmlMapper.configure(ToXmlGenerator.Feature.WRITE_XML_DECLARATION, true);
        this.xmlMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    public boolean isWjrcb(Long appId) {
        return Objects.equals(62363L, appId);
    }

    public HttpRequestBase getSubCreditsHttpRequest(CreditsMessage message) {
        String url = message.getHttpUrl();
        String newUrl = this.getNewUrl(url);
        String paramsStr = url.substring(url.indexOf(63) + 1);
        Map<String, String> params = AssembleTool.getUrlParams(paramsStr);
        message.setHttpType("post");
        message.setHttpUrl(newUrl);
        message.setAuthParams(params);
        return this.getSubCreditsHttpPost(message.getHttpUrl(), params);
    }

    public HttpRequestBase getMqSubCreditsHttpRequest(SubCreditsMsgWrapper message) {
        String url = message.getHttpUrl();
        String newUrl = url.substring(0, url.indexOf(63));
        String paramsStr = url.substring(url.indexOf(63) + 1);
        Map<String, String> params = AssembleTool.getUrlParams(paramsStr);
        message.getSubCreditsMsg().setHttpType(2);
        message.setHttpUrl(newUrl);
        message.getSubCreditsMsg().setAuthParams(params);
        return this.getSubCreditsHttpPost(message.getHttpUrl(), params);
    }

    public String parseCreditsRsp(String body) {
        WjrcbResponseMessage message;
        log.info("\u82cf\u5dde\u519c\u5546\u6263\u79ef\u5206response, body={}", (Object)body);
        try {
            message = (WjrcbResponseMessage)this.xmlMapper.readValue(body, (TypeReference)new TypeReference<WjrcbResponseMessage<WjrcbCreditsResultDto>>(){});
        }
        catch (Exception e) {
            log.error("\u82cf\u5dde\u519c\u5546xml\u53cd\u5e8f\u5217\u5316\u5931\u8d25, body={}", (Object)body, (Object)e);
            return body;
        }
        JSONObject json = new JSONObject();
        json.put("errorMessage", (Object)message.getHead().getRejMsg());
        if (SUCCESS_CODE.equals(message.getHead().getRejCode()) && message.getBody() != null) {
            json.put("status", (Object)(Objects.equals("S", ((WjrcbCreditsResultDto)message.getBody()).getStatus()) ? "ok" : "fail"));
            json.put("bizId", (Object)((WjrcbCreditsResultDto)message.getBody()).getTransSeq());
            json.put("credits", (Object)((WjrcbCreditsResultDto)message.getBody()).getCredits());
        } else {
            json.put("status", (Object)"fail");
        }
        return json.toString();
    }

    public HttpRequestBase getRequestNotify(String notifyUrl, NotifyQueueDO record) {
        String content;
        String transfer = record.getTransfer();
        Map<String, String> transferMap = this.getTransferMap(transfer);
        WjrcbRequestMessage<WjrcbRequestNotifyDto> message = new WjrcbRequestMessage<WjrcbRequestNotifyDto>();
        WjrcbRequestMessageHead head = new WjrcbRequestMessageHead(new Date());
        head.setTransactionId("ResultNotify");
        if (MapUtils.isNotEmpty(transferMap)) {
            head.setIdType(transferMap.get("IdType"));
            head.setIdNo(transferMap.get("IdNo"));
        }
        message.setHead(head);
        WjrcbRequestNotifyDto body = new WjrcbRequestNotifyDto();
        body.setBizId(record.getDeveloperBizId());
        body.setStatus(Boolean.TRUE.equals(record.getResult()) ? "S" : "F");
        body.setUserId(record.getPartnerUserId());
        body.setOrderNum(record.getDuibaOrderNum());
        message.setBody(body);
        try {
            content = this.xmlMapper.writeValueAsString(message);
        }
        catch (Exception e) {
            log.error("\u82cf\u5dde\u519c\u5546xml\u5e8f\u5217\u5316\u5f02\u5e38, content={}", (Object)JSON.toJSONString(message), (Object)e);
            throw new ThirdpatyException("xml\u5e8f\u5217\u5316\u5f02\u5e38");
        }
        HttpPost request = new HttpPost(notifyUrl);
        request.addHeader("accept", "text/b2exml; charset=GBK");
        request.setEntity((HttpEntity)new StringEntity(content, ContentType.create((String)"application/stream")));
        return request;
    }

    public String getResponseNotify(String body) {
        WjrcbResponseMessage message;
        log.info("\u82cf\u5dde\u519c\u5546\u901a\u77e5response, body={}", (Object)body);
        try {
            message = (WjrcbResponseMessage)this.xmlMapper.readValue(body, (TypeReference)new TypeReference<WjrcbResponseMessage<Object>>(){});
        }
        catch (Exception e) {
            log.error("\u82cf\u5dde\u519c\u5546xml\u53cd\u5e8f\u5217\u5316\u5931\u8d25, body={}", (Object)body, (Object)e);
            return body;
        }
        if (SUCCESS_CODE.equals(message.getHead().getRejCode())) {
            return "ok";
        }
        return body;
    }

    private String getNewUrl(String url) {
        return url.substring(0, url.indexOf(63));
    }

    private HttpRequestBase getSubCreditsHttpPost(String httpUrl, Map<String, String> params) {
        String content = this.getSubCreditsMessage(params);
        HttpPost request = new HttpPost(httpUrl);
        request.addHeader("accept", "text/b2exml; charset=GBK");
        request.setEntity((HttpEntity)new StringEntity(content, ContentType.create((String)"application/stream")));
        return request;
    }

    private String getSubCreditsMessage(Map<String, String> params) {
        String transfer = params.get("transfer");
        Map<String, String> transferMap = this.getTransferMap(transfer);
        WjrcbRequestMessage<WjrcbCreditsRequestDto> request = new WjrcbRequestMessage<WjrcbCreditsRequestDto>();
        WjrcbRequestMessageHead head = new WjrcbRequestMessageHead(new Date());
        head.setTransactionId("PointAdjust");
        if (MapUtils.isNotEmpty(transferMap)) {
            head.setIdType(transferMap.get("IdType"));
            head.setIdNo(transferMap.get("IdNo"));
        }
        request.setHead(head);
        WjrcbCreditsRequestDto body = new WjrcbCreditsRequestDto();
        body.setOrderNum(params.get("orderNum"));
        body.setUserId(params.get("uid"));
        body.setCredits(params.get("credits"));
        body.setDescription(params.get("description"));
        body.setOrderType(params.get("type"));
        body.setOrderAmount(params.get("facePrice"));
        body.setActualPrice(params.get("actualPrice"));
        body.setParams(params.get("params"));
        body.setEvent("ExchangeEvent");
        request.setBody(body);
        try {
            return this.xmlMapper.writeValueAsString(request);
        }
        catch (Exception e) {
            log.error("\u82cf\u5dde\u519c\u5546\u6263\u79ef\u5206\u53c2\u6570xml\u5e8f\u5217\u5316\u5f02\u5e38, content={}", (Object)JSON.toJSONString(request), (Object)e);
            throw new ThirdpatyException("\u82cf\u5dde\u519c\u5546\u6263\u79ef\u5206\u53c2\u6570xml\u5e8f\u5217\u5316\u5f02\u5e38");
        }
    }

    private Map<String, String> getTransferMap(String encodedTransfer) {
        String transfer;
        if (StringUtils.isEmpty((String)encodedTransfer)) {
            return null;
        }
        try {
            transfer = URLDecoder.decode(encodedTransfer, StandardCharsets.UTF_8.toString());
        }
        catch (Exception e) {
            log.error("\u82cf\u5dde\u519c\u5546transfer\u89e3\u7801\u5f02\u5e38, transfer={}", (Object)encodedTransfer, (Object)e);
            return null;
        }
        return AssembleTool.getUrlParams(transfer);
    }
}

