/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.biz.credits;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.credits.sdk.SignTool;
import cn.com.duiba.domain.SupplierRequest;
import cn.com.duiba.tool.AssembleTool;
import cn.com.duiba.tool.JsonTool;
import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class YunJiApi {
    private static final Logger logger = LoggerFactory.getLogger(YunJiApi.class);

    public SupplierRequest getVirtualRequest(SupplierRequest request) {
        try {
            String url = request.getHttpUrl();
            List<String> analysisList = AssembleTool.analysisUrl(url);
            if (analysisList.isEmpty()) {
                return request;
            }
            String host = analysisList.get(0);
            Map<String, String> params = AssembleTool.getUrlParams(analysisList.get(1));
            LinkedHashMap<String, String> authParams = new LinkedHashMap<String, String>();
            authParams.put("consumerId", params.get("uid"));
            authParams.put("couponType", params.get("params"));
            authParams.put("key", "yunji");
            String sign = SignTool.sign(authParams);
            authParams.put("sign", sign);
            authParams.remove("key");
            request.setHttpUrl(AssembleTool.assembleUrl(host, authParams));
        }
        catch (Exception e) {
            logger.info("[YunJiApi-getVirtualRequest]error Params:[request={}], Msg:\u4e91\u96c6-\u865a\u62df\u5546\u54c1\u5b9a\u5236\u903b\u8f91\u5f02\u5e38", (Object)JSONObject.toJSONString((Object)request), (Object)e);
        }
        return request;
    }

    public String getVirtualResponse(SupplierRequest message, String body) {
        HashMap<String, String> duibaDoc = new HashMap<String, String>();
        try {
            JSONObject resultJson = JSONObject.parseObject((String)body);
            if (null == resultJson) {
                throw new BizException("\u5f00\u53d1\u8005\u63a5\u53e3\u54cd\u5e94\u5185\u5bb9\u5f02\u5e38");
            }
            Integer status = resultJson.getInteger("errorCode");
            if (!Objects.equals(0, status)) {
                throw new BizException(resultJson.getString("errorMessage"));
            }
            duibaDoc.put("status", "success");
            duibaDoc.put("data", body);
        }
        catch (Exception e) {
            duibaDoc.put("status", "fail");
            duibaDoc.put("errorMessage", e.getMessage());
            logger.info("[YunJiApi-getVirtualResponse] Params:[message={},body={}], Msg:\u4e91\u96c6-\u865a\u62df\u5546\u54c1\u63a5\u53e3\u54cd\u5e94\u89e3\u6790\u5f02\u5e38", new Object[]{JSONObject.toJSONString((Object)message), body, e});
        }
        return JsonTool.objectToJson(duibaDoc);
    }
}

