/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.biz.credits;

import cn.com.duiba.biz.Exception.ThirdpatyException;
import cn.com.duiba.constant.ZHCreditsConfig;
import cn.com.duiba.credits.sdk.SignTool;
import cn.com.duiba.dao.AppDAO;
import cn.com.duiba.domain.AppDO;
import cn.com.duiba.thirdparty.dto.HttpRequestMessageDto;
import cn.com.duiba.tool.AssembleTool;
import cn.com.duiba.tool.HttpRequestLog;
import com.alibaba.fastjson.JSONObject;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ZhbSyncApi {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZhbSyncApi.class);
    @Autowired
    private AppDAO appDAO;
    @Autowired
    private ZHCreditsConfig zhCreditsConfig;

    public HttpRequestBase getCrecordNotify(HttpRequestMessageDto msg, AppDO app) {
        Map authParams = msg.getHttpParams();
        authParams.put("appKey", app.getAppKey());
        authParams.put("appSecret", this.appDAO.getAppSecret(app));
        String sign = SignTool.sign((Map)authParams);
        authParams.put("sign", sign);
        authParams.remove("appSecret");
        String url = this.zhCreditsConfig.getCrecordNotifyUrl();
        if (StringUtils.isBlank((String)url)) {
            throw new ThirdpatyException("\u4e2d\u5b8f\u4fdd\u5151\u6362\u8bb0\u5f55\u540c\u6b65url is not config");
        }
        HttpPost http = AssembleTool.assemblePostRequest(url, JSONObject.toJSONString((Object)authParams));
        HttpRequestLog.logUrl("[action crecord] [tag post request] [url " + url + "][param " + authParams + "]");
        return http;
    }

    public boolean isZHBApp(Long appId) {
        return this.zhCreditsConfig.isZHBApp(appId);
    }
}

