/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.biz.credits.impl;

import cn.com.duiba.api.bo.subcredits.SubCreditsMsgDto;
import cn.com.duiba.biz.credits.CustomParamService;
import cn.com.duiba.constant.CustomParamConstant;
import cn.com.duiba.credits.sdk.SignTool;
import cn.com.duiba.domain.SubCreditsMsgWrapper;
import cn.com.duiba.tool.AssembleTool;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CustomParamServiceImpl
implements CustomParamService {
    @Autowired
    private CustomParamConstant customParamConstant;

    @Override
    public SubCreditsMsgWrapper getSubCreditsMessage(SubCreditsMsgWrapper subCreditsMsgWrapper) {
        SubCreditsMsgDto subCreditsMsg = subCreditsMsgWrapper.getSubCreditsMsg();
        if (null == subCreditsMsg.getParams()) {
            return subCreditsMsgWrapper;
        }
        if (null == subCreditsMsg.getRelationType() || !StringUtils.equals((String)subCreditsMsg.getRelationType().getMsg(), (String)"mall")) {
            return subCreditsMsgWrapper;
        }
        Map map = subCreditsMsg.getCreditConsumeParams().toRequestMap(subCreditsMsg.getAppSecret());
        map.remove("sign");
        map.putAll(subCreditsMsg.getParams());
        map.put("appSecret", subCreditsMsg.getAppSecret());
        map.put("sign", SignTool.sign((Map)map));
        map.remove("appSecret");
        subCreditsMsgWrapper.setHttpUrl(AssembleTool.assembleUrl(subCreditsMsg.getCreditsConsumeRequestUrl(), map));
        return subCreditsMsgWrapper;
    }

    @Override
    public boolean isCustomParamApp(Long appId) {
        if (CollectionUtils.isEmpty(this.customParamConstant.getSubCreditsAppIds())) {
            return false;
        }
        return this.customParamConstant.getSubCreditsAppIds().contains(appId);
    }
}

