/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.biz.credits.strategy.Impl;

import cn.com.duiba.api.tools.RandomCodeUtil;
import cn.com.duiba.biz.credits.strategy.ApiStrategy;
import cn.com.duiba.constant.TailongBankConfig;
import cn.com.duiba.credits.sdk.CreditConsumeParams;
import cn.com.duiba.domain.AppDO;
import cn.com.duiba.domain.SubCreditsMsgWrapper;
import cn.com.duiba.domain.SupplierRequest;
import cn.com.duiba.notifycenter.domain.NotifyQueueDO;
import cn.com.duiba.thirdparty.dto.CreditsMessageDto;
import cn.com.duiba.thirdparty.dto.HttpRequestMessageDto;
import cn.com.duiba.tool.AssembleTool;
import cn.com.duiba.tool.JsonTool;
import cn.com.duiba.wolf.utils.DateUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import com.zjtlcb.fcloud.utils.MD5Util;
import com.zjtlcb.fcloud.utils.SM2Util;
import com.zjtlcb.fcloud.utils.SM3Util;
import com.zjtlcb.fcloud.utils.SM4Util;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class TailongApiStrategy
implements ApiStrategy {
    private static final Logger log = LoggerFactory.getLogger(TailongApiStrategy.class);
    public static final String ADD_CREDITS = "01";
    public static final String SUB_CREDITS = "02";
    @Autowired
    private TailongBankConfig tailongBankConfig;
    @Resource(name="redisTemplate")
    private RedisTemplate<String, String> redisTemplate;

    @Override
    public boolean isCustomCrecord(HttpRequestMessageDto dto) {
        String orderNum = (String)dto.getHttpParams().get("orderNum");
        boolean result = StringUtils.isNotBlank((CharSequence)orderNum);
        return result;
    }

    @Override
    public HttpRequestBase getMqSubCreditsHttpRequest(SubCreditsMsgWrapper message) {
        log.info("\u6cf0\u9686\u94f6\u884c\u6263\u79ef\u5206\u8bf7\u6c42 :{}", (Object)JSON.toJSONString((Object)message));
        CreditConsumeParams creditConsumeParams = message.getSubCreditsMsg().getCreditConsumeParams();
        Map<String, String> params = this.getParamMap(creditConsumeParams.getOrderNum(), creditConsumeParams.getUid());
        params.put("operationType", SUB_CREDITS);
        params.put("pntOccrCnt", creditConsumeParams.getCredits().toString());
        params.put("remark", creditConsumeParams.getDescription());
        params.put("avyTp", creditConsumeParams.getType());
        return this.getHttpRequestBase(params, this.getHeaderMap(creditConsumeParams.getOrderNum(), 2), "mallPntBalChg", null);
    }

    @Override
    public String parseCreditsRsp(String body, Boolean addCredits, Map<String, String> authParams) {
        log.info("\u6cf0\u9686\u94f6\u884c\u6263\u79ef\u5206\u54cd\u5e94 :{}", (Object)body);
        JSONObject jsonBody = this.getResponse(body);
        HashMap<String, String> duibaDoc = new HashMap<String, String>();
        Boolean flag = "S".equals(jsonBody.getString("status"));
        duibaDoc.put("status", flag != false ? "ok" : "fail");
        duibaDoc.put("errorMessage", jsonBody.getString("dscrptnRsn"));
        duibaDoc.put("bizId", jsonBody.getString("serialId"));
        Long credits = null;
        try {
            credits = this.getCredits(authParams.get("uid"));
        }
        catch (Exception e) {
            log.warn("\u6cf0\u9686\u94f6\u884c\u79ef\u5206\u83b7\u53d6\u5f02\u5e38,", (Throwable)e);
        }
        if (credits == null) {
            log.warn("\u6cf0\u9686\u94f6\u884c\u79ef\u5206\u83b7\u53d6\u5f02\u5e38,:body{},authParams:{}", (Object)jsonBody.toString(), authParams);
            return JsonTool.objectToJson(duibaDoc);
        }
        duibaDoc.put("credits", credits.toString());
        return JsonTool.objectToJson(duibaDoc);
    }

    @Override
    public HttpRequestBase getAddCreditsMessageRequest(CreditsMessageDto message) {
        log.info("\u6cf0\u9686\u94f6\u884c\u52a0\u79ef\u5206 :{}", (Object)JSON.toJSONString((Object)message));
        String url = message.getHttpUrl().substring(0, message.getHttpUrl().indexOf(63));
        Map authParams = message.getAuthParams();
        String orderNum = (String)authParams.get("orderNum");
        String uid = (String)authParams.get("uid");
        Map<String, String> params = this.getParamMap(orderNum, uid);
        params.put("operationType", ADD_CREDITS);
        params.put("pntOccrCnt", (String)authParams.get("credits"));
        String description = (String)authParams.get("description");
        params.put("remark", StringUtils.isBlank((CharSequence)description) ? "\u5151\u5427\u52a0\u79ef\u5206" : description);
        return this.getHttpRequestBase(params, this.getHeaderMap(orderNum, 1), "mallPntBalChg", url);
    }

    @Override
    public HttpRequestBase getRequestNotify(String notifyUrl, NotifyQueueDO record) {
        log.info("\u6cf0\u9686\u94f6\u884c\u83b7\u53d6\u5151\u6362\u7ed3\u679c\u901a\u77e5 :{}\uff0curl:{}", (Object)JSON.toJSONString((Object)record), (Object)notifyUrl);
        Map<String, String> params = this.getParamMap(record.getDuibaOrderNum(), record.getPartnerUserId());
        params.put("ordrSt", record.getResult() != false ? "S" : "F");
        params.put("remark", record.getError4developer());
        params.put("trPrInetNo", record.getDuibaOrderNum());
        params.put("serialId", record.getDeveloperBizId());
        params.remove("inetNo");
        return this.getHttpRequestBase(params, this.getHeaderMap(record.getDuibaOrderNum(), 3), "pntAddDdcbRsltNtc", notifyUrl);
    }

    @Override
    public String getResponseNotify(String body) {
        JSONObject rspJsonObj = JSON.parseObject((String)body);
        try {
            if (rspJsonObj.containsKey((Object)"rspData")) {
                String sm2Key = SM2Util.decryptByPrivateKey((String)rspJsonObj.getString("sm2EncryptData"), (String)this.tailongBankConfig.getSm2PrivateKey());
                rspJsonObj.put("sm2EncryptData", (Object)sm2Key);
                if (!SM2Util.verifyByPublicKey((String)rspJsonObj.getString("sm2Sign"), (String)this.tailongBankConfig.getTlPublicKey(), (String)this.tailongBankConfig.getMechAppID(), (String)sm2Key)) {
                    log.info("\u8eab\u4efd\u8ba4\u8bc1-SM2\u9a8c\u7b7e\u5931\u8d25");
                    return rspJsonObj.toString();
                }
                String rspData = SM4Util.decrypt((String)rspJsonObj.getString("rspData"), (String)(rspJsonObj.getString("seqNO") + this.getTLToken() + this.tailongBankConfig.getAppSecretKey() + sm2Key));
                log.info("\u6cf0\u9686\u94f6\u884c\u89e3\u5bc6\u540e\u62a5\u6587\uff1a" + rspData);
                if (SM3Util.verify((String)(rspData + rspJsonObj.getString("seqNO") + this.tailongBankConfig.getAppSecretKey() + sm2Key), (String)rspJsonObj.getString("sign"))) {
                    String status = JSON.parseObject((String)rspData).getJSONObject("body").getString("status");
                    if (StringUtils.equals((CharSequence)"S", (CharSequence)status)) {
                        return "ok";
                    }
                    return rspData;
                }
                log.info("\u62a5\u6587\u4e00\u81f4\u6027\u6821\u9a8c\u5931\u8d25");
                return rspJsonObj.toString();
            }
        }
        catch (Exception e) {
            log.warn(" \u6cf0\u9686\u94f6\u884c  getResponseNotify  body = {}", (Object)body, (Object)e);
            return body;
        }
        return body;
    }

    @Override
    public HttpRequestBase getCrecordNotify(HttpRequestMessageDto msg, AppDO app) {
        log.info("\u6cf0\u9686\u94f6\u884c\u83b7\u53d6\u5151\u6362\u8bb0\u5f55\u540c\u6b65http\u5305\u88c5\u7c7b :{}\uff0curl:{}", (Object)JSON.toJSONString((Object)msg));
        Map<String, String> params = this.getParamMap(null, (String)msg.getHttpParams().get("uid"));
        params.put("mechNo", this.tailongBankConfig.getMechNo());
        params.put("mechName", this.tailongBankConfig.getMechName());
        params.put("sourceName", this.tailongBankConfig.getMechName());
        params.put("inetTmstmp", this.getDateStr((String)msg.getHttpParams().get("timestamp")));
        params.put("cnsmPnt", (String)msg.getHttpParams().get("credits"));
        params.put("giftNm", (String)msg.getHttpParams().get("title"));
        String unitPrice = (String)msg.getHttpParams().get("unitPrice");
        params.put("unitPrice", this.transformFen2Yuan(unitPrice));
        params.put("trPrInetNo", (String)msg.getHttpParams().get("orderNum"));
        params.put("avyTp", (String)msg.getHttpParams().get("chargeMode"));
        params.put("avyNm", (String)msg.getHttpParams().get("avyNm"));
        params.put("remark", (String)msg.getHttpParams().get("error4Developer"));
        params.put("ordrSt", StringUtils.equals((CharSequence)((CharSequence)msg.getHttpParams().get("status")), (CharSequence)"success") ? "S" : "F");
        return this.getHttpRequestBase(params, this.getHeaderMap((String)msg.getHttpParams().get("orderNum"), 4), "actRsltNtc", app.getRecordNotifyUrl());
    }

    @Override
    public String getCrecordResponse(String body) {
        log.info("\u6cf0\u9686\u5b9a\u5236\u540c\u6b65\u5151\u6362\u8bb0\u5f55\u54cd\u5e94, request={}", (Object)body);
        return this.getResponseNotify(body);
    }

    @Override
    public HttpRequestBase getVirtualRequest(SupplierRequest request) {
        log.info("\u6cf0\u9686\u865a\u62df\u5546\u54c1\u8bf7\u6c42, request={}", (Object)JSON.toJSONString((Object)request));
        String url = request.getHttpUrl();
        String paramsStr = url.substring(url.indexOf(63) + 1);
        Map<String, String> authParams = AssembleTool.getUrlParams(paramsStr);
        String goodsNum = authParams.get("params");
        if (StringUtils.isNotBlank((CharSequence)goodsNum) && goodsNum.startsWith(this.tailongBankConfig.getVirtualCreditsPre())) {
            authParams.put("credits", goodsNum.replace(this.tailongBankConfig.getVirtualCreditsPre(), ""));
            CreditsMessageDto dto = new CreditsMessageDto();
            dto.setAuthParams(authParams);
            dto.setHttpUrl(url);
            dto.setAuthParams(authParams);
            request.setSaveReconciliationRecord(true);
            request.setAuthParams(authParams);
            return this.getAddCreditsMessageRequest(dto);
        }
        log.warn("\u6cf0\u9686\u94f6\u884c\u672a\u5b9a\u5236\u865a\u62df\u5151\u6362\u63a5\u53e3 param:{}", (Object)JSON.toJSONString(authParams));
        throw new RuntimeException("\u6cf0\u9686\u94f6\u884c\u672a\u5b9a\u5236\u865a\u62df\u5151\u6362\u63a5\u53e3");
    }

    @Override
    public String getVirtualResponse(SupplierRequest request, String body) {
        log.info("\u6cf0\u9686\u865a\u62df\u5546\u54c1\u52a0\u79ef\u5206\u54cd\u5e94\u7ed3\u679cresponse, body={}", (Object)body);
        Map<String, String> params = request.getAuthParams();
        String goodsNum = "";
        if (params != null) {
            goodsNum = params.get("params");
        }
        if (StringUtils.isNotBlank((CharSequence)goodsNum) && goodsNum.startsWith(this.tailongBankConfig.getVirtualCreditsPre())) {
            String flag = this.getResponseNotify(body);
            JSONObject result = new JSONObject();
            if ("ok".equals(flag)) {
                result.put("status", (Object)"success");
                return result.toString();
            }
            result.put("status", (Object)"fail");
            if (flag != null) {
                result.put("errorMessage", (Object)JSON.parseObject((String)flag).getJSONObject("body").getString("dscrptnRsn"));
            }
            return result.toString();
        }
        log.warn("\u6cf0\u9686\u94f6\u884c\u672a\u5b9a\u5236\u865a\u62df\u5151\u6362\u63a5\u53e3\u54cd\u5e94\u5f02\u5e38 param:{}", (Object)JSON.toJSONString(params));
        throw new RuntimeException("\u6cf0\u9686\u94f6\u884c\u672a\u5b9a\u5236\u865a\u62df\u5151\u6362\u63a5\u53e3\u54cd\u5e94\u5f02\u5e38");
    }

    private HttpRequestBase getHttpRequestBase(Map<String, String> paramMap, Map<String, String> headMap, String serviceId, String url) {
        JSONObject reqMsg = new JSONObject();
        HashMap<String, Map<String, String>> map = new HashMap<String, Map<String, String>>();
        map.put("head", headMap);
        map.put("body", paramMap);
        reqMsg.put("reqData", JSON.toJSON(map));
        reqMsg.put("appID", (Object)this.tailongBankConfig.getMechAppID());
        reqMsg.put("seqNO", (Object)new SimpleDateFormat("yyyyMMddHHmmsss").format(new Date()));
        reqMsg.put("signMethod", (Object)"SM3");
        reqMsg.put("encryptMethod", (Object)"SM4");
        reqMsg.put("appAccessToken", (Object)this.getTLToken());
        log.info("\u6cf0\u9686\u94f6\u884c\u8c03\u7528\u670d\u52a1\uff1a" + this.tailongBankConfig.getTlHttpUrl() + serviceId + "   \u539f\u8bf7\u6c42\u62a5\u6587\uff1a" + reqMsg.toJSONString());
        String randomKey = MD5Util.md5_((String)UUID.randomUUID().toString());
        HttpPost httpPost = null;
        try {
            reqMsg.put("sm2EncryptData", (Object)SM2Util.encryptByPublicKey((String)randomKey, (String)this.tailongBankConfig.getTlPublicKey()));
            reqMsg.put("sm2Sign", (Object)SM2Util.signByPrivateKey((String)randomKey, (String)this.tailongBankConfig.getSm2PrivateKey(), (String)this.tailongBankConfig.getMechAppID()));
            reqMsg.put("sign", (Object)SM3Util.sign((String)(reqMsg.getString("reqData") + reqMsg.getString("seqNO") + this.tailongBankConfig.getAppSecretKey() + randomKey)));
            reqMsg.put("reqData", (Object)SM4Util.encrypt((String)reqMsg.getString("reqData"), (String)(reqMsg.getString("seqNO") + reqMsg.getString("appAccessToken") + this.tailongBankConfig.getAppSecretKey() + randomKey)));
            log.info("\u6cf0\u9686\u94f6\u884cTL\u8bf7\u6c42\u62a5\u6587\uff1a" + reqMsg.toJSONString());
            httpPost = new HttpPost(this.tailongBankConfig.getTlHttpUrl() + serviceId);
            ByteArrayEntity bae = new ByteArrayEntity(reqMsg.toJSONString().getBytes());
            httpPost.setEntity((HttpEntity)bae);
            httpPost.addHeader("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8");
        }
        catch (Exception e) {
            log.warn("\u6cf0\u9686\u94f6\u884c getHttpRequestBase", (Throwable)e);
        }
        return httpPost;
    }

    private String getTLToken() {
        String appAccessToken = (String)this.redisTemplate.opsForValue().get((Object)this.tailongBankConfig.getAccessTokenRedisKey());
        if (StringUtils.isNotBlank((CharSequence)appAccessToken)) {
            return appAccessToken;
        }
        try {
            JSONObject reqMsg = new JSONObject();
            String seqNO = new SimpleDateFormat("yyyyMMddHHmmsss").format(new Date());
            reqMsg.put("appID", (Object)this.tailongBankConfig.getMechAppID());
            reqMsg.put("seqNO", (Object)seqNO);
            reqMsg.put("random", (Object)MD5Util.md5_((String)seqNO));
            String randomKey = MD5Util.md5_((String)UUID.randomUUID().toString());
            reqMsg.put("sm2EncryptData", (Object)SM2Util.encryptByPublicKey((String)randomKey, (String)this.tailongBankConfig.getTlPublicKey()));
            reqMsg.put("sm2Sign", (Object)SM2Util.signByPrivateKey((String)randomKey, (String)this.tailongBankConfig.getSm2PrivateKey(), (String)this.tailongBankConfig.getMechAppID()));
            reqMsg.put("sign", (Object)SM3Util.sign((String)(reqMsg.getString("random") + reqMsg.getString("seqNO") + this.tailongBankConfig.getAppSecretKey() + randomKey)));
            log.info("\u6cf0\u9686\u94f6\u884c\u8c03\u7528\u670d\u52a1\uff1aapproveDev,TL\u8bf7\u6c42\u62a5\u6587\uff1a" + reqMsg.toJSONString());
            String rspMsg = this.doPost(reqMsg.toJSONString(), this.tailongBankConfig.getTlHttpUrl() + "approveDev");
            log.info("\u6cf0\u9686\u94f6\u884c\u54cd\u5e94\u62a5\u6587\uff1a" + rspMsg);
            JSONObject rspJsonObj = JSON.parseObject((String)rspMsg);
            String token = "";
            if (!rspJsonObj.getString("errorCode").equals("000000")) {
                log.info("\u6cf0\u9686\u94f6\u884c\u4ea4\u6613\u5f02\u5e38");
                return null;
            }
            token = SM2Util.decryptByPrivateKey((String)rspJsonObj.getString("sm2EncryptData"), (String)this.tailongBankConfig.getSm2PrivateKey());
            if (!SM2Util.verifyByPublicKey((String)rspJsonObj.getString("sm2Sign"), (String)this.tailongBankConfig.getTlPublicKey(), (String)this.tailongBankConfig.getMechAppID(), (String)token)) {
                log.info("\u6cf0\u9686\u94f6\u884c\u8eab\u4efd\u8ba4\u8bc1-SM2\u9a8c\u7b7e\u5931\u8d25");
                return null;
            }
            if (!SM3Util.verify((String)(rspJsonObj.getString("random") + rspJsonObj.getString("seqNO") + token + this.tailongBankConfig.getAppSecretKey()), (String)rspJsonObj.getString("sign"))) {
                log.info("\u6cf0\u9686\u94f6\u884c\u9a8c\u7b7e\u5931\u8d25\uff0c\u62a5\u6587\u4e00\u81f4\u6027\u6821\u9a8c\u5931\u8d25");
                return null;
            }
            log.info("\u6cf0\u9686\u94f6\u884c\u83b7\u5f97Token\u4e3a\uff1a" + token);
            this.redisTemplate.opsForValue().set((Object)this.tailongBankConfig.getAccessTokenRedisKey(), (Object)token, this.tailongBankConfig.getINTERVALTIME().longValue(), TimeUnit.SECONDS);
            return token;
        }
        catch (Exception var6) {
            var6.printStackTrace();
            log.error("\u6cf0\u9686\u94f6\u884c\u8c03\u7528\u83b7\u53d6token\u63a5\u53e3\u5f02\u5e38");
            return null;
        }
    }

    private String doPost(String msg, String url) throws IOException {
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        HttpPost httpPost = new HttpPost(url);
        ByteArrayEntity bae = new ByteArrayEntity(msg.getBytes());
        httpPost.setEntity((HttpEntity)bae);
        httpPost.addHeader("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8");
        HttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
        HttpEntity entity = response.getEntity();
        if (entity != null) {
            byte[] bytes = EntityUtils.toByteArray((HttpEntity)entity);
            return new String(bytes, "UTF-8");
        }
        return null;
    }

    private Long getCredits(String uid) throws Exception {
        Map<String, String> params = this.getParamMap(null, uid);
        params.put("txnAcctNo", uid);
        HttpRequestBase httpPost = this.getHttpRequestBase(params, this.getHeaderMap(null, null), "tlscCntBalQry", null);
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        HttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
        HttpEntity entity = response.getEntity();
        byte[] bytes = EntityUtils.toByteArray((HttpEntity)entity);
        String body = new String(bytes, "UTF-8");
        JSONObject jsonObject = this.getResponse(body);
        return jsonObject.getLong("pntBal");
    }

    private Map<String, String> getHeaderMap(String orderNum, Integer type) {
        HashMap<String, String> heads = new HashMap<String, String>();
        heads.put("txSno", StringUtils.isNotBlank((CharSequence)orderNum) ? orderNum + "-" + type : RandomCodeUtil.getCode((int)30));
        heads.put("mrchSno", StringUtils.isNotBlank((CharSequence)orderNum) ? orderNum : RandomCodeUtil.getCode((int)30));
        heads.put("txTime", DateUtils.getSecondStr((Date)new Date()));
        return heads;
    }

    private Map<String, String> getParamMap(String orderNum, String uid) {
        Object otpCode;
        HashMap params = Maps.newHashMap();
        params.put("mechNo", this.tailongBankConfig.getMechNo());
        params.put("mechName", this.tailongBankConfig.getMechName());
        params.put("txnAcctNo", uid);
        if (StringUtils.isNotBlank((CharSequence)orderNum)) {
            params.put("inetNo", orderNum);
        }
        if ((otpCode = this.redisTemplate.opsForValue().get((Object)(this.tailongBankConfig.getOtpCodeStringRedisKey() + uid))) == null) {
            log.info("\u6cf0\u9686\u94f6\u884c\u672a\u4eceredis string\u91cc\u83b7\u53d6\u5230sso_tikect");
            otpCode = this.redisTemplate.opsForHash().get((Object)this.tailongBankConfig.getOtpCodeRedisKey(), (Object)uid);
        }
        if (otpCode == null) {
            log.warn("\u6cf0\u9686\u94f6\u884c\u672a\u83b7\u53d6\u7528\u6237\u7684otpCode uid:{}", (Object)uid);
            throw new RuntimeException("\u6cf0\u9686\u94f6\u884c\u672a\u83b7\u53d6\u7528\u6237\u7684otpCode");
        }
        params.put("otpCode", otpCode.toString());
        return params;
    }

    private String getDateStr(String timestamp) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        if (StringUtils.isBlank((CharSequence)timestamp)) {
            return dateFormat.format(new Date());
        }
        return dateFormat.format(new Date(Long.valueOf(timestamp)));
    }

    private String transformFen2Yuan(String price) {
        if (StringUtils.isBlank((CharSequence)price)) {
            return "0";
        }
        return new BigDecimal(price).divide(new BigDecimal(100), 2, RoundingMode.FLOOR).toString();
    }

    public static void main(String[] args) {
        System.out.println(DateUtils.getMillisecond());
    }

    private JSONObject getResponse(String body) {
        JSONObject rspJsonObj = JSON.parseObject((String)body);
        try {
            if (rspJsonObj.containsKey((Object)"rspData")) {
                String sm2Key = SM2Util.decryptByPrivateKey((String)rspJsonObj.getString("sm2EncryptData"), (String)this.tailongBankConfig.getSm2PrivateKey());
                rspJsonObj.put("sm2EncryptData", (Object)sm2Key);
                if (!SM2Util.verifyByPublicKey((String)rspJsonObj.getString("sm2Sign"), (String)this.tailongBankConfig.getTlPublicKey(), (String)this.tailongBankConfig.getMechAppID(), (String)sm2Key)) {
                    log.info("\u6cf0\u9686\u94f6\u884c\u8eab\u4efd\u8ba4\u8bc1-SM2\u9a8c\u7b7e\u5931\u8d25");
                    return rspJsonObj;
                }
                String rspData = SM4Util.decrypt((String)rspJsonObj.getString("rspData"), (String)(rspJsonObj.getString("seqNO") + this.getTLToken() + this.tailongBankConfig.getAppSecretKey() + sm2Key));
                log.info("\u6cf0\u9686\u94f6\u884c\u89e3\u5bc6\u540e\u62a5\u6587\uff1a" + rspData);
                if (SM3Util.verify((String)(rspData + rspJsonObj.getString("seqNO") + this.tailongBankConfig.getAppSecretKey() + sm2Key), (String)rspJsonObj.getString("sign"))) {
                    if (rspData == null) {
                        throw new RuntimeException("\u89e3\u6790\u5f02\u5e38");
                    }
                    return JSON.parseObject((String)rspData).getJSONObject("body");
                }
                log.info("\u62a5\u6587\u4e00\u81f4\u6027\u6821\u9a8c\u5931\u8d25");
                return rspJsonObj;
            }
        }
        catch (Exception e) {
            log.warn(" \u6cf0\u9686\u94f6\u884c  getResponseNotify  body = {}", (Object)body, (Object)e);
            return rspJsonObj;
        }
        return rspJsonObj;
    }
}

