/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.biz.qb.supplier;

import cn.com.duiba.api.enums.SubjectTypeEnum;
import cn.com.duiba.domain.SupplierRequest;
import cn.com.duiba.domain.SupplierResponse;
import cn.com.duiba.mq.RocketMQMsgProducer;
import cn.com.duiba.service.HttpAsyncClientPool;
import cn.com.duiba.service.MessageService;
import cn.com.duiba.tool.AssembleTool;
import cn.com.duiba.tool.HttpRequestLog;
import cn.com.duiba.tool.JsonTool;
import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class KaiXinQbSupplier {
    private static Logger log = LoggerFactory.getLogger(KaiXinQbSupplier.class);
    @Value(value="${qb.kaixin.md5Key}")
    private String md5Key;
    @Value(value="${qb.kaixin.duiba.md5Key}")
    private String duibaMd5Key;
    @Value(value="${qb.kaixin.duia2.md5Key}")
    private String duia2Md5Key;
    @Autowired
    private MessageService messageService;
    @Autowired
    private RocketMQMsgProducer rocketMQMsgProducer;
    @Autowired
    private HttpAsyncClientPool httpAsyncClientPool;

    public void asyncSubmit(final SupplierRequest message, final String callbackTopic, final String msgTag, final String msgKey) {
        if (!this.messageService.messageUniqueCheck(message.getSupplierOrderId(), "qb")) {
            return;
        }
        HttpRequestLog.logUrl("[action qb] [tag request] [bizId " + message.getOrderId() + "] [url " + message.getHttpUrl() + "][params  " + JSONObject.toJSONString(message.getParams()) + "]");
        HttpRequestBase post = this.getHttp(message);
        this.httpAsyncClientPool.submit(message.getAppId(), (HttpUriRequest)post, new FutureCallback<HttpResponse>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void completed(HttpResponse response) {
                SupplierResponse resp = new SupplierResponse();
                try {
                    resp.setOrderId(message.getOrderId());
                    resp.setSupplierOrderId(message.getSupplierOrderId());
                    resp.setSupplierName(message.getSupplierName());
                    resp.setUrl(message.getHttpUrl());
                    resp.setCallbackType("completed");
                    resp.setAppId(message.getAppId());
                    resp.setConsumerId(message.getConsumerId());
                    String body = EntityUtils.toString((HttpEntity)response.getEntity());
                    resp.setBody(body);
                }
                catch (Exception e) {
                    log.error("KaiXinQbSupplier completed", (Throwable)e);
                }
                finally {
                    KaiXinQbSupplier.this.finallyBlock(message, resp, callbackTopic, msgTag, msgKey);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void failed(Exception ex) {
                log.error("KaiXinQbSupplier failed orderId:" + message.getOrderId(), (Throwable)ex);
                SupplierResponse resp = new SupplierResponse();
                try {
                    resp.setOrderId(message.getOrderId());
                    resp.setSupplierOrderId(message.getSupplierOrderId());
                    resp.setSupplierName(message.getSupplierName());
                    resp.setUrl(message.getHttpUrl());
                    resp.setCallbackType("failed");
                    resp.setAppId(message.getAppId());
                    resp.setConsumerId(message.getConsumerId());
                    resp.setErrorMessage(ex.getClass().getName() + ":" + ex.getMessage());
                }
                catch (Exception e) {
                    log.error("KaiXinQbSupplier completed", (Throwable)e);
                }
                finally {
                    KaiXinQbSupplier.this.finallyBlock(message, resp, callbackTopic, msgTag, msgKey);
                }
            }

            public void cancelled() {
                SupplierResponse resp = new SupplierResponse();
                try {
                    resp.setOrderId(message.getOrderId());
                    resp.setSupplierOrderId(message.getSupplierOrderId());
                    resp.setSupplierName(message.getSupplierName());
                    resp.setUrl(message.getHttpUrl());
                    resp.setCallbackType("cancelled");
                    resp.setAppId(message.getAppId());
                    resp.setConsumerId(message.getConsumerId());
                }
                catch (Exception e) {
                    log.error("KaiXinQbSupplier cancelled", (Throwable)e);
                }
                finally {
                    KaiXinQbSupplier.this.finallyBlock(message, resp, callbackTopic, msgTag, msgKey);
                }
            }
        });
    }

    private void finallyBlock(SupplierRequest message, SupplierResponse response, String callbackTopic, String msgTag, String msgKey) {
        try {
            response.setUrl(message.getHttpUrl());
            response.setSupplierName(message.getSupplierName());
            response.setSupplierOrderId(message.getSupplierOrderId());
            response.setOrderId(message.getOrderId());
            response.setAppId(message.getAppId());
            response.setConsumerId(message.getConsumerId());
            String body = JsonTool.objectToJson(response);
            HttpRequestLog.logUrl("[action qb] [tag response] [callback " + response.getCallbackType() + "] [bizId " + message.getOrderId() + "] [body " + response.getBody() + "]");
            if (callbackTopic.contains("MQ")) {
                this.rocketMQMsgProducer.sendMsg(callbackTopic, msgTag, msgKey, body, false, null);
            } else {
                this.messageService.sendMsg(callbackTopic, msgTag, msgKey, body);
            }
        }
        catch (Exception e) {
            log.error("KaiXinQbSupplier callback:" + message.getOrderId(), (Throwable)e);
        }
    }

    private HttpRequestBase getHttp(SupplierRequest message) {
        Map<String, String> params = message.getParams();
        HashMap<String, String> bodyMap = new HashMap<String, String>();
        bodyMap.put("pay_password", params.get("pay_password"));
        bodyMap.put("order_no", params.get("order_no"));
        bodyMap.put("account_no", params.get("account_no"));
        bodyMap.put("product_id", params.get("product_id"));
        bodyMap.put("number", params.get("number"));
        bodyMap.put("type", params.get("type"));
        bodyMap.put("ip", params.get("ip"));
        HashMap<String, String> headerMap = new HashMap<String, String>();
        headerMap.put("partner_id", params.get("partner_id"));
        headerMap.put("orgcode", params.get("orgcode"));
        headerMap.put("agent_id", params.get("agent_id"));
        headerMap.put("password", params.get("password"));
        headerMap.put("timestamp", params.get("timestamp"));
        headerMap.put("sign_type", params.get("sign_type"));
        headerMap.put("sign", this.sign(headerMap, bodyMap, params.get("subject")));
        HashMap<String, HashMap<String, String>> raws = new HashMap<String, HashMap<String, String>>();
        raws.put("header", headerMap);
        raws.put("body", bodyMap);
        String body = JSONObject.toJSONString((Object)JSONObject.toJSON(raws));
        HttpPost http = AssembleTool.assembleRequestJson(message.getHttpUrl(), body);
        return http;
    }

    private String sign(Map<String, String> headerMap, Map<String, String> bodyMap, String subject) {
        TreeMap<String, String> map = new TreeMap<String, String>();
        map.putAll(headerMap);
        map.putAll(bodyMap);
        StringBuilder builder = new StringBuilder();
        int index = 0;
        for (Map.Entry entry : map.entrySet()) {
            if (StringUtils.isBlank((String)((String)entry.getValue()))) continue;
            if (index > 0) {
                builder.append("&");
            }
            builder.append((String)entry.getKey()).append("=").append((String)entry.getValue());
            ++index;
        }
        if (StringUtils.isBlank((String)subject)) {
            log.info("qb\u7b7e\u540d\u6ca1\u6709\u4e3b\u4f53\u6d41\u7a0b");
            builder.append(this.md5Key);
        } else if (SubjectTypeEnum.DUIBA.getType().equals(subject)) {
            log.info("qb\u7b7e\u540d\u4e3b\u4f53\u4e3a\u5151\u5427\u6d41\u7a0b");
            builder.append(this.duibaMd5Key);
        } else if (SubjectTypeEnum.DUIA.getType().equals(subject)) {
            log.info("qb\u7b7e\u540d\u4e3b\u4f53\u4e3a\u5151\u554a\u6d41\u7a0b");
            builder.append(this.duia2Md5Key);
        }
        return DigestUtils.md5Hex((String)builder.toString());
    }
}

