/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.constant;

import cn.com.duiba.biz.Exception.ThirdpatyException;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Set;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConfigurationProperties(prefix="wufangzhai")
public class WuFangZhaiConfig {
    private Set<Long> appIds;
    private String url;
    private String clientId;
    private String clientSecret;
    private String grantType;
    private String scope;
    private String username;
    private String password;
    private String config;
    private Map<String, Config> configMap = Maps.newHashMap();

    public String getConfig() {
        return this.config;
    }

    public void setConfig(String config) {
        Map configMap;
        this.config = config;
        this.configMap = configMap = (Map)JSON.parseObject((String)config, (TypeReference)new TypeReference<Map<String, Config>>(){}, (Feature[])new Feature[0]);
    }

    public Config getConfigByAppIdIfNullThrowEx(String appId) {
        Config config = this.configMap.get(appId);
        if (config == null) {
            throw new ThirdpatyException("\u8be5appId\u6ca1\u6709\u5bf9\u5e94\u7684\u914d\u7f6e");
        }
        return config;
    }

    public Set<Long> getAppIds() {
        return this.appIds;
    }

    public void setAppIds(Set<Long> appIds) {
        this.appIds = appIds;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public String getGrantType() {
        return this.grantType;
    }

    public void setGrantType(String grantType) {
        this.grantType = grantType;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public static class Config {
        private String username;
        private String password;

        public String getUsername() {
            return this.username;
        }

        public void setUsername(String username) {
            this.username = username;
        }

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String password) {
            this.password = password;
        }
    }

    public static enum Api {
        GET_TOKEN("/oauth/token"),
        CARD_QUERY_INFO("/card/queryInfoByStr"),
        TRADE_REDUCE_INTEGRAL("/trade/reduceIntegral"),
        TRADE_AWARD_INTEGRAL("/trade/awardIntegral"),
        COUPON_SEND_COUPON("/coupon/sendCoupon");

        String path;

        private Api(String path) {
            this.path = path;
        }

        public String getPath() {
            return this.path;
        }

        public String getApiAbsolutePath(WuFangZhaiConfig config) {
            return config.getUrl() + this.getPath();
        }
    }
}

