/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.remoteimpl;

import cn.com.duiba.biz.alipay.domain.AlipayOfficialRequest;
import cn.com.duiba.biz.alipay.supplier.AlipayBatchExecutor;
import cn.com.duiba.biz.alipay.supplier.ZhongXiangSupplier;
import cn.com.duiba.biz.phonebill.supplier.GyjxPhonebillSupplier;
import cn.com.duiba.biz.phonebill.supplier.JuhePhonebillSupplier;
import cn.com.duiba.biz.phonebill.supplier.LianLianPhonebillSupplier;
import cn.com.duiba.biz.phonebill.supplier.NewLianLianPhonebillSupplier;
import cn.com.duiba.biz.phonebill.supplier.OufeiPhonebillSupplier;
import cn.com.duiba.biz.phonebill.supplier.PUUPPhoneBillSupplier;
import cn.com.duiba.biz.phonebill.supplier.SududaPhonebillSupplier;
import cn.com.duiba.biz.phoneflow.supplier.MoPinPhoneflowSupplier;
import cn.com.duiba.biz.qb.supplier.KaiXinQbSupplier;
import cn.com.duiba.biz.virtual.supplier.VirtualSupplier;
import cn.com.duiba.domain.SupplierRequest;
import cn.com.duiba.service.HttpAsyncClientPool;
import cn.com.duiba.thirdparty.api.RemoteChargeService;
import cn.com.duiba.thirdparty.dto.AlipayOfficialRequestDto;
import cn.com.duiba.thirdparty.dto.SupplierRequestDto;
import cn.com.duiba.tool.CodeException;
import cn.com.duiba.wolf.dubbo.DubboResult;
import cn.com.duiba.wolf.utils.BeanUtils;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class RemoteChargeServiceImpl
implements RemoteChargeService {
    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteChargeServiceImpl.class);
    public static final Set<String> PUUP_SUPPLIER_SET = ImmutableSet.of((Object)"phonebill-puup-tax", (Object)"phonebill-puup");
    @Autowired
    private AlipayBatchExecutor alipayBatchExecutor;
    @Autowired
    private ZhongXiangSupplier zhongXiangSupplier;
    @Autowired
    private GyjxPhonebillSupplier gyjxPhonebillSupplier;
    @Autowired
    private OufeiPhonebillSupplier oufeiPhonebillSupplier;
    @Autowired
    private SududaPhonebillSupplier sududaPhonebillSupplier;
    @Autowired
    private LianLianPhonebillSupplier lianLianPhonebillSupplier;
    @Autowired
    private NewLianLianPhonebillSupplier newLianLianPhonebillSupplier;
    @Autowired
    private MoPinPhoneflowSupplier moPinPhoneflowSupplier;
    @Autowired
    private VirtualSupplier virtualSupplier;
    @Autowired
    private HttpAsyncClientPool httpAsyncClientPool;
    @Autowired
    private JuhePhonebillSupplier juhePhonebillSupplier;
    @Autowired
    private KaiXinQbSupplier kaiXinQbSupplier;
    @Autowired
    private PUUPPhoneBillSupplier puupPhoneBillSupplier;

    public DubboResult<Boolean> submitAlipay(AlipayOfficialRequestDto request) {
        try {
            AlipayOfficialRequest req = (AlipayOfficialRequest)BeanUtils.copy((Object)request, AlipayOfficialRequest.class);
            this.alipayBatchExecutor.addAlipayOrder(req);
            return DubboResult.successResult((Object)true);
        }
        catch (Exception e) {
            LOGGER.error("submitAlipay", (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Boolean> submitZxAlipay(SupplierRequestDto supplierRequestDto, String callbackTopic) {
        try {
            SupplierRequest sr = (SupplierRequest)BeanUtils.copy((Object)supplierRequestDto, SupplierRequest.class);
            this.validate(sr, callbackTopic);
            this.zhongXiangSupplier.asyncSubmit(sr, callbackTopic, null, null);
            return DubboResult.successResult((Object)true);
        }
        catch (Exception e) {
            LOGGER.error("submitZxAlipay", (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Boolean> submitQb(SupplierRequestDto request, String callbackTopic) {
        return this.submitQb(request, callbackTopic, null, null);
    }

    public DubboResult<Boolean> submitPhonebill(SupplierRequestDto supplierRequestDto, String callbackTopic) {
        return this.submitPhonebill(supplierRequestDto, callbackTopic, null, null);
    }

    public DubboResult<Boolean> submitPhoneflow(SupplierRequestDto supplierRequestDto, String callbackTopic) {
        return this.submitPhoneflow(supplierRequestDto, callbackTopic, null, null);
    }

    public DubboResult<Boolean> submitVirtual(SupplierRequestDto supplierRequestDto, String callbackTopic) {
        return this.submitVirtual(supplierRequestDto, callbackTopic, null, null);
    }

    private void validate(SupplierRequest request, String callbackTopic) throws CodeException {
        if (request == null) {
            throw new CodeException("0", "\u53c2\u6570\u6821\u9a8c\u5931\u8d25");
        }
        if (StringUtils.isEmpty((String)callbackTopic)) {
            throw new CodeException("0", "\u8ba2\u9605Topic\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void validateVirtual(SupplierRequest request, String callbackTopic) throws CodeException {
        if (StringUtils.isEmpty((String)callbackTopic)) {
            throw new CodeException("0", "\u8ba2\u9605Topic\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)request.getHttpUrl())) {
            throw new CodeException("0", "\u8bf7\u6c42URL\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (request.getAppId() == null) {
            throw new CodeException("0", "APPID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!this.httpAsyncClientPool.canSubmitToAppPool(request.getAppId())) {
            throw new CodeException("0", "APP\u961f\u5217\u8d85\u8fc7\u9600\u503c\uff0cAPP\u63a5\u53e3\u7e41\u5fd9, appId: " + request.getAppId());
        }
    }

    public DubboResult<Boolean> submitZxAlipay(SupplierRequestDto supplierRequestDto, String callbackTopic, String msgTag, String msgKey) {
        try {
            SupplierRequest sr = (SupplierRequest)BeanUtils.copy((Object)supplierRequestDto, SupplierRequest.class);
            this.validate(sr, callbackTopic);
            this.zhongXiangSupplier.asyncSubmit(sr, callbackTopic, msgTag, msgKey);
            return DubboResult.successResult((Object)true);
        }
        catch (Exception e) {
            LOGGER.error("submitZxAlipay", (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Boolean> submitQb(SupplierRequestDto request, String callbackTopic, String msgTag, String msgKey) {
        try {
            SupplierRequest req = (SupplierRequest)BeanUtils.copy((Object)request, SupplierRequest.class);
            this.validate(req, callbackTopic);
            this.kaiXinQbSupplier.asyncSubmit(req, callbackTopic, msgTag, msgKey);
            return DubboResult.successResult((Object)true);
        }
        catch (Exception e) {
            LOGGER.error("submitQb", (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Boolean> submitPhonebill(SupplierRequestDto supplierRequestDto, String callbackTopic, String msgTag, String msgKey) {
        try {
            SupplierRequest request = (SupplierRequest)BeanUtils.copy((Object)supplierRequestDto, SupplierRequest.class);
            this.validate(request, callbackTopic);
            String supplierName = request.getSupplierName();
            if ("phonebill-gyjx".equals(supplierName)) {
                this.gyjxPhonebillSupplier.asyncSubmit(request, callbackTopic, msgTag, msgKey);
            } else if ("phonebill-oufei".equals(supplierName)) {
                this.oufeiPhonebillSupplier.asyncSubmit(request, callbackTopic, msgTag, msgKey);
            } else if ("phonebill-lianlian-new-platform".equals(supplierName)) {
                this.newLianLianPhonebillSupplier.asyncSubmit(request, callbackTopic, msgTag, msgKey);
            } else if ("phonebill-lianlian-new".equals(supplierName)) {
                this.lianLianPhonebillSupplier.asyncSubmit(request, callbackTopic, msgTag, msgKey);
            } else if ("phonebill-sududa".equals(supplierName)) {
                this.sududaPhonebillSupplier.asyncSubmit(request, callbackTopic, msgTag, msgKey);
            } else if ("phonebill-juhe".equals(supplierName)) {
                this.juhePhonebillSupplier.asyncSubmit(request, callbackTopic, msgTag, msgKey);
            } else if (PUUP_SUPPLIER_SET.contains(supplierName)) {
                this.puupPhoneBillSupplier.asyncSubmit(request, callbackTopic, msgTag, msgKey);
            } else {
                throw new CodeException("0", "phonebill\u65e0\u5bf9\u5e94\u4e0a\u6e38\uff1a" + supplierName);
            }
            return DubboResult.successResult((Object)true);
        }
        catch (Exception e) {
            LOGGER.error("submitPhonebill", (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Boolean> submitPhoneflow(SupplierRequestDto supplierRequestDto, String callbackTopic, String msgTag, String msgKey) {
        try {
            SupplierRequest request = (SupplierRequest)BeanUtils.copy((Object)supplierRequestDto, SupplierRequest.class);
            this.validate(request, callbackTopic);
            this.moPinPhoneflowSupplier.asyncSubmit(request, callbackTopic, msgTag, msgKey);
            return DubboResult.successResult((Object)true);
        }
        catch (Exception e) {
            LOGGER.error("submitPhoneflow", (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Boolean> submitVirtual(SupplierRequestDto supplierRequestDto, String callbackTopic, String tag, String key) {
        try {
            SupplierRequest request = (SupplierRequest)BeanUtils.copy((Object)supplierRequestDto, SupplierRequest.class);
            this.validateVirtual(request, callbackTopic);
            this.virtualSupplier.asyncSubmit(request, callbackTopic, tag, key);
            return DubboResult.successResult((Object)true);
        }
        catch (Exception e) {
            LOGGER.error("submitVirtual", (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }
}

