/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.service;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.constant.WjrcbConfig;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.impl.client.DefaultConnectionKeepAliveStrategy;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.impl.nio.client.HttpAsyncClients;
import org.apache.http.impl.nio.conn.PoolingNHttpClientConnectionManager;
import org.apache.http.impl.nio.reactor.DefaultConnectingIOReactor;
import org.apache.http.nio.conn.NHttpClientConnectionManager;
import org.apache.http.nio.conn.NoopIOSessionStrategy;
import org.apache.http.nio.conn.ssl.SSLIOSessionStrategy;
import org.apache.http.nio.reactor.ConnectingIOReactor;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={WjrcbConfig.class})
public class WjrcbHttpClientFactory {
    private static final Logger log = LoggerFactory.getLogger(WjrcbHttpClientFactory.class);
    @Autowired
    private WjrcbConfig wjrcbConfig;
    private static final int CONNECT_TIMEOUT = 10000;
    private static final int DEFAULT_REQUEST_TIMEOUT = 3000;
    private static final int KEEPALIVE_TIMEOUT = 5000;
    private static final int SOCKET_TIMEOUT = 10000;
    private static final int MAX_CONNECT = 30;
    private static final int MAX_ROUTE_CONNECT = 30;

    @Bean(initMethod="start", destroyMethod="close", name={"wjrcbHttpAsyncClient"})
    public CloseableHttpAsyncClient wjrcbHttpAsyncClient() {
        RequestConfig config = RequestConfig.custom().setConnectTimeout(10000).setConnectionRequestTimeout(3000).setSocketTimeout(10000).build();
        CloseableHttpAsyncClient httpClient = HttpAsyncClients.custom().setConnectionManager((NHttpClientConnectionManager)this.getConnectionManager()).setDefaultRequestConfig(config).setMaxConnTotal(30).setMaxConnPerRoute(30).setKeepAliveStrategy((ConnectionKeepAliveStrategy)WjrcbHttpClientFactory.getKeepAliveStrategy()).build();
        return httpClient;
    }

    @Bean(initMethod="start", destroyMethod="close", name={"wjrcbHttpAsyncNotifyClient"})
    public CloseableHttpAsyncClient wjrcbHttpAsyncNotifyClient() {
        RequestConfig config = RequestConfig.custom().setConnectTimeout(10000).setConnectionRequestTimeout(3000).setSocketTimeout(10000).build();
        CloseableHttpAsyncClient httpClient = HttpAsyncClients.custom().setConnectionManager((NHttpClientConnectionManager)this.getConnectionManager()).setDefaultRequestConfig(config).setMaxConnTotal(30).setMaxConnPerRoute(30).setKeepAliveStrategy((ConnectionKeepAliveStrategy)WjrcbHttpClientFactory.getKeepAliveStrategy()).build();
        return httpClient;
    }

    private PoolingNHttpClientConnectionManager getConnectionManager() {
        try {
            SSLContext sslContext = this.getSSLContext();
            if (sslContext == null) {
                throw new BizException("getConnectionManager failed, sslContext is null!!!");
            }
            return new PoolingNHttpClientConnectionManager((ConnectingIOReactor)new DefaultConnectingIOReactor(), RegistryBuilder.create().register("http", (Object)NoopIOSessionStrategy.INSTANCE).register("https", (Object)new SSLIOSessionStrategy(sslContext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE)).build());
        }
        catch (Exception e) {
            log.warn("", (Throwable)e);
            return null;
        }
    }

    /*
     * Exception decompiling
     */
    private SSLContext getSSLContext() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static DefaultConnectionKeepAliveStrategy getKeepAliveStrategy() {
        return new DefaultConnectionKeepAliveStrategy(){

            public long getKeepAliveDuration(HttpResponse response, HttpContext context) {
                long duration = super.getKeepAliveDuration(response, context);
                if (duration == -1L) {
                    return 5000L;
                }
                return duration;
            }
        };
    }
}

