/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.service.impl;

import cn.com.duiba.service.KeyMetadata;
import cn.com.duiba.service.KeyRegistry;
import cn.com.duiba.service.impl.KeyProviderImpl;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.security.Key;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.util.Assert;

public class KeyRegistryImpl
implements KeyRegistry {
    private Map<String, Key> cache = new ConcurrentHashMap<String, Key>();
    private volatile boolean sync = false;

    @Override
    public Key getKey(KeyMetadata metadata) {
        Assert.notNull((Object)metadata, (String)"[Assertion failed] - metadata is required; it must not be null");
        Key key = this.cache.get(metadata.getId());
        if (key == null || this.sync) {
            key = this.getKeyInternal(metadata);
            this.cache.put(metadata.getId(), key);
        }
        return key;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Certificate getCertificate(String base64) {
        Assert.hasText((String)base64, (String)"[Assertion failed] - base64 must have text; it must not be null, empty, or blank");
        try (BufferedInputStream is = new BufferedInputStream(new ByteArrayInputStream(base64.trim().getBytes()));){
            Certificate cert;
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            Certificate certificate = cert = cf.generateCertificate(is);
            return certificate;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private Key getKeyInternal(KeyMetadata metadata) {
        KeyProviderImpl provider = new KeyProviderImpl(metadata.getFile(), metadata.getKeyStorePassword());
        Key key = provider.getKey(metadata.getKeyAlias(), metadata.getKeyPassword());
        Assert.notNull((Object)key, (String)"[Assertion failed] - key must not be null");
        return key;
    }
}

