/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tool.cgb;

import cn.com.duiba.tool.cgb.FileHelper;
import cn.com.duiba.tool.cgb.SM2Util;
import java.io.InputStream;
import java.util.Base64;

public class CgbSign {
    public static String sign(String srcString, String pvkName, String encoding) throws Exception {
        byte[] pvkBytes = FileHelper.read(CgbSign.getInputStream(pvkName));
        if (pvkBytes.length > 32) {
            pvkBytes = SM2Util.getPrivateKey(pvkBytes);
        }
        byte[] signedBytes = SM2Util.sign(pvkBytes, srcString.getBytes(encoding));
        return Base64.getEncoder().encodeToString(signedBytes);
    }

    public static boolean veryfySign(String srcString, String respSignature, String pukName, String encoding) throws Exception {
        byte[] pukBytes = FileHelper.read(CgbSign.getInputStream(pukName));
        if (pukBytes.length > 64) {
            pukBytes = SM2Util.getPublicKey(pukBytes);
        }
        return SM2Util.verifySign(pukBytes, srcString.getBytes(encoding), Base64.getDecoder().decode(respSignature));
    }

    public static String sm2EncryptString(String srcString, String pukName, String encoding) throws Exception {
        byte[] pukBytes = FileHelper.read(CgbSign.getInputStream(pukName));
        if (pukBytes.length > 64) {
            pukBytes = SM2Util.getPublicKey(pukBytes);
        }
        byte[] encryptBytes = SM2Util.encrypt(pukBytes, srcString.getBytes(encoding));
        return Base64.getEncoder().encodeToString(encryptBytes);
    }

    public static InputStream getInputStream(String name) {
        return CgbSign.class.getResourceAsStream("/bankKey/cgb/" + name);
    }
}

