/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tool.huawei;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.Signature;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class SignUtils {
    private static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    private static final String HMAC_SHA256 = "HmacSHA256";
    private static final String SHA256 = "SHA-256";
    private static final String SHA256_WITH_RSA_PSS = "SHA256withRSA/PSS";
    private static final String RSA = "RSA";

    public static String hmacSHA256(String plainText, String key) throws Exception {
        Mac mac = Mac.getInstance(HMAC_SHA256);
        SecretKeySpec secretKeySpec = new SecretKeySpec(key.getBytes(DEFAULT_CHARSET), HMAC_SHA256);
        mac.init(secretKeySpec);
        return Hex.encodeHexString((byte[])mac.doFinal(plainText.getBytes(DEFAULT_CHARSET)));
    }

    public static String sha256(String plainText) throws Exception {
        MessageDigest messageDigest = MessageDigest.getInstance(SHA256);
        messageDigest.update(plainText.getBytes(DEFAULT_CHARSET));
        return Hex.encodeHexString((byte[])messageDigest.digest());
    }

    public static String sign(String plainText, String privateKeyStr) throws Exception {
        return SignUtils.sign(plainText, SignUtils.getPrivateKey(privateKeyStr));
    }

    public static String sign(String plainText, PrivateKey privateKey) throws Exception {
        Signature Sign = Signature.getInstance(SHA256_WITH_RSA_PSS);
        Sign.initSign(privateKey);
        Sign.update(plainText.getBytes(DEFAULT_CHARSET));
        return Base64.encodeBase64String((byte[])Sign.sign());
    }

    public static boolean verifySign(String plainText, String signText, String publicKeyStr) throws Exception {
        return SignUtils.verifySign(plainText, signText, SignUtils.getPublicKey(publicKeyStr));
    }

    public static boolean verifySign(String plainText, String signText, PublicKey publicKey) throws Exception {
        Signature verifySign = Signature.getInstance(SHA256_WITH_RSA_PSS);
        verifySign.initVerify(publicKey);
        verifySign.update(plainText.getBytes(DEFAULT_CHARSET));
        return verifySign.verify(Base64.decodeBase64((String)signText));
    }

    public static PublicKey getPublicKey(String publicKeyStr) throws Exception {
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(Base64.decodeBase64((String)publicKeyStr));
        KeyFactory keyFactory = KeyFactory.getInstance(RSA);
        return keyFactory.generatePublic(keySpec);
    }

    public static PrivateKey getPrivateKey(String key) throws Exception {
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(Base64.decodeBase64((String)key));
        KeyFactory keyFactory = KeyFactory.getInstance(RSA);
        return keyFactory.generatePrivate(keySpec);
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

