/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tool.kunshanRCB;

import cn.com.duiba.tool.kunshanRCB.Cipher;
import cn.com.duiba.tool.kunshanRCB.SM2;
import cn.com.duiba.tool.kunshanRCB.SM4;
import cn.com.duiba.tool.kunshanRCB.Util;
import java.io.IOException;
import java.math.BigInteger;
import java.text.DecimalFormat;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.pqc.math.linearalgebra.ByteUtils;

public class EncryptAPI {
    private static SM2 sm2 = new SM2();
    private static SM4 sm4 = new SM4();
    private static Util util = new Util();
    private static DecimalFormat df = new DecimalFormat("0000");

    public static String encryptByPK1(String publicKey, String data) throws IOException {
        if (publicKey == null || publicKey.length() == 0) {
            return null;
        }
        if (data == null || data.length() == 0) {
            return null;
        }
        publicKey = "04" + publicKey;
        byte[] publicKeyBytes = ByteUtils.fromHexString((String)publicKey);
        byte[] plainTextBytes = ByteUtils.fromHexString((String)data);
        byte[] source = new byte[plainTextBytes.length];
        System.arraycopy(plainTextBytes, 0, source, 0, plainTextBytes.length);
        Cipher cipher = new Cipher();
        ECPoint userKey = EncryptAPI.sm2.ECC_CURVE.decodePoint(publicKeyBytes);
        ECPoint c1 = cipher.initEnc(sm2, userKey);
        cipher.Encrypt(source);
        byte[] c3 = new byte[32];
        cipher.Dofinal(c3);
        String C1 = Util.byteToHex(c1.getEncoded());
        String C2 = Util.byteToHex(source);
        String C3 = Util.byteToHex(c3);
        String encData = C1 + C2 + C3;
        return encData.substring(2, encData.length());
    }

    public static String decryptByVK1(String privateKey, String encryptedData) throws IOException {
        if (privateKey == null || privateKey.length() == 0) {
            return null;
        }
        if (encryptedData == null || encryptedData.length() == 0) {
            return null;
        }
        String data = "04" + encryptedData;
        byte[] c1Bytes = Util.hexToByte(data.substring(0, 130));
        int c2Len = Util.hexToByte(data).length - 97;
        byte[] c2 = Util.hexToByte(data.substring(130, 130 + 2 * c2Len));
        byte[] c3 = Util.hexToByte(data.substring(130 + 2 * c2Len, 194 + 2 * c2Len));
        BigInteger userD = new BigInteger(1, Util.hexToByte(privateKey));
        ECPoint c1 = EncryptAPI.sm2.ECC_CURVE.decodePoint(c1Bytes);
        Cipher cipher = new Cipher();
        cipher.initDec(userD, c1);
        cipher.Decrypt(c2);
        cipher.Dofinal(c3);
        String plainData = Util.byteToHex(c2);
        return plainData;
    }

    public static String[] encryptDataEnvelop(String pkValue, String data) throws Exception {
        if (pkValue == null || pkValue.length() == 0) {
            return null;
        }
        if (data == null || data.length() == 0) {
            return null;
        }
        String[] envelop = new String[2];
        String hexData = Util.asciiToHex(data);
        String tmpData = Util.asciiToHex(df.format(hexData.length() / 2)) + hexData;
        int length = tmpData.getBytes("gb18030").length;
        if (length % 32 != 0) {
            int numOfzero = 32 - length % 32;
            for (int i = 0; i < numOfzero / 2; ++i) {
                tmpData = tmpData + "30";
            }
        }
        hexData = tmpData;
        String sm4Key = sm4.generateKey();
        String keyByPK = EncryptAPI.encryptByPK1(pkValue, sm4Key);
        String encData = SM4.encryptECB(sm4Key, hexData.toUpperCase());
        envelop[0] = keyByPK;
        envelop[1] = encData;
        return envelop;
    }

    public static String[] decryptDataEnvelop(String vk, String keyByPK, String encData) throws Exception {
        String[] envelop = new String[2];
        String sm4Key = EncryptAPI.decryptByVK1(vk, keyByPK);
        String plainData = SM4.decryptECB(sm4Key, encData).toUpperCase();
        int lenOfdata = Integer.parseInt(Util.hexToAscii(plainData.substring(0, 8)));
        String hexData = plainData.substring(8, 8 + lenOfdata * 2);
        String ascData = new String(Util.hexStringToBytes(hexData), "gb18030");
        envelop[0] = sm4Key;
        envelop[1] = ascData;
        return envelop;
    }
}

