/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tool.sxzq;

import cn.com.duiba.tool.sxzq.HsBase64EncodeUtils;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EncryptAlgorithmUtils {
    protected static final Logger logger = LoggerFactory.getLogger(EncryptAlgorithmUtils.class);

    public static String encrypt(String text, String secretKey, String iv) throws Exception {
        if (StringUtils.isBlank((CharSequence)text)) {
            throw new IllegalArgumentException("text is null");
        }
        try {
            IvParameterSpec ips = new IvParameterSpec(iv.getBytes());
            SecretKeySpec sks = new SecretKeySpec(secretKey.getBytes(), "AES");
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            cipher.init(1, (Key)sks, ips);
            byte[] encrypted = cipher.doFinal(EncryptAlgorithmUtils.padString(text).getBytes("UTF8"));
            return HsBase64EncodeUtils.encode(encrypted);
        }
        catch (Exception e) {
            logger.error(String.format("AES \u52a0\u5bc6%s\u9519\u8bef\u3002", text), (Throwable)e);
            throw new IllegalArgumentException(String.format("AES \u52a0\u5bc6%s\u9519\u8bef\u3002", text));
        }
    }

    public static String decrypt(String code, String secretKey, String iv) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return null;
        }
        try {
            IvParameterSpec ivspec = new IvParameterSpec(iv.getBytes());
            SecretKeySpec keyspec = new SecretKeySpec(secretKey.getBytes(), "AES");
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            cipher.init(2, (Key)keyspec, ivspec);
            byte[] decrypted = cipher.doFinal(HsBase64EncodeUtils.decode(code));
            String result = new String(decrypted, "UTF8");
            return StringUtils.isBlank((CharSequence)result) ? "" : result.trim();
        }
        catch (Exception e) {
            logger.error(String.format("AES \u89e3\u5bc6%s\u9519\u8bef\u3002", code), (Throwable)e);
            throw new IllegalArgumentException(String.format("AES \u89e3\u5bc6%s\u9519\u8bef\u3002", code));
        }
    }

    private static String padString(String source) {
        char paddingChar = '\u0000';
        int size = 16;
        int x = source.length() % size;
        int padLength = size - x;
        for (int i = 0; i < padLength; ++i) {
            source = source + paddingChar;
        }
        return source;
    }

    public static void main(String[] args) {
        try {
            System.out.println(EncryptAlgorithmUtils.decrypt("b3EKsP4aREmpFX7E77Lycotb4q+DJHv54hhMQdSYLmu+wsFYbBNR5FnnKCKCJQom45ARXqccC+LA6U7M1ECXa6PGmFGAHHqtLX0X7+gsk4rYHv7dTxNwpWjPEiOoP86u6QtWLv1vz0J8HD0gTKI4YKfPywc3AqBhJchQnAP9/xCUwYzRiL1b0D8evqprKANM+4Viz4rJltyIeZnpKnoKw2pzCsXleKzIAQ9VoPeQ91e/xZznTrNRC9cYx+1U47LpEWjkRg3DJHnSanbyXf/ak9OcUrlNkxaKj2uWLK8qzN1RVkxnreeKofcvW/2ZuUIbdvlQ4aQOImvWUwy1QgK1yDwgRNc2BsZs150fVrtr1jNRCuVENJEL8CarfWvDVlblp+dT4UPCe8wrK0VVv4tnpKbSFk5rA9h8+R4K9Nb4SJsXC9128CUy/NYODjAGMf6Gk7UnyrKUeujm6j5GLnVTJpQBclclBo9CmIZc+rxkksrrbyGpa7SuE5tJf0VvWAso9y8Qrka0/Rq+extUHBRQZZoAS6uRdVYScLPllonlXzw40/j6dk50NS8B3I8YCP6aArFrim+0OfwKihxE9lYGYgXPI3UV2QdAm3Q1Vcnr9qEuk4kX8ptV643KEswfn1YqRnr5iZq21fPnN1EFVJBA9JN5hcq7MK7yKmABHKgdATbEMj8Y9PXMESwcgvFqxJtoZGs4pU+FnthguXifq45zOIpYXiNpM8wJaR0wLJBDtdx+u5Hv1fo6bjnr+WuBRnEv9k3bjLtnd08JPWDfEozT6ITHATXdCH9atZWi2abrV4C1O+sJMWzWAuNVH8aKa8gFPwvjjSyXM7iSBB1i2XYnv+/utEyaF3KhwcEULqqLv+1chVLEGUq//vnkmQnoWJyXXx8vGQfymI83aHTlbm5chg==", "k.www.10jqka.com", "offset.10jqkacom"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

