package cn.com.duiba.biz.credits.strategy.Impl;

import cn.com.duiba.biz.Exception.ThirdpatyException;
import cn.com.duiba.biz.credits.strategy.ApiStrategy;
import cn.com.duiba.biz.credits.strategy.ApiStrategyRouter;
import cn.com.duiba.constant.GuoBenConfig;
import cn.com.duiba.domain.SubCreditsMsgWrapper;
import cn.com.duiba.dto.guoben.GuoBenBaseResp;
import cn.com.duiba.dto.guoben.req.MemberIntegralChangeDTO;
import cn.com.duiba.dto.guoben.resp.MemberIntegralLogDTO;
import cn.com.duiba.notifycenter.domain.NotifyQueueDO;
import cn.com.duiba.thirdparty.dto.CreditsMessageDto;
import cn.com.duiba.tool.AssembleTool;
import cn.com.duiba.wolf.utils.DateUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.google.common.collect.Maps;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

/**
 * @author haojiahong
 * @date 2021-04-13
 */
@Service
public class GuoBenApiStrategy implements ApiStrategy {

    private static final Logger LOGGER = LoggerFactory.getLogger(GuoBenApiStrategy.class);
    private static final String TOKEN = "token";


    @Autowired
    private GuoBenConfig guoBenConfig;
    @Resource(name = "httpClient")
    private CloseableHttpClient httpClient;

    @PostConstruct
    private void init() {
        ApiStrategyRouter.register(guoBenConfig.getConfigMap().keySet(), this);
    }

    public Boolean isGuoben(Long appId) {
        Set<Long> appIds = guoBenConfig.getConfigMap().keySet();
        if (null == appIds) {
            return false;
        }
        return appIds.contains(appId);
    }

    @Override
    public HttpRequestBase getMqSubCreditsHttpRequest(SubCreditsMsgWrapper message) {
        String url = message.getHttpUrl();
        String paramsStr = url.substring(url.indexOf('?') + 1);
        Map<String, String> params = AssembleTool.getUrlParams(paramsStr);
        Long appId = message.getSubCreditsMsg().getAppId();
        Map<String, String> authParams = message.getSubCreditsMsg().getAuthParams();
        if (MapUtils.isEmpty(authParams)) {
            authParams = Maps.newHashMap();
        }
        authParams.put("uid", params.get("uid"));
        authParams.put("appId", appId + "");
        message.getSubCreditsMsg().setAuthParams(authParams);

        GuoBenConfig.GuoBenConfigBean configBean = guoBenConfig.getConfigMap().get(appId);
        HttpPost httpPost = new HttpPost(GuoBenConfig.Api.CHANGE_MEMBER_INTEGRAL.getApiAbsolutePath(configBean));
        MemberIntegralChangeDTO req = new MemberIntegralChangeDTO();
        req.setAccountNumber(params.get("uid"));
        req.setAccountType(configBean.getAccountType());
        req.setBrandCode(configBean.getBrandCode());
        req.setBusinessId(params.get("orderNum"));
        //默认积分兑换
        req.setBusinessType("7");
        String type = params.get("type");
        if (StringUtils.isNotBlank(type)) {
            if (StringUtils.equals("game", type) || StringUtils.equals("hdtool", type)) {
                //hdtool(活动抽奖),sign(签到),设置为积分活动
                req.setBusinessType("3");
            }
        }
        Date date = new Date();
        String dateStr = DateUtils.getSecondStr(date);
        String expEndTimeStr = getExpEndTimeStr(date);
        req.setChangeTime(dateStr);
        req.setChangeType(1);
        req.setCreateBy(configBean.getCreateBy());
        req.setExpEndTime(expEndTimeStr);
        req.setExpStartTime(dateStr);
        Integer credits = Integer.valueOf(params.get("credits"));
        req.setIntegral(-credits);
        req.setRequestId(UUID.randomUUID().toString().replaceAll("-", ""));
        StringEntity stringEntity = new StringEntity(JSON.toJSONString(req), "UTF-8");
        stringEntity.setContentEncoding("UTF-8");
        stringEntity.setContentType("application/json");
        httpPost.setEntity(stringEntity);
//        httpPost.setHeader(TOKEN, getToken());
        return httpPost;
    }


    @Override
    public String parseCreditsRsp(String body, Boolean addCredits, Map<String, String> authParams) {
        Map<String, String> map = Maps.newHashMap();
        if (StringUtils.isBlank(body)) {
            map.put("status", "fail");
            map.put("errorMessage", "果本新增/扣减积分接口返回为空");
            return JSON.toJSONString(map);
        }
        try {
            GuoBenBaseResp<MemberIntegralLogDTO> guobenResp = JSON.parseObject(body, new TypeReference<GuoBenBaseResp<MemberIntegralLogDTO>>(MemberIntegralLogDTO.class) {
            });
            if (BooleanUtils.isTrue(guobenResp.getSuccess())) {
                map.put("status", "ok");
                map.put("bizId", guobenResp.getData().getBusinessId());
                map.put("credits", String.valueOf(getCredits(authParams.get("uid"), authParams.get("appId"))));
            } else {
                map.put("status", "fail");
                String errorMsg = guobenResp.getMsg();
                if (StringUtils.length(errorMsg) > 255) {
                    errorMsg = errorMsg.substring(0, 255);
                }
                map.put("errorMessage", errorMsg);
            }
        } catch (Exception e) {
            LOGGER.error("果本新增/扣减积分接口解析错误:{}--是否新增:{}", body, addCredits, e);
            map.put("status", "fail");
            map.put("errorMessage", "果本新增/扣减积分解析结果错误");
        }
        return JSONObject.toJSONString(map);
    }

    @Override
    public HttpRequestBase getAddCreditsMessageRequest(CreditsMessageDto message) {
        String url = message.getHttpUrl();
        String paramsStr = url.substring(url.indexOf('?') + 1);
        Map<String, String> params = AssembleTool.getUrlParams(paramsStr);
        String appId = message.getAppId();
        Map<String, String> authParams = message.getAuthParams();
        if (MapUtils.isEmpty(authParams)) {
            authParams = Maps.newHashMap();
        }
        authParams.put("uid", params.get("uid"));
        authParams.put("appId", appId);
        message.setAuthParams(authParams);

        GuoBenConfig.GuoBenConfigBean configBean = guoBenConfig.getConfigMap().get(Long.valueOf(appId));
        HttpPost httpPost = new HttpPost(GuoBenConfig.Api.CHANGE_MEMBER_INTEGRAL.getApiAbsolutePath(configBean));
        MemberIntegralChangeDTO req = new MemberIntegralChangeDTO();
        req.setAccountNumber(params.get("uid"));
        req.setAccountType(configBean.getAccountType());
        req.setBrandCode(configBean.getBrandCode());
        req.setBusinessId(params.get("orderNum"));
        //默认积分兑换
        req.setBusinessType("7");
        Date date = new Date();
        String dateStr = DateUtils.getSecondStr(date);
        String expEndTimeStr = getExpEndTimeStr(date);
        req.setChangeTime(dateStr);
        req.setChangeType(1);
        req.setCreateBy(configBean.getCreateBy());
        req.setExpEndTime(expEndTimeStr);
        req.setExpStartTime(dateStr);
        Integer credits = Integer.valueOf(params.get("credits"));
        req.setIntegral(credits);
        req.setRequestId(UUID.randomUUID().toString().replaceAll("-", ""));

        StringEntity stringEntity = new StringEntity(JSON.toJSONString(req), "UTF-8");
        stringEntity.setContentEncoding("UTF-8");
        stringEntity.setContentType("application/json");
        httpPost.setEntity(stringEntity);
//        httpPost.setHeader(TOKEN, getToken());


        return httpPost;
    }

    @Override
    public HttpRequestBase getRequestNotify(String notifyUrl, NotifyQueueDO record) {
        return null;
    }

    /**
     * 有效期结束时间 ：第二年的12月31号12点00分00秒
     *
     * @param date
     * @return
     */
    private String getExpEndTimeStr(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(Calendar.YEAR, 1);
        cal.set(Calendar.MONTH, 11);
        cal.set(Calendar.DAY_OF_MONTH, 31);
        cal.set(Calendar.HOUR_OF_DAY, 12);
        cal.set(Calendar.MINUTE, 0);
        cal.set(Calendar.SECOND, 0);
        cal.set(Calendar.MILLISECOND, 0);
        Date newDate = cal.getTime();
        return DateUtils.getSecondStr(newDate);
    }

    private String getToken(GuoBenConfig.GuoBenConfigBean configBean) {
        String url = GuoBenConfig.Api.GET_TOKEN.getApiAbsolutePath(configBean);
        HttpGet httpGet = new HttpGet(url);
        String resp;
        try (CloseableHttpResponse response = httpClient.execute(httpGet)) {
            HttpEntity entity = response.getEntity();
            resp = EntityUtils.toString(entity, "UTF-8");
        } catch (IOException e) {
            LOGGER.warn("果本，请求token，异常，url={}", url, e);
            throw new ThirdpatyException("果本，请求token，异常");
        }
        if (StringUtils.isBlank(resp)) {
            throw new ThirdpatyException("果本，请求token，失败");
        }
        String data = (String) JSON.parseObject(resp).get("data");
        if (StringUtils.isBlank(data)) {
            throw new ThirdpatyException("果本，请求token，失败");
        }
        return data;
    }

    public Long getCredits(String uid, String appId) {
        GuoBenConfig.GuoBenConfigBean configBean = guoBenConfig.getConfigMap().get(Long.valueOf(appId));
        String url = GuoBenConfig.Api.GET_INTEGRAL.getApiAbsolutePath(configBean);

        Map<String, String> params = Maps.newHashMap();
        params.put("brandCode", configBean.getBrandCode());
        params.put("cellPhoneNo", uid);

        LOGGER.info("果本查询积分，req={}", JSON.toJSONString(params));
        HttpPost httpPost = new HttpPost(url);
        httpPost.setEntity(new StringEntity(JSON.toJSONString(params), ContentType.APPLICATION_JSON));

        String resp;
        try (CloseableHttpResponse response = httpClient.execute(httpPost)) {
            HttpEntity entity = response.getEntity();
            resp = EntityUtils.toString(entity, "UTF-8");
        } catch (IOException e) {
            LOGGER.warn("果本，查询积分，异常，url={}", url, e);
            throw new ThirdpatyException("果本，查询积分，异常");
        }
        LOGGER.info("果本查询积分，resp={}", resp);
        if (StringUtils.isBlank(resp)) {
            throw new ThirdpatyException("果本查询积分失败");
        }
        Boolean flag = JSON.parseObject(resp).getBoolean("success");
        if (!BooleanUtils.isTrue(flag)) {
            throw new ThirdpatyException("果本查询积分失败");
        }
        Long credits = JSON.parseObject(resp).getJSONObject("data").getLong("integralAble");
        if (credits == null) {
            throw new ThirdpatyException("果本查询积分失败");
        }
        return credits;
    }


}
