package cn.com.duiba.biz.credits.strategy.Impl;

import cn.com.duiba.api.tools.RandomCodeUtil;
import cn.com.duiba.biz.credits.strategy.ApiStrategy;
import cn.com.duiba.constant.TailongBankConfig;
import cn.com.duiba.credits.sdk.CreditConsumeParams;
import cn.com.duiba.domain.AppDO;
import cn.com.duiba.domain.SubCreditsMsgWrapper;
import cn.com.duiba.domain.SupplierRequest;
import cn.com.duiba.notifycenter.domain.NotifyQueueDO;
import cn.com.duiba.thirdparty.dto.CreditsMessageDto;
import cn.com.duiba.thirdparty.dto.HttpRequestMessageDto;
import cn.com.duiba.tool.AssembleTool;
import cn.com.duiba.tool.JsonTool;
import cn.com.duiba.wolf.utils.DateUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.zjtlcb.fcloud.utils.MD5Util;
import com.zjtlcb.fcloud.utils.SM2Util;
import com.zjtlcb.fcloud.utils.SM3Util;
import com.zjtlcb.fcloud.utils.SM4Util;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;

/**
 * @Date 2020/12/28
 * @Created by cmm
 */
@Service
public class TailongApiStrategy implements ApiStrategy {

    private static final Logger log = LoggerFactory.getLogger(TailongApiStrategy.class);
    //加积分
    public static final String ADD_CREDITS = "01";
    //扣积分
    public static final String SUB_CREDITS = "02";
    @Autowired
    private TailongBankConfig tailongBankConfig;

    @Resource(name = "redisTemplate")
    private RedisTemplate<String, String> redisTemplate;


    @Override
    public boolean isCustomCrecord(HttpRequestMessageDto dto) {
        String orderNum = dto.getHttpParams().get("orderNum");
        boolean result = StringUtils.isNotBlank(orderNum);
        return result;
    }

    @Override
    public HttpRequestBase getMqSubCreditsHttpRequest(SubCreditsMsgWrapper message) {
        log.info("泰隆银行扣积分请求 :{}", JSON.toJSONString(message));
//		String url = message.getSubCreditsMsg().getCreditsConsumeRequestUrl();
        CreditConsumeParams creditConsumeParams = message.getSubCreditsMsg().getCreditConsumeParams();
        Map<String, String> params = getParamMap(creditConsumeParams.getOrderNum(), creditConsumeParams.getUid());
        params.put("operationType", SUB_CREDITS);
        params.put("pntOccrCnt", creditConsumeParams.getCredits().toString());
        params.put("remark", creditConsumeParams.getDescription());
        params.put("avyTp", creditConsumeParams.getType());
        return getHttpRequestBase(params, getHeaderMap(creditConsumeParams.getOrderNum(),2), "mallPntBalChg", null);

    }

    @Override
    public String parseCreditsRsp(String body,Boolean addCredits, Map<String, String> authParams) {
        log.info("泰隆银行扣积分响应 :{}", body);
        JSONObject jsonBody = getResponse(body);
        Map<String, String> duibaDoc = new HashMap<>();
        Boolean flag = "S".equals(jsonBody.getString("status"));
        duibaDoc.put("status", flag ? "ok" : "fail");
        duibaDoc.put("errorMessage", jsonBody.getString("dscrptnRsn"));
        duibaDoc.put("bizId", jsonBody.getString("serialId"));
        // 不用获取积分
        Long credits = null;
        try {
            credits = getCredits(authParams.get("uid"));
        } catch (Exception e) {
            log.warn("泰隆银行积分获取异常,", e);
        }
        if (credits == null) {
            log.warn("泰隆银行积分获取异常,:body{},authParams:{}",jsonBody.toString(),authParams);
            return JsonTool.objectToJson(duibaDoc);
        }
        duibaDoc.put("credits", credits.toString());
        return JsonTool.objectToJson(duibaDoc);
    }

    @Override
    public HttpRequestBase getAddCreditsMessageRequest(CreditsMessageDto message) {
        log.info("泰隆银行加积分 :{}", JSON.toJSONString(message));
        String url = message.getHttpUrl().substring(0, message.getHttpUrl().indexOf('?'));
        Map<String, String> authParams = message.getAuthParams();
        String orderNum = authParams.get("orderNum");
        String uid = authParams.get("uid");
        Map<String, String> params = getParamMap(orderNum, uid);
        params.put("operationType", ADD_CREDITS);
        params.put("pntOccrCnt", authParams.get("credits"));
        String description = authParams.get("description");
        params.put("remark", StringUtils.isBlank(description) ? "兑吧加积分" : description);
        return getHttpRequestBase(params, getHeaderMap(orderNum,1), "mallPntBalChg", url);

    }

    @Override
    public HttpRequestBase getRequestNotify(String notifyUrl, NotifyQueueDO record) {
        log.info("泰隆银行获取兑换结果通知 :{}，url:{}", JSON.toJSONString(record),notifyUrl);
        Map<String, String> params = getParamMap(record.getDuibaOrderNum(), record.getPartnerUserId());
        params.put("ordrSt", record.getResult() ? "S" : "F");
        params.put("remark", record.getError4developer());
        params.put("trPrInetNo", record.getDuibaOrderNum());
        params.put("serialId", record.getDeveloperBizId());
        params.remove("inetNo");
        return getHttpRequestBase(params, getHeaderMap(record.getDuibaOrderNum(),3), "pntAddDdcbRsltNtc", notifyUrl);

    }

    @Override
    public String getResponseNotify(String body) {
        JSONObject rspJsonObj = JSON.parseObject(body);
        try {
            if (rspJsonObj.containsKey("rspData")) {
                String sm2Key = SM2Util.decryptByPrivateKey(rspJsonObj.getString("sm2EncryptData"), tailongBankConfig.getSm2PrivateKey());
                rspJsonObj.put("sm2EncryptData", sm2Key);
                if (!SM2Util.verifyByPublicKey(rspJsonObj.getString("sm2Sign"), tailongBankConfig.getTlPublicKey(), tailongBankConfig.getMechAppID(), sm2Key)) {
                    log.info("身份认证-SM2验签失败");
                    return rspJsonObj.toString();
                } else {
                    String rspData = SM4Util.decrypt(rspJsonObj.getString("rspData"), rspJsonObj.getString("seqNO") + this.getTLToken() + tailongBankConfig.getAppSecretKey() + sm2Key);
                    log.info("泰隆银行解密后报文：" + rspData);
                    if (SM3Util.verify(rspData + rspJsonObj.getString("seqNO") + tailongBankConfig.getAppSecretKey() + sm2Key, rspJsonObj.getString("sign"))) {
                        String status = JSON.parseObject(rspData).getJSONObject("body").getString("status");
                        if (StringUtils.equals("S", status)) {
                            return "ok";
                        }
                        return rspData;
                    } else {
                        log.info("报文一致性校验失败");
                        return rspJsonObj.toString();
                    }
                }
            }
        } catch (Exception e) {
            log.warn(" 泰隆银行  getResponseNotify  body = {}", body, e);
            return body;
        }
        return body;
    }

    @Override
    public HttpRequestBase getCrecordNotify(HttpRequestMessageDto msg, AppDO app) {
        log.info("泰隆银行获取兑换记录同步http包装类 :{}，url:{}", JSON.toJSONString(msg));
        Map<String, String> params = getParamMap(null, msg.getHttpParams().get("uid"));
        params.put("mechNo", tailongBankConfig.getMechNo());
        params.put("mechName", tailongBankConfig.getMechName());
        params.put("sourceName", tailongBankConfig.getMechName());

        params.put("inetTmstmp", getDateStr(msg.getHttpParams().get("timestamp")));
        params.put("cnsmPnt", msg.getHttpParams().get("credits"));

        params.put("giftNm", msg.getHttpParams().get("title"));
        String unitPrice = msg.getHttpParams().get("unitPrice");
        params.put("unitPrice", transformFen2Yuan(unitPrice));
        params.put("trPrInetNo", msg.getHttpParams().get("orderNum"));
        //获取活动类型和名称
        params.put("avyTp", msg.getHttpParams().get("chargeMode"));
        params.put("avyNm", msg.getHttpParams().get("avyNm"));
        params.put("remark", msg.getHttpParams().get("error4Developer"));
        params.put("ordrSt", StringUtils.equals(msg.getHttpParams().get("status"), "success") ? "S" : "F");
        return getHttpRequestBase(params, getHeaderMap(msg.getHttpParams().get("orderNum"),4), "actRsltNtc", app.getRecordNotifyUrl());
    }

    @Override
    public String getCrecordResponse(String body) {
        log.info("泰隆定制同步兑换记录响应, request={}",body);
        return getResponseNotify(body);
    }

    @Override
    public HttpRequestBase getVirtualRequest(SupplierRequest request) {
        log.info("泰隆虚拟商品请求, request={}", JSON.toJSONString(request));
        String url = request.getHttpUrl();
//		String newUrl = url.substring(0, url.indexOf('?'));
        String paramsStr = url.substring(url.indexOf('?') + 1);
        Map<String, String> authParams = AssembleTool.getUrlParams(paramsStr);
        String goodsNum = authParams.get("params");
        //如果商品编码是TLYH_开头，则虚拟商品兑换走增加用户会员积分接口
        if (StringUtils.isNotBlank(goodsNum) && goodsNum.startsWith(tailongBankConfig.getVirtualCreditsPre())) {
            authParams.put("credits", goodsNum.replace(tailongBankConfig.getVirtualCreditsPre(), ""));
            CreditsMessageDto dto = new CreditsMessageDto();
            dto.setAuthParams(authParams);
            dto.setHttpUrl(url);
            dto.setAuthParams(authParams);
            //打开保存对账记录开关
            request.setSaveReconciliationRecord(true);
            //把最新的带有积分的参数map放到request里
            request.setAuthParams(authParams);
            return getAddCreditsMessageRequest(dto);
        }
        log.warn("泰隆银行未定制虚拟兑换接口 param:{}",JSON.toJSONString(authParams));
        throw new RuntimeException("泰隆银行未定制虚拟兑换接口");
    }

    @Override
    public String getVirtualResponse(SupplierRequest request, String body) {
        log.info("泰隆虚拟商品加积分响应结果response, body={}", body);
        Map<String, String> params = request.getAuthParams();
        String goodsNum = "";
        if (params != null) {
            goodsNum = params.get("params");
        }
        if (StringUtils.isNotBlank(goodsNum) && goodsNum.startsWith(tailongBankConfig.getVirtualCreditsPre())) {
            String flag = getResponseNotify(body);
            JSONObject result = new JSONObject();
            if ("ok".equals(flag)) {
                result.put("status", "success");
                return result.toString();
            }
            result.put("status", "fail");
            if (flag != null) {
                result.put("errorMessage", JSON.parseObject(flag).getJSONObject("body").getString("dscrptnRsn"));
            }
            return result.toString();
        }
        log.warn("泰隆银行未定制虚拟兑换接口响应异常 param:{}",JSON.toJSONString(params));
        throw new RuntimeException("泰隆银行未定制虚拟兑换接口响应异常");

    }

    private HttpRequestBase getHttpRequestBase(Map<String, String> paramMap, Map<String, String> headMap, String serviceId, String url) {
        JSONObject reqMsg = new JSONObject();
        Map<String, Object> map = new HashMap<String, Object>();
        map.put("head", headMap);
        map.put("body", paramMap);
        reqMsg.put("reqData", JSON.toJSON(map));
        reqMsg.put("appID", tailongBankConfig.getMechAppID());
        reqMsg.put("seqNO", (new SimpleDateFormat("yyyyMMddHHmmsss")).format(new Date()));
        reqMsg.put("signMethod", "SM3");
        reqMsg.put("encryptMethod", "SM4");
        reqMsg.put("appAccessToken", this.getTLToken());
        log.info("泰隆银行调用服务：" + tailongBankConfig.getTlHttpUrl() + serviceId + "   原请求报文：" + reqMsg.toJSONString());
        String randomKey = MD5Util.md5_(UUID.randomUUID().toString());
        HttpPost httpPost = null;
        try {
            reqMsg.put("sm2EncryptData", SM2Util.encryptByPublicKey(randomKey, tailongBankConfig.getTlPublicKey()));
            reqMsg.put("sm2Sign", SM2Util.signByPrivateKey(randomKey, tailongBankConfig.getSm2PrivateKey(), tailongBankConfig.getMechAppID()));
            reqMsg.put("sign", SM3Util.sign(reqMsg.getString("reqData") + reqMsg.getString("seqNO") + tailongBankConfig.getAppSecretKey() + randomKey));
            reqMsg.put("reqData", SM4Util.encrypt(reqMsg.getString("reqData"), reqMsg.getString("seqNO") + reqMsg.getString("appAccessToken") + tailongBankConfig.getAppSecretKey() + randomKey));
            httpPost = new HttpPost(tailongBankConfig.getTlHttpUrl() + serviceId);
//			 httpPost = new HttpPost(url);
            ByteArrayEntity bae = new ByteArrayEntity(reqMsg.toJSONString().getBytes());
            httpPost.setEntity(bae);
            httpPost.addHeader("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8");
        } catch (Exception e) {
            log.warn("泰隆银行 getHttpRequestBase",e);
        }
        return httpPost;
    }

    //获取请求接口用的accesstoken
    private String getTLToken() {
        String appAccessToken = redisTemplate.opsForValue().get(tailongBankConfig.getAccessTokenRedisKey());
        if (StringUtils.isNotBlank(appAccessToken)) {
            return appAccessToken;
        }
        try {
            JSONObject reqMsg = new JSONObject();
            String seqNO = (new SimpleDateFormat("yyyyMMddHHmmsss")).format(new Date());
            reqMsg.put("appID", tailongBankConfig.getMechAppID());
            reqMsg.put("seqNO", seqNO);
            reqMsg.put("random", MD5Util.md5_(seqNO));
            String randomKey = MD5Util.md5_(UUID.randomUUID().toString());
            reqMsg.put("sm2EncryptData", SM2Util.encryptByPublicKey(randomKey, tailongBankConfig.getTlPublicKey()));
            reqMsg.put("sm2Sign", SM2Util.signByPrivateKey(randomKey, tailongBankConfig.getSm2PrivateKey(), tailongBankConfig.getMechAppID()));
            reqMsg.put("sign", SM3Util.sign(reqMsg.getString("random") + reqMsg.getString("seqNO") + tailongBankConfig.getAppSecretKey() + randomKey));
            log.info("泰隆银行调用服务：approveDev,TL请求报文：" + reqMsg.toJSONString());
            String rspMsg = doPost(reqMsg.toJSONString(), tailongBankConfig.getTlHttpUrl() + "approveDev");
            log.info("泰隆银行响应报文：" + rspMsg);
            JSONObject rspJsonObj = JSON.parseObject(rspMsg);
            String token = "";
            if (!rspJsonObj.getString("errorCode").equals("000000")) {
                log.info("泰隆银行交易异常");
                return null;
            } else {
                token = SM2Util.decryptByPrivateKey(rspJsonObj.getString("sm2EncryptData"), tailongBankConfig.getSm2PrivateKey());
                if (!SM2Util.verifyByPublicKey(rspJsonObj.getString("sm2Sign"), tailongBankConfig.getTlPublicKey(), tailongBankConfig.getMechAppID(), token)) {
                    log.info("泰隆银行身份认证-SM2验签失败");
                    return null;
                } else if (!SM3Util.verify(rspJsonObj.getString("random") + rspJsonObj.getString("seqNO") + token + tailongBankConfig.getAppSecretKey(), rspJsonObj.getString("sign"))) {
                    log.info("泰隆银行验签失败，报文一致性校验失败");
                    return null;
                } else {
                    log.info("泰隆银行获得Token为：" + token);
                    redisTemplate.opsForValue().set(tailongBankConfig.getAccessTokenRedisKey(), token, tailongBankConfig.getINTERVALTIME(), TimeUnit.SECONDS);
//                    rspJsonObj.put("appAccessToken", token);
                    return token;
                }
            }
        } catch (Exception var6) {
            var6.printStackTrace();
            log.error("泰隆银行调用获取token接口异常");
            return null;
        }
    }
    private  String doPost(String msg, String url) throws IOException {
        HttpClient httpClient = HttpClientBuilder.create().build();
        HttpPost httpPost = new HttpPost(url);
        ByteArrayEntity bae = new ByteArrayEntity(msg.getBytes());
        httpPost.setEntity(bae);
        httpPost.addHeader("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8");
        HttpResponse response = httpClient.execute(httpPost);
        HttpEntity entity = response.getEntity();
        if (entity != null) {
            byte[] bytes = EntityUtils.toByteArray(entity);
            return new String(bytes, "UTF-8");
        } else {
            return null;
        }
    }
    private Long getCredits(String uid)throws Exception{
        Map<String, String> params = getParamMap(null,uid);
        params.put("txnAcctNo", uid);
        HttpRequestBase httpPost = getHttpRequestBase(params, getHeaderMap(null,null), "tlscCntBalQry", null);
        HttpClient httpClient = HttpClientBuilder.create().build();
        HttpResponse response = httpClient.execute(httpPost);
        HttpEntity entity = response.getEntity();
        byte[] bytes = EntityUtils.toByteArray(entity);
        String body = new String(bytes, "UTF-8");
        JSONObject jsonObject = getResponse(body);
        return jsonObject.getLong("pntBal");
    }

    /**
     * 获取请求头
     * @param orderNum
     * @param type 类型 （1：加积分，2：减积分，3：结果通知 4：兑换同步）
     *             txSno全局唯一  mrchSno业务唯一
     * @return
     */
    private Map<String, String> getHeaderMap(String orderNum,Integer type) {
        HashMap<String, String> heads = new HashMap<>();
        heads.put("txSno", StringUtils.isNotBlank(orderNum) ? orderNum + "-" + type : RandomCodeUtil.getCode(30));
        heads.put("mrchSno", StringUtils.isNotBlank(orderNum) ? orderNum : RandomCodeUtil.getCode(30));
        heads.put("txTime", DateUtils.getSecondStr(new Date()));
        return heads;
    }

    private Map<String,String> getParamMap(String orderNum,String uid) {
        Map<String, String> params = Maps.newHashMap();
        params.put("mechNo", tailongBankConfig.getMechNo());
        params.put("mechName", tailongBankConfig.getMechName());
        params.put("txnAcctNo", uid);
        if (StringUtils.isNotBlank(orderNum)) {
            params.put("inetNo", orderNum);
        }
        //先从redis的string中取，取不到从hash中取
        Object otpCode = redisTemplate.opsForValue().get(tailongBankConfig.getOtpCodeStringRedisKey() + uid);
        if (otpCode == null) {
//            log.info("泰隆银行未从redis string里获取到sso_tikect");
            otpCode = redisTemplate.opsForHash().get(tailongBankConfig.getOtpCodeRedisKey(), uid);
        }
        if (otpCode == null) {
            log.info("泰隆银行未获取用户的otpCode uid:{}", uid);
        } else {
            params.put("otpCode", otpCode.toString());
        }
        return params;
    }

    private String getDateStr(String timestamp) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        if (StringUtils.isBlank(timestamp)) {
            return dateFormat.format(new Date());
        }
        return dateFormat.format(new Date(Long.valueOf(timestamp)));
    }

    private String transformFen2Yuan(String price) {
        if (StringUtils.isBlank(price)) {
            return "0";
        }
        return new BigDecimal(price).divide(new BigDecimal(100), 2, RoundingMode.FLOOR).toString();
    }
    public static void main(String[] args) {
        System.out.println(DateUtils.getMillisecond());
    }


    private JSONObject getResponse(String body) {
        JSONObject rspJsonObj = JSON.parseObject(body);
        try {
            if (rspJsonObj.containsKey("rspData")) {
                String sm2Key = SM2Util.decryptByPrivateKey(rspJsonObj.getString("sm2EncryptData"), tailongBankConfig.getSm2PrivateKey());
                rspJsonObj.put("sm2EncryptData", sm2Key);
                if (!SM2Util.verifyByPublicKey(rspJsonObj.getString("sm2Sign"), tailongBankConfig.getTlPublicKey(), tailongBankConfig.getMechAppID(), sm2Key)) {
                    log.info("泰隆银行身份认证-SM2验签失败");
                    return rspJsonObj;
                } else {
                    String rspData = SM4Util.decrypt(rspJsonObj.getString("rspData"), rspJsonObj.getString("seqNO") + this.getTLToken() + tailongBankConfig.getAppSecretKey() + sm2Key);
                    log.info("泰隆银行解密后报文：" + rspData);
                    if (SM3Util.verify(rspData + rspJsonObj.getString("seqNO") + tailongBankConfig.getAppSecretKey() + sm2Key, rspJsonObj.getString("sign"))) {
                        if (rspData == null) {
                            throw new RuntimeException("解析异常");
                        }
                        return JSON.parseObject(rspData).getJSONObject("body");
                    } else {
                        log.info("报文一致性校验失败");
                        return rspJsonObj;
                    }
                }
            }
        } catch (Exception e) {
            log.warn(" 泰隆银行  getResponseNotify  body = {}", body, e);
            return rspJsonObj;
        }
        return rspJsonObj;
    }
}
