package cn.com.duiba.constant;

import com.google.common.collect.Sets;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

import java.util.Set;

@Configuration
@ConfigurationProperties(prefix = "skip.nofity")
public class SkipNotifyConfig {
    /**
     * 应用id集合
     */
    private Set<Long> appIdSet = Sets.newHashSet(-1L);

    public Set<Long> getAppIdSet() {
        return appIdSet;
    }

    public void setAppIdSet(Set<Long> appIdSet) {
        this.appIdSet = appIdSet;
    }

    public boolean hasNotNotify(Long appId) {
        if(CollectionUtils.isEmpty(appIdSet)){
            return false;
        }

        return appIdSet.contains(appId);
    }
}
