package cn.com.duiba.constant;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

import java.util.Collections;
import java.util.Map;

/**
 * 云闪付配置文件
 *
 * @author XuJing
 * @since 2020/10/26 10:05 上午
 */
@Configuration
@ConfigurationProperties(prefix = "unionpay")
public class UnionPayConstants {

	private  String virtualUrl = "https://open.95516.com/open/access/1.0/coupon.download";

	private String privateKey ="MIIBVgIBADANBgkqhkiG9w0BAQEFAASCAUAwggE8AgEAAkEAsnx3+QtFz74WrsBoJmjg2Grc+4NSNmZ0S1D13/7hELqFZmUCI/qyL1HVTvEleNBGEce2tl3EJ0aBz5ai7xIEEwIDAQABAkEAqyY1eMb5c2JIp9tyQ1qQOJYIPtlG7UlDPLFuhBMIyBsncaicSdW7jgq6KRQKht3dBIzjE5JXmhfuVZTjHQL7OQIhAOqrjkfZ/B7KnQP40ZR5UPpX9KbH/DYzQEQh+8aYNQv/AiEAwrWXefftPaXurtmIvtOwDLWAsdYWlibVMD295CYeF+0CIQCXCBDLV5U3MAm8G7CvESE37dHMYVuGepe7AfAsEZvaewIgdskuJlzYwVlv6gAQasrehoJchyHjGauLOCkSphOTHGkCIQCO/BG671mdEbbdrk0P8VPsFXWDPxDPRQlOHjim/OxFBw==";

	private String prefix = "unionPayCoupon_";

	private String appConfigs;

	private Map<Long, AppConfig> appConfigMap = Collections.emptyMap();

	public String getPrefix() {
		return prefix;
	}

	public void setPrefix(String prefix) {
		this.prefix = prefix;
	}

	public String getPrivateKey() {
		return privateKey;
	}

	public void setPrivateKey(String privateKey) {
		this.privateKey = privateKey;
	}

	public String getVirtualUrl() {
		return virtualUrl;
	}

	public void setVirtualUrl(String virtualUrl) {
		this.virtualUrl = virtualUrl;
	}

	public String getAppConfigs() {
		return appConfigs;
	}

	public void setAppConfigs(String appConfigs) {
		this.appConfigs = appConfigs;
		this.appConfigMap = JSON.parseObject(appConfigs, new TypeReference<Map<Long, AppConfig>>(){});
	}

	public AppConfig getAppConfig(Long appId) {
		return appConfigMap.get(appId);
	}

	/**
	 * 每个app的私有配置
	 */
	public static class AppConfig {

		private String appId;

		public String getAppId() {
			return appId;
		}

		public void setAppId(String appId) {
			this.appId = appId;
		}
	}
}
