package cn.com.duiba.notifycenter.service.impl;

import cn.com.duiba.biz.credits.GangZhongLvApi;
import cn.com.duiba.biz.credits.GuMingApi;
import cn.com.duiba.biz.credits.HaoXiangNiApi;
import cn.com.duiba.biz.credits.InoherbApi;
import cn.com.duiba.biz.credits.JiuYangApi;
import cn.com.duiba.biz.credits.LivatApi;
import cn.com.duiba.biz.credits.QiaQiaApi;
import cn.com.duiba.biz.credits.ShandongChinaMobileApi;
import cn.com.duiba.biz.credits.WuFangZhaiApi;
import cn.com.duiba.biz.credits.ZHCreditsApi;
import cn.com.duiba.biz.credits.strategy.Impl.GuoBenApiStrategy;
import cn.com.duiba.constant.ErweihuoConfig;
import cn.com.duiba.constant.SkipNotifyConfig;
import cn.com.duiba.job.AbstractDuibaSimpleElasticJob;
import cn.com.duiba.notifycenter.dao.NotifyQueueDAO;
import cn.com.duiba.notifycenter.domain.NotifyQueueDO;
import cn.com.duiba.notifycenter.service.BussinessTypesService;
import cn.com.duiba.notifycenter.service.NotifyHttpClientPool;
import cn.com.duiba.notifycenter.service.NotifyService;
import cn.com.duiba.service.CustomService;
import cn.com.duiba.thirdparty.dto.NotifyQueueDto;
import cn.com.duiba.thirdparty.enums.NotifyTypeEnum;
import cn.com.duiba.tool.CaiNiaoTool;
import cn.com.duiba.tool.HttpRequestLog;
import cn.com.duiba.wolf.utils.BeanUtils;
import com.alibaba.fastjson.JSON;
import io.elasticjob.autoconfigure.annotation.ElasticJob;
import io.elasticjob.lite.api.ShardingContext;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.entity.GzipDecompressingEntity;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * 通知服务
 */
@ElasticJob(name = "notifyDeveloper", cron = "0 0/1 * * * ?", shardingTotalCount = 1, overwrite = true)
public class NotifyServiceImpl extends AbstractDuibaSimpleElasticJob implements NotifyService {

	private static Logger log = LoggerFactory.getLogger(NotifyServiceImpl.class);

	@Autowired
	private NotifyHttpClientPool notifyHttpClientPool;
	@Autowired
	private NotifyQueueDAO notifyQueueDAO;
	@Autowired
	private BussinessTypesService bussinessTypesService;
	@Autowired
	private CustomService customService;
	@Autowired
	private ErweihuoConfig erweihuoConfig;

	@Autowired
	private ZHCreditsApi zhCreditsApi;

	@Autowired
	private GangZhongLvApi gangZhongLvApi;

	@Autowired
	private QiaQiaApi qiaQiaApi;

	@Autowired
	private WuFangZhaiApi wuFangZhaiApi;

	@Autowired
	private GuoBenApiStrategy guoBenApiStrategy;

	@Autowired
	private ShandongChinaMobileApi shandongChinaMobileApi;

	@Autowired
	private LivatApi livatApi;

	@Autowired
	private InoherbApi inoherbApi;

	@Autowired
	private GuMingApi guMingApi;

	@Autowired
	private JiuYangApi jiuYangApi;

	@Autowired
	private HaoXiangNiApi haoXiangNiApi;

	@Autowired
	private SkipNotifyConfig skipNotifyConfig;

	private static Map<Integer, Long> timeMap = new HashMap<>();
	static {
		timeMap.put(0, 2 * 60 * 1000L);
		timeMap.put(1, 10 * 60 * 1000L);
		timeMap.put(2, 10 * 60 * 1000L);
		timeMap.put(3, 1 * 60 * 60 * 1000L);
		timeMap.put(4, 2 * 60 * 60 * 1000L);
		timeMap.put(5, 6 * 60 * 60 * 1000L);
		timeMap.put(6, 15 * 60 * 60 * 1000L);
	}

	/**
	 * 定时扫描每分钟执行次方法<br/>
	 * 0 0/1 * * * ?
	 */
	@Override
	public void doProcess(ShardingContext shardingContext) {
		scan();
	}

	@Override
	public void scan() {
		long start = System.currentTimeMillis();
		List<NotifyQueueDO> list = notifyQueueDAO.findNeedNotifyList();
		if(CollectionUtils.isEmpty(list)){
			return;
		}
		int index = 0;
		for (NotifyQueueDO queue : list) {
			if(index++ % 100 == 0){
				try{
					TimeUnit.MILLISECONDS.sleep(1000);
				}catch (InterruptedException e){
					//ignore
				}
			}
			notify(queue, "scan");
		}
		long end = System.currentTimeMillis();
		log.debug("notify scan size: {}, time: {} ms", list.size(), (end - start));
	}

	@Override
	public void notify(NotifyQueueDO queue, String fromSource) {//NOSONAR
		try {
			if (!queue.getNotifyType().equals(NotifyTypeEnum.NOTIFY_POSTSALE.getCode()) && checkPassApp(queue)) {
				return;
			}

			FutureCallback callback =  getFutureCallback(queue);
			HttpUriRequest request = bussinessTypesService.getRequest(queue);
			if (request != null) {
				NotifyTypeEnum notify = NotifyTypeEnum.getByCode(queue.getNotifyType());
				HttpRequestLog.logUrl("[action notify request][notifyType = "+notify.getDescription()+"][bizId " + queue.getDuibaOrderNum() + "] [url " + String.valueOf(request.getURI()) + "] [fromSource " + fromSource + "]");
				notifyHttpClientPool.submit(queue.getAppId(), request, callback);
			} else {
				log.info("notifyQueueId={}, can't gen notify url,delete. {}" , queue.getId(), JSON.toJSONString(queue));
				notifyQueueDAO.finish(queue.getId());
			}
		} catch (Exception e) {
			notifyQueueDAO.finish(queue.getId());
			log.error("notifyQueueId=" + queue.getId() + ",submit error:" + JSON.toJSONString(queue), e);
		}
	}

	/**
	 * 设置需要跳过的app
	 * */
	private boolean checkPassApp(NotifyQueueDO queue) {
		// 山东移动不通知
		if (shandongChinaMobileApi.isShandongChinaMobile(queue.getAppId())) {
			notifyQueueDAO.finish(queue.getId());
			return true;
		}

		//如果是二维火app，则不进行通知
		if (erweihuoConfig.getAppIds().contains(queue.getAppId())) {
			notifyQueueDAO.finish(queue.getId());
			return true;
		}

		//如果是港中旅，则不进行通知
		if (gangZhongLvApi.isGangZhongLv(queue.getAppId())) {
			notifyQueueDAO.finish(queue.getId());
			return true;
		}

		//如果是恰恰，则不进行通知
		if (qiaQiaApi.isQiaQia(queue.getAppId())) {
			notifyQueueDAO.finish(queue.getId());
			return true;
		}

		//如果是五芳斋，则不进行通知
		if (wuFangZhaiApi.isWuFangZhai(queue.getAppId())) {
			notifyQueueDAO.finish(queue.getId());
			return true;
		}

		//如果是果本，则不进行通知
		if (guoBenApiStrategy.isGuoben(queue.getAppId())) {
			notifyQueueDAO.finish(queue.getId());
			return true;
		}

		//如果是好想你，则不进行通知
		if (haoXiangNiApi.isHaoXiangNi(queue.getAppId())) {
			notifyQueueDAO.finish(queue.getId());
			return true;
		}

		//如果是九阳，并且是成功， 则不进行通知
		if (jiuYangApi.isJiuYangAppid(queue.getAppId()) && queue.getResult()) {
			notifyQueueDAO.finish(queue.getId());
			return true;
		}

		// 中宏通知
		if (zhCreditsApi.isZHApp(queue.getAppId())) {
			if (queue.getResult()) {

				// 不需要通知成功
				notifyQueueDAO.finish(queue.getId());
				return true;
			} else {
				notifyQueueDAO.finish(queue.getId());
				zhCreditsApi.rollbackCredits(queue.getDuibaOrderNum());
				return true;
			}
		}

		// 工行
//		if (icbcNotify(queue)) {
//			return true;
//		}

		// 如果是livat, 不通知
		if (livatApi.isLivat(queue.getAppId())) {
			if (queue.getResult()) {
				// 不需要通知成功
				notifyQueueDAO.finish(queue.getId());
				return true;
			} else {
				notifyQueueDAO.finish(queue.getId());
				livatApi.rollbackCredits(queue);
				return true;
			}
		}

		// 相宜本草不需要通知
		if (inoherbApi.isInoherb(queue.getAppId())) {
			notifyQueueDAO.finish(queue.getId());
			return true;
		}

		// 古茗不需要通知
		if (guMingApi.isGuMing(queue.getAppId())) {
			notifyQueueDAO.finish(queue.getId());
			return true;
		}

		return false;
	}

//	private boolean icbcNotify(NotifyQueueDO queue) {
//		//工行卡通知 积分回滚
//		if(icbcElifeApi.isIcbcApp(queue.getAppId())){
//			if (queue.getResult()) {
//				// 不需要通知成功
//				notifyQueueDAO.finish(queue.getId());
//				return true;
//			} else {
//				//rollback 是否重试
//				boolean rollback = icbcElifeApi.rollbackCredits(queue);
//				if(BooleanUtils.isTrue(rollback)){
//					notifyQueueDAO.finish(queue.getId());
//				}else{
//					reTry(queue);
//				}
//				return true;
//			}
//		}
//		return false;
//	}

	@Override
	public Date getNextTime(NotifyQueueDO notifyQueue) {
		return new Date(System.currentTimeMillis() + timeMap.get(notifyQueue.getTimes()));
	}

	/**
	 * 根据relationType获取不同的Callback
	 * @param queue
	 * @return
	 */
	private FutureCallback<HttpResponse> getFutureCallback(NotifyQueueDO queue){
		NotifyFutureCallback callback;

		if (NotifyTypeEnum.NOTIFY_POSTSALE.getCode().equals(queue.getNotifyType())){
			//售后完成通知callback直接使用最基础的通知回调
			callback=  new NotifyFutureCallback(queue);
		} else if(NotifyQueueDto.RT_RE_SIGN_CARD.equals(queue.getRelationType())){
			callback = new NotifyFutureCallback(queue);
		} else{
			callback = new CreditsNotifyFutureCallback(queue);
		}
		return callback;
	}

	/**
	 * 通用通知回调
	 */
	class NotifyFutureCallback implements FutureCallback<HttpResponse> {

		protected NotifyQueueDO notifyQueue;

		/**
		 * 构造方法
		 * @param notifyQueue
		 */
		public NotifyFutureCallback(NotifyQueueDO notifyQueue) {
			this.notifyQueue = notifyQueue;
		}

		@Override
		public void completed(HttpResponse response) {
			String body = null;
			//兑换成功的返回结果有些开发者包含双引号，这里处理一下
			//符合条件的： {status: ok} 或 {"status":"ok"} 或 {"result":"ok"} 或 {"success":"true","errorMessage":"","bizId":"1943088"} 或 {"status":"ok","errorMessage":""} 或 okok
			String rulePattern = "([:]|\\b)[\"|\\s]{0,1}(OK|ok|true)[\"]{0,1}";
			NotifyTypeEnum notify = NotifyTypeEnum.getByCode(notifyQueue.getNotifyType());
			try {
				Header header = response.getEntity().getContentEncoding();
				String entity;
				if(header != null && header.toString().contains(CaiNiaoTool.CONTENT_ENCODING_GZIP)){
					entity = EntityUtils.toString(new GzipDecompressingEntity(response.getEntity()), CaiNiaoTool.CHARSET_UTF8);
				}else{
					entity = EntityUtils.toString(response.getEntity(), CaiNiaoTool.CHARSET_UTF8);
				}
				body = convertBody4Dcustom(entity);
				if (body != null) {
					body = body.trim();
				}

				if(StringUtils.isBlank(body)){
					fail();
					return;
				}

				if(body.length() > 500){
					body = body.substring(0, 500);
					fail();
					return;
				}

				Pattern pattern = Pattern.compile(rulePattern);
				Matcher matcher = pattern.matcher(body);
				if (matcher.find( )) {
					success();
				} else {
					//排除掉很长的body，避免浪费磁盘空间
					log.info("[appId {}] [type failed] [notifyType = {}] [body= {}]", notifyQueue.getAppId(),notify.getDescription(), body);
					fail();
				}
			} catch (Exception e) {
				log.error("completed", e);
				fail();
			} finally {
				HttpRequestLog.logUrl("[action notify response] [notifyType = "+notify.getDescription()+"][bizId " + notifyQueue.getDuibaOrderNum() + "] [type completed] [body " + body + "]");
			}
		}

		@Override
		public void failed(Exception ex) {
			NotifyTypeEnum notify = NotifyTypeEnum.getByCode(notifyQueue.getNotifyType());
			HttpRequestLog.logUrl("[action notify response][notifyType = "+notify.getDescription()+"][bizId " + notifyQueue.getDuibaOrderNum() + "] [type failed] [ex " + ex.getMessage() + "]");
			fail();
		}

		@Override
		public void cancelled() {
			NotifyTypeEnum notify = NotifyTypeEnum.getByCode(notifyQueue.getNotifyType());
			HttpRequestLog.logUrl("[action notify response] [notifyType = "+notify.getDescription()+"][type cancelled] [bizId " + notifyQueue.getDuibaOrderNum() + "]");
			fail();
		}

		/**
		 * 通知成功，删除待通知记录
		 */
		protected void success() {
			notifyQueueDAO.finish(notifyQueue.getId());
		}

		/**
		 * 通知失败，更新下次通知时间
		 */
		protected void fail() {
			Calendar cal = Calendar.getInstance();
			cal.setTime(new Date());
			cal.add(Calendar.DATE, -1);
			if (notifyQueue.getTimes() > 6) {
				notifyQueueDAO.finish(notifyQueue.getId());
				log.info("appId: {},relationType={},relationId={}, notify:{} fail,drop", notifyQueue.getAppId(), notifyQueue.getRelationType(), notifyQueue.getRelationId(), notifyQueue.getTimes());
			} else if (notifyQueue.getTimes() > 1 && notifyQueue.getGmtCreate().before(cal.getTime())) {
				notifyQueueDAO.finish(notifyQueue.getId());
				log.info("appId: {},relationType={},relationId={} notify > 24h,drop",notifyQueue.getAppId(), notifyQueue.getRelationType(), notifyQueue.getRelationId());
			} else {
				Date nexttime = getNextTime(notifyQueue);
				notifyQueueDAO.updateNextTime(notifyQueue.getId(), notifyQueue.getTimes() + 1, nexttime);
			}
		}

		/**
		 * 子类可以重载以适配不同的开发者响应格式
		 * @param entity
		 * @return
		 */
		protected String convertBody4Dcustom(String entity){
			return entity;
		}

	}

	/**
	 * 订单通知HTTP请求回调类
	 */
	class CreditsNotifyFutureCallback extends NotifyFutureCallback {

		/**
		 * 构造方法
		 * @param notifyQueue
		 */
		public CreditsNotifyFutureCallback(NotifyQueueDO notifyQueue) {
			super(notifyQueue);
		}

		@Override
		protected String convertBody4Dcustom(String entity){
			return customService.getResponseNotify(notifyQueue.getAppId(), entity);
		}
	}

	@Override
	public void notifyFromMq(NotifyQueueDto notifyQueue) {
		try {
			if (skipNotifyConfig.hasNotNotify(notifyQueue.getAppId())) {
				log.info("the app skip notify, appId={}", notifyQueue.getAppId());
				return;
			}

			NotifyQueueDO queue = BeanUtils.copy(notifyQueue, NotifyQueueDO.class);
			if(queue.getTimes() == null){
				queue.setTimes(0);
			}
			if(queue.getNextTime() == null){
				queue.setNextTime(new Date());
			}
			if(queue.getNotifyType() == null){//默认结果通知，向上兼容
				queue.setNotifyType(NotifyTypeEnum.NOTIFY_RESULT.getCode());
			}
			if(NotifyTypeEnum.getByCode(queue.getNotifyType())==null){
				log.error("通知类型不存在;queue:{}",JSON.toJSONString(queue));
				return;
			}
			String errorMsg = queue.getError4developer();
			if(StringUtils.isNotBlank(errorMsg) && errorMsg.length() > 600){
				queue.setError4developer(errorMsg.substring(0, 600));
			}
			notifyQueueDAO.insert(queue);
			notify(queue, "mq call");
		} catch (Exception e) {
			log.error("notify error", e);
		}
	}

//	private void reTry(NotifyQueueDO notifyQueue) {
//		Calendar cal = Calendar.getInstance();
//		cal.setTime(new Date());
//		cal.add(Calendar.DATE, -1);
//		if (notifyQueue.getTimes() > 6) {
//			notifyQueueDAO.finish(notifyQueue.getId());
//			log.info("appId: {},relationType={},relationId={}, notify:{} fail,drop", notifyQueue.getAppId(), notifyQueue.getRelationType(), notifyQueue.getRelationId(), notifyQueue.getTimes());
//		} else if (notifyQueue.getTimes() > 1 && notifyQueue.getGmtCreate().before(cal.getTime())) {
//			notifyQueueDAO.finish(notifyQueue.getId());
//			log.info("appId: {},relationType={},relationId={} notify > 24h,drop",notifyQueue.getAppId(), notifyQueue.getRelationType(), notifyQueue.getRelationId());
//		} else {
//			Date nexttime = getNextTime(notifyQueue);
//			notifyQueueDAO.updateNextTime(notifyQueue.getId(), notifyQueue.getTimes() + 1, nexttime);
//		}
//	}
}
