package cn.com.duiba.remoteimpl;

import cn.com.duiba.service.DingService;
import cn.com.duiba.thirdparty.alarm.Dingding;
import cn.com.duiba.thirdparty.alarm.Mail;
import cn.com.duiba.thirdparty.alarm.Message;
import cn.com.duiba.thirdparty.api.RemoteAlarmService;
import cn.com.duiba.tool.ErrorCode;
import cn.com.duiba.wolf.dubbo.DubboResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 报警接口实现类
 */
@RestController
public class RemoteAlarmServiceImpl implements RemoteAlarmService {

    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteChargeServiceImpl.class);
    @Autowired
    private DingService dingService;

  @Override
    public DubboResult<Boolean> sendMail(String[] toMail, String title, String content, boolean isHtml) {
        try {
            return DubboResult.successResult(Mail.send(toMail, title, content, isHtml));
        } catch (Exception e) {
            LOGGER.error("sendMail", e);
            return DubboResult.failResult(ErrorCode.E9999999.getDesc());
        }
    }

    @Override
    public DubboResult<String> sendMessage(String phone, String text) {
        try {
            return DubboResult.successResult(Message.sned(phone, text));
        } catch (Exception e) {
            LOGGER.error("sendMessage", e);
            return DubboResult.failResult(ErrorCode.E9999999.getDesc());
        }
    }

    @Override
    public DubboResult<String> sendDingding(String robootKey, String text) {
        try {
            return DubboResult.successResult(Dingding.send(robootKey, text));
        } catch (Exception e) {
            LOGGER.error("sendDingding", e);
            return DubboResult.failResult(ErrorCode.E9999999.getDesc());
        }
    }

    @Override
    public Boolean sendPersonalDingTextMsgByEmail(List<String> emails, String content) {
        try {
            dingService.sendPersonalDingTextMsgByEmail(emails, content);
        } catch (Exception e) {
            LOGGER.error(e.getMessage(), e);
            return false;
        }
        return true;
    }

    @Override
    public Boolean sendPersonalDingTextMsgByDingId(List<String> dingUserIds, String content) {
        try {
            dingService.sendPersonalDingTextMsgByDingId(dingUserIds, content);
        } catch (Exception e) {
            LOGGER.error(e.getMessage(), e);
            return false;
        }
        return true;
    }
}
