package cn.com.duiba.biz.credits;

import cn.com.duiba.api.bo.subcredits.SubCreditsMsgDto;
import cn.com.duiba.domain.SubCreditsMsgWrapper;
import cn.com.duiba.order.center.api.dto.CreditsMessage;
import cn.com.duiba.tool.JsonTool;
import cn.com.duiba.wolf.utils.DateUtils;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.*;

/**
 * Created by zzy on 2017/6/16.
 */
@Service
public class TaojinbiApi {

    private static final String SUB_CREDITS_METHOD = "taobao.coin.buyer.consume";
    private static final Logger log = LoggerFactory.getLogger(TaojinbiApi.class);
    /**
     * 兑吧在淘宝的App的appkey
     */
    @Value("${taobao.app.appkey}")
    private String taobaoAppkey;
    /**
     * 兑吧在淘宝的App的appsecret
     */
    @Value("${taobao.app.secret}")
    private String taobaoAppSecret;

    /**
     * 构造淘金币请求.
     *
     * @param request
     * @return
     */
    public CreditsMessage getCreditsMessage(CreditsMessage request) {
        Map<String, String> params = request.getParams();
        Map<String, String> authParams = new HashMap<>();
        authParams.put("method", SUB_CREDITS_METHOD);
        authParams.put("app_key", taobaoAppkey);
        authParams.put("sign_method", "md5");
        authParams.put("session", params.get("accessKey"));
        authParams.put("timestamp", DateUtils.getSecondStr(new Date()));
        authParams.put("format", "json");
        authParams.put("v", "2.0");
        authParams.put("buyer_nick", params.get("mixUserNick"));
        authParams.put("amount", params.get("credits"));
        authParams.put("token", params.get("token"));
        // 生成签名
        authParams.put("sign", sign(authParams));

        request.setAuthParams(authParams);
        request.setHttpType(CreditsMessage.HTTP_POST);
        String url = request.getHttpUrl().substring(0, request.getHttpUrl().indexOf('?'));
        request.setHttpUrl(url);
        return request;
    }

    /**
     * 构造淘金币请求.
     *
     * @param request
     * @return
     */
    public SubCreditsMsgWrapper getCreditsMessage(SubCreditsMsgWrapper request) {
        Map<String, String> params = request.getSubCreditsMsg().getParams();
        Map<String, String> authParams = new HashMap<>();
        authParams.put("method", SUB_CREDITS_METHOD);
        authParams.put("app_key", taobaoAppkey);
        authParams.put("sign_method", "md5");
        authParams.put("session", params.get("accessKey"));
        authParams.put("timestamp", DateUtils.getSecondStr(new Date()));
        authParams.put("format", "json");
        authParams.put("v", "2.0");
        authParams.put("buyer_nick", params.get("mixUserNick"));
        authParams.put("amount", params.get("credits"));
        authParams.put("token", params.get("token"));
        // 生成签名
        authParams.put("sign", sign(authParams));

        request.getSubCreditsMsg().setAuthParams(authParams);
        request.getSubCreditsMsg().setHttpType(SubCreditsMsgDto.HTTP_POST);
        String url = request.getHttpUrl().substring(0, request.getHttpUrl().indexOf('?'));
        request.setHttpUrl(url);
        return request;
    }


    /**
     * 解析响应
     *
     * @param msg
     * @return
     */
    public String parseCreditsRsp(String msg) {
        JSONObject jsonObject;
        try {
            jsonObject = JSONObject.parseObject(msg);
        } catch (Exception e) {
            log.error("JSON.parseObject:", e);
            return msg;
        }

        JSONObject allJson = JsonTool.getAllJson(jsonObject);
        Map<String, String> duibaDoc = new HashMap<>();
        boolean success = false;
        Long subCredits = allJson.getLong("succ_amount");
        if (subCredits != null) {
            success = true;
        }
        duibaDoc.put("status", success ? "ok" : "fail");
        String code = allJson.getString("code");
        String errorMessage = null;
        if (code != null) {
            String errmsg = allJson.getString("msg");
            String subCode = allJson.getString("sub_code");
            String errSubMsg = allJson.getString("sub_msg");
            errorMessage = new StringBuilder(code).append('|').append(errmsg).append('|')
                    .append(subCode).append('|').append(errSubMsg).toString();

        }
        if (errorMessage != null) {
            duibaDoc.put("errorMessage", errorMessage);
        }
        String traceId = allJson.getString("trace_id");
        if (traceId != null) {
            duibaDoc.put("bizId", traceId);
        }
        String totalAmount = allJson.getString("total_amount");
        if (totalAmount != null) {
            duibaDoc.put("credits", totalAmount);
        }
        return JsonTool.objectToJson(duibaDoc);
    }

    /**
     * http://open.taobao.com/docs/doc.htm?spm=a219a.7395905.0.0.zwO2pM&articleId=101617&docType=1&treeId=1
     *
     * @param params
     * @return
     */
    private String sign(Map<String, String> params) {
        List<String> keys = new ArrayList<>(params.keySet());
        Collections.sort(keys);
        StringBuilder string = new StringBuilder();
        string.append(taobaoAppSecret);
        for (String key : keys) {
            string.append(key).append(params.get(key));
        }
        string.append(taobaoAppSecret);
        return DigestUtils.md5Hex(string.toString()).toUpperCase();
    }
}
