package cn.com.duiba.biz.credits.strategy.Impl;

import cn.com.duiba.biz.credits.strategy.ApiStrategy;
import cn.com.duiba.credits.sdk.SignTool;
import cn.com.duiba.domain.SubCreditsMsgWrapper;
import cn.com.duiba.thirdparty.dto.CreditsMessageDto;
import cn.com.duiba.tool.AssembleTool;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.StringEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.UnsupportedEncodingException;
import java.util.Map;
import java.util.Objects;

/**
 * @author: pengyi
 * @description:
 * @date: 2021/9/3 下午3:31
 */
public class ZhiJiApiStrategy implements ApiStrategy {

    private static final Logger LOGGER = LoggerFactory.getLogger(ZhiJiApiStrategy.class);

    private final RequestConfig requestConfig;
    private static final int FIVE_SECONDS = 5*1000;
    private static final int TEN_SECONDS = 10*1000;
    {
        //http请求超时配置
        requestConfig = RequestConfig.custom().setConnectTimeout(FIVE_SECONDS).setSocketTimeout(TEN_SECONDS).setConnectionRequestTimeout(500).build();
    }

    @Override
    public HttpRequestBase getMqSubCreditsHttpRequest(SubCreditsMsgWrapper message) {
        //请求链接
        String url = getHostName(message.getHttpUrl());
        HttpPost httpPost = new HttpPost(url);
        Map<String, String> originData = AssembleTool.getUrlParams(getParamUrl(message.getHttpUrl()));
        LOGGER.info("智己-扣积分参数，params：{}", JSON.toJSONString(originData));
        Map<String,String> requestParams = Maps.newHashMap();
        // 从url中取，是兑吧官方扣积分文档中的参数，会放在url
        requestParams.put("RedeemPoints", originData.get("credits"));
        requestParams.put("TransactionType", originData.get("description"));
        requestParams.put("RedeemNumber", originData.get("orderNum"));
        requestParams.put("TraceId", originData.get("orderNum") + "6位随机数");
        // 定制参数
        Map<String, String> customParams = message.getSubCreditsMsg().getParams();
        requestParams.put("superId", customParams.get("superId"));
        // 固定参数
        requestParams.put("Type", "Point");
        requestParams.put("SourceCode", "DUIBA");
        requestParams.put("RedeemTime", "兑换时间(MM/DD/YYYY HH24:MI:SS)");
        requestParams.put("sign", SignTool.sign(requestParams));
        try {
            httpPost.setEntity(new StringEntity(JSON.toJSONString(requestParams)));
            httpPost.setConfig(requestConfig);
        } catch (UnsupportedEncodingException e) {
            LOGGER.warn("智己-扣积分请求生成失败，params：{}", message);
        }
        return httpPost;
    }

    /**
     * 智己积分返回参数解析
     * @param body
     * @param addCredits
     * @param authParams
     * @return
     */
    @Override
    public String parseCreditsRsp(String body, Boolean addCredits, Map<String, String> authParams) {
        JSONObject response = JSON.parseObject(body);
        LOGGER.info("智己-积分返回参数，params：{}", body);
        JSONObject result = new JSONObject();
        result.put("bizId", response.get("TxnId"));
        if (Objects.equals("0", response.get("ErrorCode"))) {
            result.put("status","ok");
        } else {
            result.put("status", "fail");
        }
        result.put("errorMessage", response.get("ErrorMessage"));
        return result.toJSONString();
    }

    @Override
    public HttpRequestBase getAddCreditsMessageRequest(CreditsMessageDto message) {
        return null;
    }

    /**
     * 截取域名
     *
     * @param url -
     * @return 域名
     */
    public static String getHostName(String url) {
        return url.substring(0, url.indexOf('?'));
    }

    public static String getParamUrl(String url) {
        return url.substring(url.indexOf('?') + 1);
    }
}
