package cn.com.duiba.biz.credits.unionpay;

import cn.com.duiba.biz.Exception.ThirdpatyException;
import cn.com.duiba.constant.UnionPayConstants;
import cn.com.duiba.constant.base.BaseUnionBankConstants;
import cn.com.duiba.domain.SupplierRequest;
import cn.com.duiba.tool.AssembleTool;
import cn.com.duiba.tool.DES3Tool;
import cn.com.duiba.tool.UnionPayBankUtil;
import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public abstract class BaseUnionPayRequest implements UnionPayRequest {
    protected static final Logger LOGGER = LoggerFactory.getLogger(BaseUnionPayRequest.class);

    @Autowired
    protected UnionPayConstants unionPayConstants;

    public String getBaseResponse(String body, SupplierRequest request, BaseUnionBankConstants baseUnionBankConstants, String merchantCoding) {
        if (StringUtils.isBlank(merchantCoding) || !merchantCoding.startsWith(baseUnionBankConstants.getVirtualCreditsPre())) {
            return null;
        }
        Map<String, String> map = new HashMap<>();
        if (StringUtils.isBlank(body)) {
            throw new ThirdpatyException("云闪付，虚拟商品定制，返回结果为空");
        }
        LOGGER.info("云闪付{}定制返回结果为:{}", request.getOrderId(), body.length() > 500 ? body.substring(0, 500): body);
        try {
            JSONObject jsonObject = JSON.parseObject(body);
            map.put("status", Objects.equals("00", jsonObject.getString("resp")) ? "success" : "fail");
            map.put("errorMessage", StringEscapeUtils.unescapeHtml4(jsonObject.getString("msg")));
            map.put("supplierBizId", jsonObject.getString("transSeqId"));
            String info = (String)jsonObject.get("info");
            if(StringUtils.isNotBlank(info)){
                JSONObject awardObject = JSON.parseObject(info);
                String awardId = (String)awardObject.get("awardId");
                //如果有奖项值，重写
                if(StringUtils.isNotBlank(awardId)){
                    map.put("supplierBizId", awardId);
                }
            }
        } catch (Exception e) {
            LOGGER.error("云闪付，虚拟商品定制，结果解析错误:{}", body, e);
            map.put("status", "fail");
            map.put("errorMessage", "虚拟商品充值接口响应解析错误");
        }
        return JSON.toJSONString(map);
    }

    @NotNull
    public Map<String, String> buildCommReq(Map<String, String> authParamMap, Map<String, String> params, Long appId) {
        Map<String, String> requestParams = new HashMap<>();
        //获取银联appId
        if(StringUtils.isBlank(params.get("devAppId"))){
            requestParams.put("appId", unionPayConstants.getAppConfig(String.valueOf(appId)).getAppId());
        }else{
            requestParams.put("appId", params.get("devAppId"));
        }

        requestParams.put("transSeqId", authParamMap.get("orderNum"));
        requestParams.put("transTs", DateUtil.format(new Date(), "yyyyMMdd"));
        if(StringUtils.isBlank(params.get("devAppId"))){
            requestParams.put("openId", authParamMap.get("uid"));
        }else{
            requestParams.put("mobile", params.get("mobile"));
        }
        requestParams.put("acctEntityTp", "03");

        requestParams.put("nonceStr", UnionPayBankUtil.createNonceStr());
        requestParams.put("timestamp", Long.toString(System.currentTimeMillis() / 1000));
        return requestParams;
    }

    /**
     * 校验并获取url参数
     * @param request
     * @return
     */
    public Map<String, String> getUrlParams(SupplierRequest request) {
        String url = request.getHttpUrl();
        String authParams = url.substring(url.indexOf('?') + 1);
        return AssembleTool.getUrlParams(authParams);
    }
}
