package cn.com.duiba.constant;

import cn.com.duiba.biz.credits.strategy.ApiStrategyRouter;
import cn.com.duiba.biz.credits.strategy.Impl.ZhiJiApiStrategy;
import com.alibaba.fastjson.JSON;
import com.google.common.collect.Sets;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

import javax.annotation.Resource;
import java.util.Map;
import java.util.Set;

/**
 * @author: pengyi
 * @description: 智己汽车配置
 * @date: 2021/9/2 下午7:24
 */
@Configuration
@ConfigurationProperties(prefix = "zhiji")
public class ZhiJiConfig implements InitializingBean {

    private Set<Long> appIds = Sets.newHashSet(1L);

    public Boolean isVerifyZhiJi(Long appId) {
        return this.appIds.contains(appId);
    }

    public Set<Long> getAppIds() {
        return appIds;
    }

    public void setAppIds(Set<Long> appIds) {
        this.appIds = appIds;
    }

    @Resource
    private ZhiJiApiStrategy zhiJiApiStrategy;

    @Override
    public void afterPropertiesSet() throws Exception {
        // 注册智己积分策略
        ApiStrategyRouter.register(appIds, zhiJiApiStrategy);
    }
}
