package cn.com.duiba.remoteimpl.zhiji;

import cn.com.duiba.enums.zhiji.ZhiJiCodeEnum;
import cn.com.duiba.enums.zhiji.ZhiJiStatusEnum;
import cn.com.duiba.thirdparty.api.zhiji.RemoteZhiJiService;
import cn.com.duiba.thirdparty.dto.zhiji.ZhiJiOrderInfoDto;
import cn.com.duiba.thirdparty.dto.zhiji.response.ZhiJiOrderResponse;
import cn.com.duiba.thirdparty.dto.zhiji.response.ZhiJiResponse;
import cn.com.duiba.thirdparty.dto.zhiji.ZhiJiReturnFlowDto;
import cn.com.duiba.thirdparty.dto.zhiji.ZhiJiUserReceivedAddressDto;
import cn.com.duiba.tool.zhiji.ZhiJiParamTool;
import com.alibaba.fastjson.JSONObject;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RestController;
import javax.annotation.Resource;
import java.util.Collections;
import java.util.List;

/**
 * @author: pengyi
 * @description: 智己汽车-对外接口实现
 * @date: 2021/9/1 下午1:52
 */
@RestController
public class RemoteZhiJiServiceImpl implements RemoteZhiJiService {

    private static final Logger log = LoggerFactory.getLogger(RemoteZhiJiServiceImpl.class);
    @Resource(name = "httpClient")
    private CloseableHttpClient httpClient;

    @Override
    public String saveReceiveAddress(ZhiJiUserReceivedAddressDto dto) {
        HttpPost httpPost = ZhiJiParamTool.createHttpRequest(dto, "");
        try(final CloseableHttpResponse response = httpClient.execute(httpPost)) {
            // 响应参数
            String responseStr = EntityUtils.toString(response.getEntity());
            log.info("智己-新增收获地址信息，智己响应参数，param:{}", responseStr);
            ZhiJiResponse respParam = JSONObject.parseObject(responseStr, ZhiJiResponse.class);
            // 智己侧响应失败
            if (ZhiJiStatusEnum.FAIL.getCode().equals(respParam.getStatus()) || !ZhiJiCodeEnum.SUCCESS.getCode().equals(respParam.getCode())) {
                log.warn("智己-新增收获地址信息，智己响应失败，param:{}", responseStr);
                return ZhiJiStatusEnum.FAIL.getCode();
            }
            // 响应成功
            return respParam.getAddressId();
        } catch (Exception e) {
            log.warn("智己-新增收获地址信息，智己响应异常，param:{}", dto, e);
        }
        return ZhiJiStatusEnum.FAIL.getCode();
    }

    @Override
    public Long removeReceiveAddress(ZhiJiUserReceivedAddressDto dto) {
        HttpPost httpPost = ZhiJiParamTool.createHttpRequest(dto,"");
        try(final CloseableHttpResponse response = httpClient.execute(httpPost)) {
            // 响应参数
            String responseStr = EntityUtils.toString(response.getEntity());
            log.info("智己-删除收获地址信息，智己响应参数，param:{}", responseStr);
            ZhiJiResponse zhiJiResponse = JSONObject.parseObject(responseStr, ZhiJiResponse.class);
            // 智己侧响应失败
            if (ZhiJiStatusEnum.FAIL.getCode().equals(zhiJiResponse.getStatus()) || !ZhiJiCodeEnum.SUCCESS.getCode().equals(zhiJiResponse.getCode())) {
                log.warn("智己-删除收获地址信息，智己响应失败，param:{}", responseStr);
                return -1L;
            }
            // 响应成功
            return 1L;
        } catch (Exception e) {
            log.warn("智己-删除收获地址信息，智己响应异常，param:{}", dto, e);
        }
        return -1L;
    }

    @Override
    public Long updateReceiveAddress(ZhiJiUserReceivedAddressDto dto) {
        HttpPost httpPost = ZhiJiParamTool.createHttpRequest(dto,"");
        try(final CloseableHttpResponse response = httpClient.execute(httpPost)) {
            // 响应参数
            String responseStr = EntityUtils.toString(response.getEntity());
            log.info("智己-编辑收获地址信息，智己响应参数，param:{}", responseStr);
            ZhiJiResponse zhiJiResponse = JSONObject.parseObject(responseStr, ZhiJiResponse.class);
            // 智己侧响应失败
            if (ZhiJiStatusEnum.FAIL.getCode().equals(zhiJiResponse.getStatus()) || !ZhiJiCodeEnum.SUCCESS.getCode().equals(zhiJiResponse.getCode())) {
                log.warn("智己-编辑收货地址信息，智己响应失败，param:{}", responseStr);
                return -1L;
            }
            // 响应成功
            return 1L;
        } catch (Exception e) {
            log.warn("智己-编辑收货地址信息，智己响应异常，param:{}", dto, e);
        }
        return -1L;
    }

    @Override
    public List<ZhiJiUserReceivedAddressDto> selectReceiveAddress(ZhiJiUserReceivedAddressDto dto) {
        HttpPost httpPost = ZhiJiParamTool.createHttpRequest(dto,"");
        try(final CloseableHttpResponse response = httpClient.execute(httpPost)) {
            // 响应参数
            String responseStr = EntityUtils.toString(response.getEntity());
            log.info("智己-查询收获地址信息，智己响应参数，param:{}", responseStr);
            ZhiJiResponse zhiJiResponse = JSONObject.parseObject(responseStr, ZhiJiResponse.class);
            // 智己侧响应失败
            if (ZhiJiStatusEnum.FAIL.getCode().equals(zhiJiResponse.getStatus()) || !ZhiJiCodeEnum.SUCCESS.getCode().equals(zhiJiResponse.getCode())) {
                log.warn("智己-查询收货地址信息，智己响应失败，param:{}", responseStr);
                return Collections.emptyList();
            }
            List<ZhiJiUserReceivedAddressDto> dtoList = JSONObject.parseArray(JSONObject.toJSONString(zhiJiResponse.getData()), ZhiJiUserReceivedAddressDto.class);
            // 响应成功
            return dtoList;
        } catch (Exception e) {
            log.warn("智己-查询收货地址信息，智己响应异常，param:{}", dto, e);
        }
        return Collections.emptyList();
    }

    @Override
    public Long saveReturnFlow(ZhiJiReturnFlowDto dto) {
        HttpPost httpPost = ZhiJiParamTool.createHttpRequest(dto,"");
        try(final CloseableHttpResponse response = httpClient.execute(httpPost)) {
            // 响应参数
            String responseStr = EntityUtils.toString(response.getEntity());
            log.info("智己-推送退货物流信息，智己响应参数，param:{}", responseStr);
            ZhiJiResponse zhiJiResponse = JSONObject.parseObject(responseStr, ZhiJiResponse.class);
            // 智己侧响应失败
            if (ZhiJiStatusEnum.FAIL.getCode().equals(zhiJiResponse.getStatus()) || !ZhiJiCodeEnum.SUCCESS.getCode().equals(zhiJiResponse.getCode())) {
                log.warn("智己-推送退货物流信息，智己响应失败，param:{}", responseStr);
                return -1L;
            }
            // 响应成功
            return 1L;
        } catch (Exception e) {
            log.warn("智己-推送退货物流信息，智己响应异常，param:{}", dto, e);
        }
        return -1L;
    }

    @Override
    public ZhiJiOrderResponse syncOrderInfo(ZhiJiOrderInfoDto orderInfoDto) {
        return null;
    }
}
