package cn.com.duiba.tool.zhiji;

import cn.com.duiba.credits.sdk.SignTool;
import com.google.common.collect.Maps;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.methods.HttpPost;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.lang.reflect.Field;
import java.util.Map;

/**
 * @author: pengyi
 * @description: 智己参数构建解析工具
 * @date: 2021/9/1 下午4:30
 */
public class ZhiJiParamTool {

    private final static Logger log = LoggerFactory.getLogger(ZhiJiParamTool.class);

    /**
     * 构建参数，创建httpPost请求
     * @param dto
     * @return
     */
    public static HttpPost createHttpRequest(Object dto, String url) {
        if (dto == null || StringUtils.isBlank(url)) {
            return null;
        }
        HttpPost httpPost = new HttpPost(url);
        try {
            Map<String, String> params = dtoConvertParams(dto);
            String sign = SignTool.sign(params);
            params.put("sign", sign);
        } catch (Exception e) {
            log.warn("智己-发送请求，参数解析失败，url:{}, param:{}", url, dto, e);
        }
        return httpPost;
    }

    /**
     * dto类转位map
     * 不为空的字段会放入map中
     * @param obj
     * @return
     * @throws IllegalAccessException
     */
    public static Map<String, String> dtoConvertParams(Object obj) throws IllegalAccessException {
        if (obj == null) {
            return null;
        }
        Map<String, String> params = Maps.newHashMap();
        Class clazz = obj.getClass();
        Field[] fields = clazz.getDeclaredFields();
        for (Field field : fields) {
            field.setAccessible(true);
            if (field.get(obj) != null) {
                params.put(field.getName(), String.valueOf(field.get(obj)));
            }
        }
        return params;
    }
}
