/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.biz.credits;

import cn.com.duiba.api.bo.subcredits.SubCreditsMsgDto;
import cn.com.duiba.constant.BaiguoyuanConfig;
import cn.com.duiba.credits.sdk.SignTool;
import cn.com.duiba.dao.AppDAO;
import cn.com.duiba.domain.AppDO;
import cn.com.duiba.domain.SubCreditsMsgWrapper;
import cn.com.duiba.domain.SupplierRequest;
import cn.com.duiba.thirdparty.dto.CreditsMessageDto;
import cn.com.duiba.tool.AssembleTool;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BaiguoyuanApi {
    public static final Logger LOGGER = LoggerFactory.getLogger(BaiguoyuanApi.class);
    @Autowired
    private AppDAO appDAO;
    @Autowired
    private BaiguoyuanConfig baiguoyuanConfig;

    public boolean isBaiguoyuan(Long appId) {
        if (CollectionUtils.isEmpty(this.baiguoyuanConfig.getAppIds())) {
            return false;
        }
        return this.baiguoyuanConfig.getAppIds().contains(appId);
    }

    public SubCreditsMsgWrapper getSubCreditsMessage(SubCreditsMsgWrapper subCreditsMsgWrapper) {
        SubCreditsMsgDto subCreditsMsg = subCreditsMsgWrapper.getSubCreditsMsg();
        Map params = subCreditsMsg.getParams();
        if (params == null || params.isEmpty()) {
            return subCreditsMsgWrapper;
        }
        Map map = subCreditsMsg.getCreditConsumeParams().toRequestMap(subCreditsMsg.getAppSecret());
        map.putIfAbsent("activityId", BaiguoyuanApi.combineActivityId(subCreditsMsg.getRelationId(), subCreditsMsg.getRelationType().getMsg()));
        Map<String, String> newAuth = this.addParamsAndReSign(subCreditsMsg.getAppSecret(), map, params);
        LOGGER.info("BaiguoyuanApi getSubCreditsMessage before url={}", (Object)subCreditsMsgWrapper.getHttpUrl());
        subCreditsMsgWrapper.setHttpUrl(BaiguoyuanApi.getNewHttpUrl4Get(BaiguoyuanApi.getPureUrl(subCreditsMsgWrapper.getHttpUrl()), newAuth));
        LOGGER.info("BaiguoyuanApi getSubCreditsMessage after url={}", (Object)subCreditsMsgWrapper.getHttpUrl());
        return subCreditsMsgWrapper;
    }

    public CreditsMessageDto getAddCreditsMessage(CreditsMessageDto request) {
        Map params = request.getParams();
        if (params == null || params.isEmpty()) {
            return request;
        }
        String appSecret = this.getAppSecret(Long.valueOf(request.getAppId()));
        params.putIfAbsent("activityId", BaiguoyuanApi.combineActivityId(request.getRelationId(), request.getRelationType()));
        request.setAuthParams(this.addParamsAndReSign(appSecret, request.getAuthParams(), params));
        LOGGER.info("BaiguoyuanApi getAddCreditsMessage before url={}", (Object)request.getHttpUrl());
        request.setHttpUrl(BaiguoyuanApi.getNewHttpUrl4Get(BaiguoyuanApi.getPureUrl(request.getHttpUrl()), request.getAuthParams()));
        LOGGER.info("BaiguoyuanApi getAddCreditsMessage after url={}", (Object)request.getHttpUrl());
        return request;
    }

    public SupplierRequest getVirtualRequest(SupplierRequest request) {
        Map<String, String> params = request.getParams();
        if (params == null || params.isEmpty()) {
            return request;
        }
        params.putIfAbsent("activityId", BaiguoyuanApi.combineActivityId(request.getSupplierOrderId(), null));
        String url = request.getHttpUrl();
        String requestParams = url.substring(url.indexOf(63) + 1);
        Map<String, String> authParams = AssembleTool.getUrlParams(requestParams);
        String appSecret = this.getAppSecret(Long.valueOf(request.getAppId()));
        request.setAuthParams(this.addParamsAndReSign(appSecret, authParams, params));
        LOGGER.info("BaiguoyuanApi getVirtualRequest before url={}", (Object)request.getHttpUrl());
        request.setHttpUrl(BaiguoyuanApi.getNewHttpUrl4Get(BaiguoyuanApi.getPureUrl(request.getHttpUrl()), request.getAuthParams()));
        LOGGER.info("BaiguoyuanApi getVirtualRequest after url={}", (Object)request.getHttpUrl());
        return request;
    }

    private String getAppSecret(Long appId) {
        AppDO appDO = this.appDAO.getAppByCache((long)appId);
        return this.appDAO.getAppSecret(appDO);
    }

    @NotNull
    private static String getNewHttpUrl4Get(String pureUrl, Map<String, String> authParams) {
        return AssembleTool.assembleUrl(pureUrl, authParams);
    }

    private Map<String, String> addParamsAndReSign(String appSecret, Map<String, String> authParams, Map<String, String> params) {
        authParams.remove("sign");
        for (Map.Entry<String, String> entry : params.entrySet()) {
            if (!this.baiguoyuanConfig.getParamsKeys().contains(entry.getKey())) continue;
            authParams.put(entry.getKey(), entry.getValue());
        }
        authParams.put("appSecret", appSecret);
        authParams.put("sign", SignTool.sign(authParams));
        authParams.remove("appSecret");
        return authParams;
    }

    private static String getPureUrl(String urlWithParams) {
        return urlWithParams.substring(0, urlWithParams.indexOf(63));
    }

    private static String combineActivityId(String relationId, String relationType) {
        if (StringUtils.isBlank((CharSequence)relationType)) {
            return relationId;
        }
        return String.format("%s_%s", relationType, relationId);
    }
}

