/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.biz.credits;

import cn.com.duiba.biz.Exception.ThirdpatyException;
import cn.com.duiba.constant.InoherbConstant;
import cn.com.duiba.domain.SubCreditsMsgWrapper;
import cn.com.duiba.domain.SupplierRequest;
import cn.com.duiba.enums.redis.RedisKeyEnum;
import cn.com.duiba.thirdparty.dto.CreditsMessageDto;
import cn.com.duiba.tool.AssembleTool;
import cn.com.duiba.tool.HttpUtils;
import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.web.util.UriComponentsBuilder;

@Service
public class InoherbApi {
    private static final Logger log = LoggerFactory.getLogger(InoherbApi.class);
    @Resource
    private InoherbConstant inoherbConstant;
    @Resource(name="httpClient")
    private CloseableHttpClient httpClient;
    @Resource(name="stringRedisTemplate")
    private StringRedisTemplate redisTemplate;

    public boolean isInoherb(Long appId) {
        return this.inoherbConstant.getAppId().contains(appId);
    }

    public HttpRequestBase getAddCreditsHttpRequest(CreditsMessageDto message) {
        String url = message.getHttpUrl();
        String newUrl = url.substring(0, url.indexOf(63));
        String paramsStr = url.substring(url.indexOf(63) + 1);
        Map<String, String> authParams = AssembleTool.getUrlParams(paramsStr);
        Map<String, String> body = this.getCreditsHttpBody(authParams, true);
        newUrl = UriComponentsBuilder.fromHttpUrl((String)newUrl).queryParam("token", new Object[]{this.getAccessToken()}).build().toUri().toString();
        message.setHttpType("post");
        message.setHttpUrl(newUrl);
        message.setAuthParams(body);
        return this.getHttpPost(message.getHttpUrl(), JSON.toJSONString(body));
    }

    public HttpRequestBase getSubCreditsHttpRequest(SubCreditsMsgWrapper message) {
        String url = message.getHttpUrl();
        String newUrl = url.substring(0, url.indexOf(63));
        String paramsStr = url.substring(url.indexOf(63) + 1);
        Map<String, String> authParams = AssembleTool.getUrlParams(paramsStr);
        Map<String, String> body = this.getCreditsHttpBody(authParams, false);
        newUrl = UriComponentsBuilder.fromHttpUrl((String)newUrl).queryParam("token", new Object[]{this.getAccessToken()}).build().toUri().toString();
        message.getSubCreditsMsg().setHttpType(2);
        message.setHttpUrl(newUrl);
        message.getSubCreditsMsg().setAuthParams(body);
        return this.getHttpPost(message.getHttpUrl(), JSON.toJSONString(body));
    }

    public String parseCreditsResponse(String body, Boolean addCredits, Map<String, String> authParams) {
        log.info("\u76f8\u5b9c\u672c\u8349\u52a0\u51cf\u79ef\u5206response, add={}, body={}", (Object)addCredits, (Object)body);
        JSONObject jsonBody = JSON.parseObject((String)body);
        JSONObject result = new JSONObject();
        if (Objects.equals(0, jsonBody.getInteger("errcode"))) {
            result.put("status", (Object)"ok");
            result.put("bizId", (Object)(System.currentTimeMillis() + RandomStringUtils.randomNumeric((int)6)));
            result.put("credits", (Object)jsonBody.getJSONObject("result").getLongValue("totalPoint"));
        } else {
            this.dealTokenExpire(jsonBody);
            result.put("status", (Object)"fail");
            result.put("errorMessage", (Object)jsonBody.getString("errmsg"));
        }
        return result.toString();
    }

    private void dealTokenExpire(JSONObject jsonBody) {
        try {
            String errmsg = Optional.ofNullable(jsonBody.getString("errorMessage")).orElse(jsonBody.getString("errmsg"));
            if (StringUtils.isNotBlank((CharSequence)errmsg) && errmsg.contains("access_token\u65e0\u6548")) {
                this.redisTemplate.delete((Object)this.getTokenKey());
                log.info("\u76f8\u5b9c\u672c\u8349\u83b7\u53d6token,\u5220\u9664\u8fc7\u671ftoken\u6210\u529f");
            }
        }
        catch (Exception e) {
            log.warn("\u76f8\u5b9c\u672c\u8349\u83b7\u53d6token,\u5220\u9664\u8fc7\u671ftoken\u5931\u8d25", (Throwable)e);
        }
    }

    public HttpRequestBase getVirtualRequest(SupplierRequest request) {
        String url = request.getHttpUrl();
        String newUrl = url.substring(0, url.indexOf(63));
        String paramsStr = url.substring(url.indexOf(63) + 1);
        Map<String, String> authParams = AssembleTool.getUrlParams(paramsStr);
        String timestamp = String.valueOf(System.currentTimeMillis());
        String[] params = StringUtils.split((String)authParams.get("params"), (String)"|");
        HashMap body = Maps.newHashMap();
        body.put("code", "sendCouponsInfo");
        body.put("unionId", authParams.get("uid"));
        body.put("cardId", params[0]);
        body.put("money", params[1]);
        body.put("activityId", String.valueOf(System.currentTimeMillis() / 1000L));
        body.put("timestamp", timestamp);
        body.put("token", this.getToken(timestamp));
        request.setHttpUrl(newUrl);
        request.setAuthParams(body);
        log.info("\u76f8\u5b9c\u672c\u8349 \u865a\u62df\u5546\u54c1\u53d1\u8d27 url = {}, \u6570\u636e = {}", (Object)newUrl, (Object)JSON.toJSONString((Object)body));
        return this.getHttpPost(newUrl, JSON.toJSONString((Object)body));
    }

    public String getVirtualResponse(SupplierRequest message, String body) {
        log.info("\u76f8\u5b9c\u672c\u8349\u865a\u62df\u5546\u54c1\u5145\u503c\u54cd\u5e94\u7ed3\u679cresponse, body={}", (Object)body);
        JSONObject jsonBody = JSON.parseObject((String)body);
        JSONObject result = new JSONObject();
        if (!Objects.equals(1, jsonBody.getInteger("status"))) {
            result.put("status", (Object)"fail");
            result.put("errorMessage", ObjectUtils.firstNonNull((Object[])new String[]{jsonBody.getString("refusereason"), jsonBody.getString("msg")}));
            return result.toString();
        }
        result.put("status", (Object)"success");
        return result.toString();
    }

    private HttpRequestBase getHttpPost(String httpUrl, String jsonBody) {
        HttpPost request = new HttpPost(httpUrl);
        request.setEntity((HttpEntity)new StringEntity(jsonBody, ContentType.APPLICATION_JSON));
        return request;
    }

    private Map<String, String> getCreditsHttpBody(Map<String, String> authParams, boolean isAdd) {
        HashMap map = Maps.newHashMap();
        map.put("unionid", authParams.get("uid"));
        if (isAdd) {
            map.put("changePoint", authParams.get("credits"));
        } else {
            map.put("changePoint", "-" + authParams.get("credits"));
        }
        map.put("changeRemark", authParams.get("description"));
        map.put("changeId", authParams.get("orderNum"));
        return map;
    }

    public String getAccessToken() {
        String redisKey = this.getTokenKey();
        if (this.inoherbConstant.getOldToken().booleanValue()) {
            this.redisTemplate.delete((Object)redisKey);
            return this.getOldAccessToken();
        }
        String token = (String)this.redisTemplate.opsForValue().get((Object)redisKey);
        if (StringUtils.isNotBlank((CharSequence)token)) {
            return token;
        }
        String redisLockKey = RedisKeyEnum.K003.toString() + DateUtil.today();
        while (!this.redisTemplate.opsForValue().setIfAbsent((Object)redisLockKey, (Object)"").booleanValue()) {
            try {
                Thread.sleep(1000L);
                token = (String)this.redisTemplate.opsForValue().get((Object)redisKey);
                if (!StringUtils.isNotBlank((CharSequence)token)) continue;
                return token;
            }
            catch (InterruptedException e) {
                log.error("\u76f8\u5b9c\u672c\u8349\u52a0\u9501\u5931\u8d25", (Throwable)e);
            }
        }
        token = (String)this.redisTemplate.opsForValue().get((Object)redisKey);
        if (StringUtils.isNotBlank((CharSequence)token)) {
            return token;
        }
        this.redisTemplate.expire((Object)redisLockKey, 10L, TimeUnit.SECONDS);
        return this.HttpGetToken(redisKey, redisLockKey);
    }

    @NotNull
    private String getTokenKey() {
        return RedisKeyEnum.K002.toString() + DateUtil.today();
    }

    /*
     * Exception decompiling
     */
    private String HttpGetToken(String redisKey, String redisLockKey) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getOldAccessToken() {
        URI uri = UriComponentsBuilder.fromHttpUrl((String)(this.inoherbConstant.getDeveloperApiDomain() + "/api/token")).queryParam("appid", new Object[]{this.inoherbConstant.getDeveloperAppId()}).queryParam("secret", new Object[]{this.inoherbConstant.getDeveloperAppSecret()}).build().toUri();
        HttpGet request = new HttpGet(uri);
        String response = null;
        log.info("\u76f8\u5b9c\u672c\u8349\u83b7\u53d6token,\u5f00\u59cb");
        HttpUtils.resetTimeOut((HttpRequestBase)request);
        try (CloseableHttpResponse resp = this.httpClient.execute((HttpUriRequest)request);){
            response = EntityUtils.toString((HttpEntity)resp.getEntity());
            JSONObject jsonResult = JSON.parseObject((String)response);
            if (!Objects.equals(0, jsonResult.getInteger("errcode"))) {
                log.error("\u76f8\u5b9c\u672c\u8349\u83b7\u53d6token\u5931\u8d25, response={}, request={}", (Object)response, (Object)request);
                throw new ThirdpatyException("\u76f8\u5b9c\u672c\u8349\u83b7\u53d6token\u5931\u8d25");
            }
            String token = jsonResult.getJSONObject("result").getString("token");
            log.info("\u76f8\u5b9c\u672c\u8349\u83b7\u53d6token,\u6210\u529f");
            String string = token;
            return string;
        }
        catch (ThirdpatyException e) {
            throw e;
        }
        catch (Exception e) {
            log.error("\u76f8\u5b9c\u672c\u8349\u83b7\u53d6token\u5931\u8d25, response={}, request={}", new Object[]{response, request, e});
            throw new ThirdpatyException("\u76f8\u5b9c\u672c\u8349\u83b7\u53d6token\u5931\u8d25");
        }
    }

    public String getToken(String timestamp) {
        return DigestUtils.md5Hex((String)(this.inoherbConstant.getDeveloperThirdPartySecret() + timestamp)).toUpperCase();
    }
}

