/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.biz.credits.strategy.Impl;

import cn.com.duiba.biz.credits.strategy.ApiStrategy;
import cn.com.duiba.domain.SubCreditsMsgWrapper;
import cn.com.duiba.thirdparty.dto.CreditsMessageDto;
import cn.com.duiba.tool.AssembleTool;
import cn.com.duiba.tool.zhiji.ZhiJiParamTool;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.StringEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZhiJiApiStrategy
implements ApiStrategy {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZhiJiApiStrategy.class);
    private final RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(5000).setSocketTimeout(10000).setConnectionRequestTimeout(500).build();
    private static final int FIVE_SECONDS = 5000;
    private static final int TEN_SECONDS = 10000;

    @Override
    public HttpRequestBase getMqSubCreditsHttpRequest(SubCreditsMsgWrapper message) {
        String url = ZhiJiApiStrategy.getHostName(message.getHttpUrl());
        HttpPost httpPost = new HttpPost(url);
        Map<String, String> originData = AssembleTool.getUrlParams(ZhiJiApiStrategy.getParamUrl(message.getHttpUrl()));
        LOGGER.info("\u667a\u5df1-\u6263\u79ef\u5206\u53c2\u6570\uff0cparams\uff1a{}", (Object)JSON.toJSONString(originData));
        HashMap requestParams = Maps.newHashMap();
        requestParams.put("TransactionType", originData.get("description"));
        requestParams.put("RedeemNumber", originData.get("orderNum"));
        requestParams.put("TraceId", originData.get("orderNum") + ZhiJiParamTool.generateRandom());
        Map customParams = message.getSubCreditsMsg().getParams();
        requestParams.put("superId", customParams.get("superId"));
        requestParams.put("RedeemTime", customParams.get("TransactionTime"));
        requestParams.put("SourceCode", "DUIBA");
        HashMap data = new HashMap(1);
        HashMap lostOfPointList = new HashMap(1);
        HashMap<String, String> pointList = new HashMap<String, String>(2);
        pointList.put("Type", "Point");
        pointList.put("RedeemPoints", originData.get("credits"));
        lostOfPointList.put("PointList", pointList);
        data.put("ListOfPointList", lostOfPointList);
        requestParams.put("Data", data);
        try {
            httpPost.setEntity((HttpEntity)new StringEntity(JSON.toJSONString((Object)requestParams)));
            httpPost.setConfig(this.requestConfig);
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.warn("\u667a\u5df1-\u6263\u79ef\u5206\u8bf7\u6c42\u751f\u6210\u5931\u8d25\uff0cparams\uff1a{}", (Object)message);
        }
        return httpPost;
    }

    @Override
    public String parseCreditsRsp(String body, Boolean addCredits, Map<String, String> authParams) {
        JSONObject response = JSON.parseObject((String)body);
        LOGGER.info("\u667a\u5df1-\u79ef\u5206\u8fd4\u56de\u53c2\u6570\uff0cparams\uff1a{}", (Object)body);
        JSONObject result = new JSONObject();
        result.put("bizId", response.get((Object)"TxnId"));
        if (Objects.equals("0", response.get((Object)"ErrorCode"))) {
            result.put("status", (Object)"ok");
        } else {
            result.put("status", (Object)"fail");
        }
        result.put("errorMessage", response.get((Object)"ErrorMessage"));
        return result.toJSONString();
    }

    @Override
    public HttpRequestBase getAddCreditsMessageRequest(CreditsMessageDto message) {
        String url = ZhiJiApiStrategy.getHostName(message.getHttpUrl());
        HttpPost httpPost = new HttpPost(url);
        Map<String, String> originData = AssembleTool.getUrlParams(ZhiJiApiStrategy.getParamUrl(message.getHttpUrl()));
        LOGGER.info("\u667a\u5df1-\u6263\u79ef\u5206\u53c2\u6570\uff0cparams\uff1a{}", (Object)JSON.toJSONString(originData));
        HashMap requestParams = Maps.newHashMap();
        requestParams.put("AccrualPoints", originData.get("credits"));
        requestParams.put("TransactionType", originData.get("description"));
        requestParams.put("TransactionNumber", originData.get("orderNum"));
        requestParams.put("TraceId", originData.get("orderNum") + "6\u4f4d\u968f\u673a\u6570");
        Map customParams = message.getParams();
        requestParams.put("superId", customParams.get("superId"));
        requestParams.put("Type", "Point");
        requestParams.put("SourceCode", "DUIBA");
        requestParams.put("RedeemTime", "\u5151\u6362\u65f6\u95f4(MM/DD/YYYY HH24:MI:SS)");
        try {
            httpPost.setEntity((HttpEntity)new StringEntity(JSON.toJSONString((Object)requestParams)));
            httpPost.setConfig(this.requestConfig);
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.warn("\u667a\u5df1-\u6263\u79ef\u5206\u8bf7\u6c42\u751f\u6210\u5931\u8d25\uff0cparams\uff1a{}", (Object)message);
        }
        return httpPost;
    }

    public static String getHostName(String url) {
        return url.substring(0, url.indexOf(63));
    }

    public static String getParamUrl(String url) {
        return url.substring(url.indexOf(63) + 1);
    }
}

