/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.dao.custom.impl;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.constant.DatabaseSchema;
import cn.com.duiba.dao.BaseDAO;
import cn.com.duiba.dao.custom.ZHCreditsLogDAO;
import cn.com.duiba.domain.ZHCreditsLogDO;
import cn.com.duiba.enums.redis.RedisKeyEnum;
import cn.com.duiba.enums.zhcreditslog.LogStatusEnum;
import cn.com.duiba.enums.zhcreditslog.LogTypeEnum;
import cn.com.duiba.wolf.redis.RedisAtomicClient;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ZHCreditsLogDAOImpl
extends BaseDAO
implements ZHCreditsLogDAO {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZHCreditsLogDAOImpl.class);
    @Resource(name="stringRedisTemplate")
    private RedisAtomicClient redisCounter;

    @Override
    protected DatabaseSchema chooseSchema() {
        return DatabaseSchema.DUIBA_CUSTOM;
    }

    @Override
    public ZHCreditsLogDO findByRequestSn(String requestSn) {
        return (ZHCreditsLogDO)this.selectOne("findByRequestSn", requestSn);
    }

    @Override
    public Long insert(ZHCreditsLogDO entity) {
        this.insert("insert", entity);
        return entity.getId();
    }

    @Override
    public ZHCreditsLogDO findByOrderNumAndLogType(String orderNum, LogTypeEnum logType) {
        HashMap params = Maps.newHashMap();
        params.put("orderNum", orderNum);
        params.put("logType", logType);
        return (ZHCreditsLogDO)this.selectOne("findByOrderNumAndLogType", params);
    }

    @Override
    public boolean updateLogStatus(Long id, LogStatusEnum update, LogStatusEnum expect) {
        if (id == null || update == null || expect == null) {
            return false;
        }
        HashMap params = Maps.newHashMap();
        params.put("id", id);
        params.put("update", update.getCode());
        params.put("expect", expect.getCode());
        return this.update("updateLogStatus", params) == 1;
    }

    @Override
    public boolean updateResponseInfo(Long id, String responseInfo) {
        if (id == null || StringUtils.isBlank((CharSequence)responseInfo)) {
            return false;
        }
        HashMap params = Maps.newHashMap();
        params.put("id", id);
        if (responseInfo.length() > 255) {
            responseInfo = responseInfo.substring(0, 255);
        }
        params.put("responseInfo", responseInfo);
        return this.update("updateResponseInfo", params) == 1;
    }

    @Override
    public String generateNewRequestSn(String partnerCode) throws BizException {
        long sec = System.currentTimeMillis() / 60000L;
        String counterKey = RedisKeyEnum.K001.toString() + sec;
        long offset = this.redisCounter.incrBy(counterKey, 1L, 5L, TimeUnit.MINUTES);
        if (offset > 999999L) {
            LOGGER.warn("\u4e2d\u5b8f\u79ef\u5206\u63a5\u53e3\u5bf9\u63a5\uff0c\u5f53\u524d\u5df2\u8fbe\u5230\u4e1a\u52a1\u4e0a\u9650\uff0c\u4e2d\u65ad\u6d41\u7a0b");
            throw new BizException("\u4e2d\u5b8f\u79ef\u5206\u4e1a\u52a1\u5df2\u8fbe\u4e0a\u9650");
        }
        String requestSn = partnerCode + sec * 1000000L + offset + "";
        return UUID.nameUUIDFromBytes(requestSn.getBytes()).toString();
    }
}

