/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.remoteimpl.tailong;

import cn.com.duiba.constant.TailongBankConfig;
import cn.com.duiba.service.HttpAsyncClientPool;
import cn.com.duiba.thirdparty.api.tailong.RemoteTaiLongService;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.zjtlcb.fcloud.utils.MD5Util;
import com.zjtlcb.fcloud.utils.SM2Util;
import com.zjtlcb.fcloud.utils.SM3Util;
import com.zjtlcb.fcloud.utils.SM4Util;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class RemoteTaiLongServiceImpl
implements RemoteTaiLongService {
    private static final Logger log = LoggerFactory.getLogger(RemoteTaiLongServiceImpl.class);
    @Resource(name="redisTemplate")
    private RedisTemplate<String, String> redisTemplate;
    @Autowired
    private TailongBankConfig tailongBankConfig;
    @Autowired
    HttpAsyncClientPool httpAsyncClientPool;

    public String getCustomVirtualResult(Map<String, String> paramMap, Map<String, String> headerMap, String serviceId) {
        HttpRequestBase httpRequestBase = this.getHttpRequestBase(paramMap, headerMap, serviceId);
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        try {
            HttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpRequestBase);
            String result = EntityUtils.toString((HttpEntity)httpResponse.getEntity());
            return this.getResponseNotify(result);
        }
        catch (Exception e) {
            log.error("\u6cf0\u9686\u94f6\u884c\u8c03\u7528mmsTaskGrant\u4ea4\u6613\u7801\u5f02\u5e38", (Throwable)e);
            return null;
        }
    }

    private HttpRequestBase getHttpRequestBase(Map<String, String> paramMap, Map<String, String> headMap, String serviceId) {
        JSONObject reqMsg = new JSONObject();
        HashMap<String, Map<String, String>> map = new HashMap<String, Map<String, String>>();
        map.put("head", headMap);
        map.put("body", paramMap);
        reqMsg.put("reqData", JSON.toJSON(map));
        reqMsg.put("appID", (Object)this.tailongBankConfig.getMechAppID());
        reqMsg.put("seqNO", (Object)new SimpleDateFormat("yyyyMMddHHmmsss").format(new Date()));
        reqMsg.put("signMethod", (Object)"SM3");
        reqMsg.put("encryptMethod", (Object)"SM4");
        reqMsg.put("appAccessToken", (Object)this.getTLToken());
        log.info("\u6cf0\u9686\u94f6\u884c\u8c03\u7528\u670d\u52a1\uff1a" + this.tailongBankConfig.getTlHttpUrl() + serviceId + "   \u539f\u8bf7\u6c42\u62a5\u6587\uff1a" + reqMsg.toJSONString());
        String randomKey = MD5Util.md5_((String)UUID.randomUUID().toString());
        HttpPost httpPost = null;
        try {
            reqMsg.put("sm2EncryptData", (Object)SM2Util.encryptByPublicKey((String)randomKey, (String)this.tailongBankConfig.getTlPublicKey()));
            reqMsg.put("sm2Sign", (Object)SM2Util.signByPrivateKey((String)randomKey, (String)this.tailongBankConfig.getSm2PrivateKey(), (String)this.tailongBankConfig.getMechAppID()));
            reqMsg.put("sign", (Object)SM3Util.sign((String)(reqMsg.getString("reqData") + reqMsg.getString("seqNO") + this.tailongBankConfig.getAppSecretKey() + randomKey)));
            reqMsg.put("reqData", (Object)SM4Util.encrypt((String)reqMsg.getString("reqData"), (String)(reqMsg.getString("seqNO") + reqMsg.getString("appAccessToken") + this.tailongBankConfig.getAppSecretKey() + randomKey)));
            httpPost = new HttpPost(this.tailongBankConfig.getTlHttpUrl() + serviceId);
            ByteArrayEntity bae = new ByteArrayEntity(reqMsg.toJSONString().getBytes());
            httpPost.setEntity((HttpEntity)bae);
            httpPost.addHeader("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8");
        }
        catch (Exception e) {
            log.warn("\u6cf0\u9686\u94f6\u884c getHttpRequestBase", (Throwable)e);
        }
        return httpPost;
    }

    private String getTLToken() {
        String appAccessToken = (String)this.redisTemplate.opsForValue().get((Object)this.tailongBankConfig.getAccessTokenRedisKey());
        if (StringUtils.isNotBlank((CharSequence)appAccessToken)) {
            return appAccessToken;
        }
        try {
            JSONObject reqMsg = new JSONObject();
            String seqNO = new SimpleDateFormat("yyyyMMddHHmmsss").format(new Date());
            reqMsg.put("appID", (Object)this.tailongBankConfig.getMechAppID());
            reqMsg.put("seqNO", (Object)seqNO);
            reqMsg.put("random", (Object)MD5Util.md5_((String)seqNO));
            String randomKey = MD5Util.md5_((String)UUID.randomUUID().toString());
            reqMsg.put("sm2EncryptData", (Object)SM2Util.encryptByPublicKey((String)randomKey, (String)this.tailongBankConfig.getTlPublicKey()));
            reqMsg.put("sm2Sign", (Object)SM2Util.signByPrivateKey((String)randomKey, (String)this.tailongBankConfig.getSm2PrivateKey(), (String)this.tailongBankConfig.getMechAppID()));
            reqMsg.put("sign", (Object)SM3Util.sign((String)(reqMsg.getString("random") + reqMsg.getString("seqNO") + this.tailongBankConfig.getAppSecretKey() + randomKey)));
            log.info("\u6cf0\u9686\u94f6\u884c\u8c03\u7528\u670d\u52a1\uff1aapproveDev,TL\u8bf7\u6c42\u62a5\u6587\uff1a" + reqMsg.toJSONString());
            String rspMsg = this.doPost(reqMsg.toJSONString(), this.tailongBankConfig.getTlHttpUrl() + "approveDev");
            log.info("\u6cf0\u9686\u94f6\u884c\u54cd\u5e94\u62a5\u6587\uff1a" + rspMsg);
            JSONObject rspJsonObj = JSON.parseObject((String)rspMsg);
            String token = "";
            if (!"000000".equals(rspJsonObj.getString("errorCode"))) {
                log.info("\u6cf0\u9686\u94f6\u884c\u4ea4\u6613\u5f02\u5e38");
                return null;
            }
            token = SM2Util.decryptByPrivateKey((String)rspJsonObj.getString("sm2EncryptData"), (String)this.tailongBankConfig.getSm2PrivateKey());
            if (!SM2Util.verifyByPublicKey((String)rspJsonObj.getString("sm2Sign"), (String)this.tailongBankConfig.getTlPublicKey(), (String)this.tailongBankConfig.getMechAppID(), (String)token)) {
                log.info("\u6cf0\u9686\u94f6\u884c\u8eab\u4efd\u8ba4\u8bc1-SM2\u9a8c\u7b7e\u5931\u8d25");
                return null;
            }
            if (!SM3Util.verify((String)(rspJsonObj.getString("random") + rspJsonObj.getString("seqNO") + token + this.tailongBankConfig.getAppSecretKey()), (String)rspJsonObj.getString("sign"))) {
                log.info("\u6cf0\u9686\u94f6\u884c\u9a8c\u7b7e\u5931\u8d25\uff0c\u62a5\u6587\u4e00\u81f4\u6027\u6821\u9a8c\u5931\u8d25");
                return null;
            }
            log.info("\u6cf0\u9686\u94f6\u884c\u83b7\u5f97Token\u4e3a\uff1a" + token);
            this.redisTemplate.opsForValue().set((Object)this.tailongBankConfig.getAccessTokenRedisKey(), (Object)token, this.tailongBankConfig.getINTERVALTIME().longValue(), TimeUnit.SECONDS);
            return token;
        }
        catch (Exception var6) {
            var6.printStackTrace();
            log.error("\u6cf0\u9686\u94f6\u884c\u8c03\u7528\u83b7\u53d6token\u63a5\u53e3\u5f02\u5e38");
            return null;
        }
    }

    private String doPost(String msg2, String url) throws IOException {
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        HttpPost httpPost = new HttpPost(url);
        ByteArrayEntity bae = new ByteArrayEntity(msg2.getBytes());
        httpPost.setEntity((HttpEntity)bae);
        httpPost.addHeader("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8");
        HttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
        HttpEntity entity = response.getEntity();
        if (entity != null) {
            byte[] bytes = EntityUtils.toByteArray((HttpEntity)entity);
            return new String(bytes, "UTF-8");
        }
        return null;
    }

    public String getResponseNotify(String body) {
        JSONObject rspJsonObj = JSON.parseObject((String)body);
        try {
            if (rspJsonObj.containsKey((Object)"rspData")) {
                String sm2Key = SM2Util.decryptByPrivateKey((String)rspJsonObj.getString("sm2EncryptData"), (String)this.tailongBankConfig.getSm2PrivateKey());
                rspJsonObj.put("sm2EncryptData", (Object)sm2Key);
                if (!SM2Util.verifyByPublicKey((String)rspJsonObj.getString("sm2Sign"), (String)this.tailongBankConfig.getTlPublicKey(), (String)this.tailongBankConfig.getMechAppID(), (String)sm2Key)) {
                    log.info("\u8eab\u4efd\u8ba4\u8bc1-SM2\u9a8c\u7b7e\u5931\u8d25");
                    return null;
                }
                String rspData = SM4Util.decrypt((String)rspJsonObj.getString("rspData"), (String)(rspJsonObj.getString("seqNO") + this.getTLToken() + this.tailongBankConfig.getAppSecretKey() + sm2Key));
                log.info("\u6cf0\u9686\u94f6\u884c\u89e3\u5bc6\u540e\u62a5\u6587\uff1a" + rspData);
                return rspData;
            }
        }
        catch (Exception e) {
            log.warn("\u6cf0\u9686\u94f6\u884c  getResponseNotify  body = {}", (Object)body, (Object)e);
        }
        return null;
    }
}

