/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.remoteimpl.zhiji;

import cn.com.duiba.enums.zhiji.ZhiJiCodeEnum;
import cn.com.duiba.enums.zhiji.ZhiJiStatusEnum;
import cn.com.duiba.thirdparty.api.zhiji.RemoteZhiJiService;
import cn.com.duiba.thirdparty.dto.zhiji.ZhiJiUserReceivedAddressDto;
import cn.com.duiba.thirdparty.dto.zhiji.request.ZhiJiBlindBoxRequest;
import cn.com.duiba.thirdparty.dto.zhiji.request.ZhiJiOrderInfoDto;
import cn.com.duiba.thirdparty.dto.zhiji.response.ZhiJiBlindBoxResponse;
import cn.com.duiba.thirdparty.dto.zhiji.response.ZhiJiDistrictResponse;
import cn.com.duiba.thirdparty.dto.zhiji.response.ZhiJiOrderResponse;
import cn.com.duiba.thirdparty.dto.zhiji.response.ZhiJiResponse;
import cn.com.duiba.tool.zhiji.ZhiJiParamTool;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Joiner;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.lang3.RandomUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class RemoteZhiJiServiceImpl
implements RemoteZhiJiService {
    private static final Logger log = LoggerFactory.getLogger(RemoteZhiJiServiceImpl.class);
    @Resource(name="httpClient")
    private CloseableHttpClient httpClient;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String saveReceiveAddress(ZhiJiUserReceivedAddressDto dto) {
        HttpPost httpPost = ZhiJiParamTool.createHttpPost(dto, "");
        httpPost.setHeader("x-transaction-id", System.currentTimeMillis() + ZhiJiParamTool.generateRandom());
        try (CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)httpPost);){
            String responseStr = EntityUtils.toString((HttpEntity)response.getEntity());
            log.info("\u667a\u5df1-\u65b0\u589e\u6536\u83b7\u5730\u5740\u4fe1\u606f\uff0c\u667a\u5df1\u54cd\u5e94\u53c2\u6570\uff0cparam:{}", (Object)responseStr);
            ZhiJiResponse respParam = (ZhiJiResponse)JSONObject.parseObject((String)responseStr, ZhiJiResponse.class);
            if (!ZhiJiCodeEnum.SUCCESS_1.getCode().equals(respParam.getCode())) {
                log.warn("\u667a\u5df1-\u65b0\u589e\u6536\u83b7\u5730\u5740\u4fe1\u606f\uff0c\u667a\u5df1\u54cd\u5e94\u5931\u8d25\uff0cparam:{}", (Object)responseStr);
                String string2 = ZhiJiStatusEnum.FAIL.getCode();
                return string2;
            }
            String string = respParam.getTransactionId();
            return string;
        }
        catch (Exception e) {
            log.warn("\u667a\u5df1-\u65b0\u589e\u6536\u83b7\u5730\u5740\u4fe1\u606f\uff0c\u667a\u5df1\u54cd\u5e94\u5f02\u5e38\uff0cparam:{}", (Object)dto, (Object)e);
            return ZhiJiStatusEnum.FAIL.getCode();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Boolean removeReceiveAddress(ZhiJiUserReceivedAddressDto dto) {
        HttpPost httpPost = ZhiJiParamTool.createHttpPost(dto, "");
        httpPost.setHeader("x-transaction-id", System.currentTimeMillis() + ZhiJiParamTool.generateRandom());
        try (CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)httpPost);){
            String responseStr = EntityUtils.toString((HttpEntity)response.getEntity());
            log.info("\u667a\u5df1-\u5220\u9664\u6536\u83b7\u5730\u5740\u4fe1\u606f\uff0c\u667a\u5df1\u54cd\u5e94\u53c2\u6570\uff0cparam:{}", (Object)responseStr);
            ZhiJiResponse zhiJiResponse = (ZhiJiResponse)JSONObject.parseObject((String)responseStr, ZhiJiResponse.class);
            if (!ZhiJiCodeEnum.SUCCESS_1.getCode().equals(zhiJiResponse.getCode())) {
                log.warn("\u667a\u5df1-\u5220\u9664\u6536\u83b7\u5730\u5740\u4fe1\u606f\uff0c\u667a\u5df1\u54cd\u5e94\u5931\u8d25\uff0cparam:{}", (Object)responseStr);
                Boolean bl2 = false;
                return bl2;
            }
            Boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            log.warn("\u667a\u5df1-\u5220\u9664\u6536\u83b7\u5730\u5740\u4fe1\u606f\uff0c\u667a\u5df1\u54cd\u5e94\u5f02\u5e38\uff0cparam:{}", (Object)dto, (Object)e);
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Boolean updateReceiveAddress(ZhiJiUserReceivedAddressDto dto) {
        HttpPost httpPost = ZhiJiParamTool.createHttpPost(dto, "");
        httpPost.setHeader("x-transaction-id", System.currentTimeMillis() + ZhiJiParamTool.generateRandom());
        try (CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)httpPost);){
            String responseStr = EntityUtils.toString((HttpEntity)response.getEntity());
            log.info("\u667a\u5df1-\u7f16\u8f91\u6536\u83b7\u5730\u5740\u4fe1\u606f\uff0c\u667a\u5df1\u54cd\u5e94\u53c2\u6570\uff0cparam:{}", (Object)responseStr);
            ZhiJiResponse zhiJiResponse = (ZhiJiResponse)JSONObject.parseObject((String)responseStr, ZhiJiResponse.class);
            if (!ZhiJiCodeEnum.SUCCESS_1.getCode().equals(zhiJiResponse.getCode())) {
                log.warn("\u667a\u5df1-\u7f16\u8f91\u6536\u8d27\u5730\u5740\u4fe1\u606f\uff0c\u667a\u5df1\u54cd\u5e94\u5931\u8d25\uff0cparam:{}", (Object)responseStr);
                Boolean bl2 = false;
                return bl2;
            }
            Boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            log.warn("\u667a\u5df1-\u7f16\u8f91\u6536\u8d27\u5730\u5740\u4fe1\u606f\uff0c\u667a\u5df1\u54cd\u5e94\u5f02\u5e38\uff0cparam:{}", (Object)dto, (Object)e);
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<ZhiJiUserReceivedAddressDto> selectReceiveAddress(String uid) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("uid", uid);
        HttpGet httpGet = ZhiJiParamTool.createHttpGet(params, "");
        httpGet.setHeader("x-transaction-id", System.currentTimeMillis() + ZhiJiParamTool.generateRandom());
        try (CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)httpGet);){
            List dtoList;
            String responseStr = EntityUtils.toString((HttpEntity)response.getEntity());
            log.info("\u667a\u5df1-\u67e5\u8be2\u6536\u83b7\u5730\u5740\u4fe1\u606f\uff0c\u667a\u5df1\u54cd\u5e94\u53c2\u6570\uff0cparam:{}", (Object)responseStr);
            ZhiJiResponse zhiJiResponse = (ZhiJiResponse)JSONObject.parseObject((String)responseStr, ZhiJiResponse.class);
            if (!ZhiJiCodeEnum.SUCCESS_1.getCode().equals(zhiJiResponse.getCode())) {
                log.warn("\u667a\u5df1-\u67e5\u8be2\u6536\u8d27\u5730\u5740\u4fe1\u606f\uff0c\u667a\u5df1\u54cd\u5e94\u5931\u8d25\uff0cparam:{}", (Object)responseStr);
                List<ZhiJiUserReceivedAddressDto> list2 = Collections.emptyList();
                return list2;
            }
            JSONObject addressData = JSON.parseObject((String)JSON.toJSONString((Object)zhiJiResponse.getData()));
            List list = dtoList = JSONObject.parseArray((String)addressData.getString("blocks"), ZhiJiUserReceivedAddressDto.class);
            return list;
        }
        catch (Exception e) {
            log.warn("\u667a\u5df1-\u67e5\u8be2\u6536\u8d27\u5730\u5740\u4fe1\u606f\uff0c\u667a\u5df1\u54cd\u5e94\u5f02\u5e38\uff0cparam:{}", (Object)uid, (Object)e);
            return Collections.emptyList();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ZhiJiOrderResponse syncOrderInfo(ZhiJiOrderInfoDto orderInfoDto) {
        HttpPost httpPost = ZhiJiParamTool.createHttpPost(orderInfoDto, "");
        try (CloseableHttpResponse response = this.retryRequest((HttpUriRequest)httpPost);){
            String responseStr = EntityUtils.toString((HttpEntity)response.getEntity());
            log.info("\u667a\u5df1-\u540c\u6b65\u8ba2\u5355\u4fe1\u606f\u4fe1\u606f\uff0c\u667a\u5df1\u54cd\u5e94\u53c2\u6570\uff0cparam:{}", (Object)responseStr);
            ZhiJiOrderResponse zhiJiResponse = (ZhiJiOrderResponse)JSONObject.parseObject((String)responseStr, ZhiJiOrderResponse.class);
            if (ZhiJiStatusEnum.FAIL.getCode().equals(zhiJiResponse.getStatus()) || !ZhiJiCodeEnum.SUCCESS.getCode().equals(zhiJiResponse.getCode())) {
                log.warn("\u667a\u5df1-\u540c\u6b65\u8ba2\u5355\u4fe1\u606f\uff0c\u667a\u5df1\u54cd\u5e94\u5931\u8d25\uff0cparam:{}", (Object)responseStr);
                ZhiJiOrderResponse zhiJiOrderResponse2 = zhiJiResponse;
                return zhiJiOrderResponse2;
            }
            ZhiJiOrderResponse zhiJiOrderResponse = zhiJiResponse;
            return zhiJiOrderResponse;
        }
        catch (Exception e) {
            log.warn("\u667a\u5df1-\u540c\u6b65\u8ba2\u5355\u4fe1\u606f\uff0c\u667a\u5df1\u54cd\u5e94\u5f02\u5e38\uff0cparam:{}", (Object)orderInfoDto, (Object)e);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ZhiJiOrderResponse syncOrderStatus(String orderNum, String status) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("sourceCode", "DUIBA");
        map.put("traceId", orderNum + RandomUtils.nextInt((int)100000, (int)999999));
        map.put("timestamp", System.currentTimeMillis());
        map.put("orderStatus", status);
        map.put("orderNum", orderNum);
        HttpPost httpPost = ZhiJiParamTool.createHttpPost(map, "");
        try (CloseableHttpResponse response = this.retryRequest((HttpUriRequest)httpPost);){
            String responseStr = EntityUtils.toString((HttpEntity)response.getEntity());
            log.info("\u667a\u5df1-\u540c\u6b65\u8ba2\u5355\u4fe1\u606f\u4fe1\u606f\uff0c\u667a\u5df1\u54cd\u5e94\u53c2\u6570\uff0cparam:{}", (Object)responseStr);
            ZhiJiOrderResponse zhiJiResponse = (ZhiJiOrderResponse)JSONObject.parseObject((String)responseStr, ZhiJiOrderResponse.class);
            if (ZhiJiStatusEnum.FAIL.getCode().equals(zhiJiResponse.getStatus()) || !ZhiJiCodeEnum.SUCCESS.getCode().equals(zhiJiResponse.getCode())) {
                log.warn("\u667a\u5df1-\u540c\u6b65\u8ba2\u5355\u4fe1\u606f\uff0c\u667a\u5df1\u54cd\u5e94\u5931\u8d25\uff0cparam:{}", (Object)responseStr);
                ZhiJiOrderResponse zhiJiOrderResponse2 = null;
                return zhiJiOrderResponse2;
            }
            ZhiJiOrderResponse zhiJiOrderResponse = zhiJiResponse;
            return zhiJiOrderResponse;
        }
        catch (Exception e) {
            log.warn("\u667a\u5df1-\u540c\u6b65\u8ba2\u5355\u4fe1\u606f\uff0c\u667a\u5df1\u54cd\u5e94\u5f02\u5e38\uff0corderNum:{}, status:{}", new Object[]{orderNum, status, e});
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public JSONObject getUserCredits(String superiId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("superiId", superiId);
        params.put("sourceCode", "DUIBA");
        params.put("traceId", System.currentTimeMillis() + "" + RandomUtils.nextInt((int)100000, (int)999999));
        HttpPost httpPost = ZhiJiParamTool.createHttpRequest(params, "");
        try (CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)httpPost);){
            String responseStr = EntityUtils.toString((HttpEntity)response.getEntity());
            log.info("\u667a\u5df1-\u67e5\u8be2\u7528\u6237\u79ef\u5206\uff0c\u667a\u5df1\u54cd\u5e94\u53c2\u6570\uff0cparam:{}", (Object)responseStr);
            ZhiJiResponse zhiJiResponse = (ZhiJiResponse)JSONObject.parseObject((String)responseStr, ZhiJiResponse.class);
            if (!ZhiJiCodeEnum.SUCCESS_1.getCode().equals(zhiJiResponse.getCode())) {
                log.warn("\u667a\u5df1-\u67e5\u8be2\u7528\u6237\u79ef\u5206\uff0c\u667a\u5df1\u54cd\u5e94\u5931\u8d25\uff0cparam:{}", (Object)responseStr);
                JSONObject jSONObject2 = null;
                return jSONObject2;
            }
            JSONObject jSONObject = JSONObject.parseObject((String)zhiJiResponse.getData().toString());
            return jSONObject;
        }
        catch (Exception e) {
            log.warn("\u667a\u5df1-\u67e5\u8be2\u7528\u6237\u79ef\u5206\uff0c\u667a\u5df1\u54cd\u5e94\u5f02\u5e38\uff0cparam:{}", (Object)superiId, (Object)e);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public JSONObject queryUserInfo(String token) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("accessToken", token);
        HttpPost httpPost = ZhiJiParamTool.createHttpRequest(params, "");
        httpPost.setHeader("x-transaction-id", System.currentTimeMillis() + ZhiJiParamTool.generateRandom());
        try (CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)httpPost);){
            String responseStr = EntityUtils.toString((HttpEntity)response.getEntity());
            log.info("\u667a\u5df1-\u67e5\u8be2\u7528\u6237id\u4fe1\u606f\uff0c\u667a\u5df1\u54cd\u5e94\u53c2\u6570\uff0cparam:{}", (Object)responseStr);
            ZhiJiResponse zhiJiResponse = (ZhiJiResponse)JSONObject.parseObject((String)responseStr, ZhiJiResponse.class);
            if (!ZhiJiCodeEnum.SUCCESS_1.getCode().equals(zhiJiResponse.getCode())) {
                log.warn("\u667a\u5df1-\u67e5\u8be2\u7528\u6237id\u4fe1\u606f\uff0c\u667a\u5df1\u54cd\u5e94\u5931\u8d25\uff0cparam:{}", (Object)responseStr);
                JSONObject jSONObject2 = null;
                return jSONObject2;
            }
            JSONObject jSONObject = JSONObject.parseObject((String)zhiJiResponse.getData().toString());
            return jSONObject;
        }
        catch (Exception e) {
            log.warn("\u667a\u5df1-\u67e5\u8be2\u7528\u6237id\u4fe1\u606f\uff0c\u667a\u5df1\u54cd\u5e94\u5f02\u5e38\uff0cparam:{}", (Object)token, (Object)e);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean syncGoods(Map<String, Object> params) {
        HttpPost httpPost = ZhiJiParamTool.createHttpRequest(params, "");
        try (CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)httpPost);){
            String responseStr = EntityUtils.toString((HttpEntity)response.getEntity());
            log.info("\u667a\u5df1-\u540c\u6b65\u5546\u54c1\u4fe1\u606f\uff0c\u667a\u5df1\u54cd\u5e94\u53c2\u6570\uff0cparam:{}", (Object)responseStr);
            ZhiJiResponse zhiJiResponse = (ZhiJiResponse)JSONObject.parseObject((String)responseStr, ZhiJiResponse.class);
            if (ZhiJiStatusEnum.FAIL.getCode().equals(zhiJiResponse.getStatus()) || !ZhiJiCodeEnum.SUCCESS.getCode().equals(zhiJiResponse.getCode())) {
                log.warn("\u667a\u5df1-\u540c\u6b65\u5546\u54c1\u4fe1\u606f\uff0c\u667a\u5df1\u54cd\u5e94\u5931\u8d25\uff0cparam:{}", (Object)responseStr);
                boolean bl2 = false;
                return bl2;
            }
            JSONObject jsonObject = JSONObject.parseObject((String)zhiJiResponse.getData().toString());
            boolean bl = Objects.equals(jsonObject.getString("code"), "0");
            return bl;
        }
        catch (Exception e) {
            log.warn("\u667a\u5df1-\u540c\u6b65\u5546\u54c1\u4fe1\u606f\uff0c\u667a\u5df1\u54cd\u5e94\u5f02\u5e38\uff0cparam:{}", (Object)JSON.toJSONString(params), (Object)e);
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<ZhiJiDistrictResponse> queryAddressList(String keywords, Integer subDistrict) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("keywords", keywords);
        params.put("subdistrict", String.valueOf(subDistrict));
        HttpGet httpGet = ZhiJiParamTool.createHttpGet(params, "");
        try (CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)httpGet);){
            String responseStr = EntityUtils.toString((HttpEntity)response.getEntity());
            ZhiJiResponse zhiJiResponse = (ZhiJiResponse)JSONObject.parseObject((String)responseStr, ZhiJiResponse.class);
            if (!ZhiJiCodeEnum.SUCCESS_1.getCode().equals(zhiJiResponse.getCode())) {
                log.warn("\u667a\u5df1-\u7701\u5e02\u533a\u67e5\u8be2\uff0c\u667a\u5df1\u54cd\u5e94\u5931\u8d25\uff0cparam:{}", (Object)responseStr);
                List<ZhiJiDistrictResponse> list2 = null;
                return list2;
            }
            JSONObject address = JSON.parseObject((String)JSON.toJSONString((Object)zhiJiResponse.getData()));
            List list = JSON.parseArray((String)JSON.toJSONString((Object)address.getString("blocks")), ZhiJiDistrictResponse.class);
            return list;
        }
        catch (Exception e) {
            log.warn("\u667a\u5df1-\u7701\u5e02\u533a\u67e5\u8be2\uff0c\u667a\u5df1\u54cd\u5e94\u5f02\u5e38\uff0cparam:{}", (Object)JSON.toJSONString(params), (Object)e);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Boolean blindBoxVerify(String uid, String blindBoxId, String goodsId) {
        HashMap<String, Object> params = new HashMap<String, Object>(3);
        params.put("userId", uid);
        params.put("blindBoxId", blindBoxId);
        params.put("goodsId", goodsId);
        HttpPost httpPost = ZhiJiParamTool.createHttpRequest(params, "");
        try (CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)httpPost);){
            String responseStr = EntityUtils.toString((HttpEntity)response.getEntity());
            log.info("\u667a\u5df1-\u76f2\u76d2\u9a8c\u8bc1\uff0c\u667a\u5df1\u54cd\u5e94\u53c2\u6570\uff0cparam:{}", (Object)responseStr);
            ZhiJiBlindBoxResponse zhiJiResponse = (ZhiJiBlindBoxResponse)JSONObject.parseObject((String)responseStr, ZhiJiBlindBoxResponse.class);
            if (zhiJiResponse == null) return false;
            if (zhiJiResponse.getData() == null) return false;
            if (!Objects.equals(1, zhiJiResponse.getData().getCheckStatus())) return false;
            Boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            log.warn("\u667a\u5df1-\u76f2\u76d2\u9a8c\u8bc1\uff0c\u667a\u5df1\u54cd\u5e94\u5f02\u5e38\uff0cparam:{}", (Object)JSON.toJSONString(params), (Object)e);
        }
        return false;
    }

    public void notifyBlindBoxWriteOff(ZhiJiBlindBoxRequest request) {
        HttpPost httpPost = ZhiJiParamTool.createHttpPost(request, "");
        try (CloseableHttpResponse response = this.retryRequest((HttpUriRequest)httpPost);){
            String responseStr = EntityUtils.toString((HttpEntity)response.getEntity());
            log.info("\u667a\u5df1-\u76f2\u76d2\u6838\u9500\u901a\u77e5\uff0c\u667a\u5df1\u54cd\u5e94\u53c2\u6570\uff0cparam:{}", (Object)responseStr);
        }
        catch (Exception e) {
            log.warn("\u667a\u5df1-\u76f2\u76d2\u6838\u9500\u901a\u77e5\uff0c\u667a\u5df1\u54cd\u5e94\u5f02\u5e38\uff0cparam:{}", (Object)request, (Object)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public JSONObject queryOrderAddress(List<String> orderIds) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("timestamp", System.currentTimeMillis());
        params.put("orderNumList", Joiner.on((String)",").join(orderIds));
        params.put("sourceCode", "DUIBA");
        params.put("traceId", System.currentTimeMillis() + "" + RandomUtils.nextInt((int)100000, (int)999999));
        HttpPost httpPost = ZhiJiParamTool.createHttpRequest(params, "");
        try (CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)httpPost);){
            String responseStr = EntityUtils.toString((HttpEntity)response.getEntity());
            log.info("\u667a\u5df1-\u540c\u6b65\u5546\u54c1\u4fe1\u606f\uff0c\u667a\u5df1\u54cd\u5e94\u53c2\u6570\uff0cparam:{}", (Object)responseStr);
            ZhiJiResponse zhiJiResponse = (ZhiJiResponse)JSONObject.parseObject((String)responseStr, ZhiJiResponse.class);
            if (ZhiJiStatusEnum.FAIL.getCode().equals(zhiJiResponse.getStatus()) || !ZhiJiCodeEnum.SUCCESS.getCode().equals(zhiJiResponse.getCode())) {
                log.warn("\u667a\u5df1-\u540c\u6b65\u5546\u54c1\u4fe1\u606f\uff0c\u667a\u5df1\u54cd\u5e94\u5931\u8d25\uff0cparam:{}", (Object)responseStr);
                JSONObject jSONObject2 = null;
                return jSONObject2;
            }
            JSONObject jSONObject = JSONObject.parseObject((String)zhiJiResponse.getData().toString());
            return jSONObject;
        }
        catch (Exception e) {
            log.warn("\u667a\u5df1-\u540c\u6b65\u5546\u54c1\u4fe1\u606f\uff0c\u667a\u5df1\u54cd\u5e94\u5f02\u5e38\uff0cparam:{}", (Object)JSON.toJSONString(params), (Object)e);
            return null;
        }
    }

    public void pushMsg(String nickname, String itemName, String uid) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("receiverId", uid);
        JSONObject parameters = new JSONObject();
        parameters.put("nickname", (Object)nickname);
        parameters.put("itemName", (Object)itemName);
        params.put("parameters", parameters);
        params.put("callOrigin", "DUIBA");
        params.put("templateId", "");
        HttpPost httpPost = ZhiJiParamTool.createHttpRequest(params, "");
        try (CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)httpPost);){
            String responseStr = EntityUtils.toString((HttpEntity)response.getEntity());
            log.info("\u667a\u5df1-\u540c\u6b65\u5546\u54c1\u4fe1\u606f\uff0c\u667a\u5df1\u54cd\u5e94\u53c2\u6570\uff0cparam:{}", (Object)responseStr);
        }
        catch (Exception e) {
            log.warn("\u667a\u5df1-\u540c\u6b65\u5546\u54c1\u4fe1\u606f\uff0c\u667a\u5df1\u54cd\u5e94\u5f02\u5e38\uff0cparam:{}", (Object)JSON.toJSONString(params), (Object)e);
        }
    }

    public CloseableHttpResponse retryRequest(HttpUriRequest httpRequest) {
        CloseableHttpResponse response = null;
        for (int i = 0; i < 2; ++i) {
            try {
                response = this.httpClient.execute(httpRequest);
                String responseStr = EntityUtils.toString((HttpEntity)response.getEntity());
                log.info("\u667a\u5df1-\u63a5\u53e3\u91cd\u8bd5\uff0c\u667a\u5df1\u54cd\u5e94\u53c2\u6570\uff0cparam:{}", (Object)responseStr);
                ZhiJiResponse zhiJiResponse = (ZhiJiResponse)JSONObject.parseObject((String)responseStr, ZhiJiResponse.class);
                if (ZhiJiCodeEnum.SUCCESS.getCode().equals(zhiJiResponse.getCode()) || ZhiJiCodeEnum.SUCCESS_2.getCode().equals(zhiJiResponse.getResultCode())) {
                    return response;
                }
                if (i <= 0) continue;
                log.warn("\u667a\u5df1-\u63a5\u53e3\u91cd\u8bd5\uff0c\u667a\u5df1\u54cd\u5e94\u5931\u8d25\uff0c\u7b2c{}\u6b21\u91cd\u8bd5\uff0cparam:{}", (Object)i, (Object)responseStr);
                continue;
            }
            catch (IOException e) {
                log.warn("\u667a\u5df1-\u63a5\u53e3\u91cd\u8bd5\uff0c\u667a\u5df1\u54cd\u5e94\u5f02\u5e38\uff0cparam:{}", (Object)httpRequest);
            }
        }
        return response;
    }
}

