/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.service.impl;

import cn.com.duiba.api.bo.credits.CreditsRequest;
import cn.com.duiba.api.bo.credits.CreditsResponse;
import cn.com.duiba.biz.Exception.ThirdpatyException;
import cn.com.duiba.dao.ConsumerCreditsLogDAO;
import cn.com.duiba.domain.ConsumerCreditsLogDO;
import cn.com.duiba.dto.AppSimpleDto;
import cn.com.duiba.service.AccessAcountService;
import cn.com.duiba.service.AppService;
import cn.com.duiba.service.ConsumerCreditsLogService;
import cn.com.duiba.service.impl.CompositeCreditsLogExtractor;
import cn.com.duiba.thirdparty.dto.ConsumerCreditsLogSaveDto;
import cn.com.duiba.wolf.utils.BeanUtils;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service(value="consumerCreditsLogService")
public class ConsumerCreditsLogServiceImpl
implements ConsumerCreditsLogService {
    private static final Logger log = LoggerFactory.getLogger(ConsumerCreditsLogServiceImpl.class);
    @Resource
    private ConsumerCreditsLogDAO consumerCreditsLogDAO;
    @Resource
    private AccessAcountService accessAcountService;
    @Resource
    private AppService appService;
    @Resource
    private CompositeCreditsLogExtractor extractor;

    @Override
    public Long save(ConsumerCreditsLogSaveDto creditsLog) {
        Assert.notNull((Object)creditsLog, (String)"ConsumerCreditsLogSaveDto\u4e0d\u80fd\u4e3anull");
        Assert.notNull((Object)creditsLog.getAppId(), (String)"appId\u4e0d\u80fd\u4e3anull");
        AppSimpleDto app = this.appService.getById(creditsLog.getAppId());
        Assert.notNull((Object)app, (String)"app\u4e0d\u80fd\u4e3anull");
        if (!this.accessAcountService.canAccessAcount(creditsLog.getAppId()).booleanValue()) {
            return 0L;
        }
        ConsumerCreditsLogDO entity = (ConsumerCreditsLogDO)BeanUtils.copy((Object)creditsLog, ConsumerCreditsLogDO.class);
        entity.setChangeType(creditsLog.getChangeType().getType());
        entity.setLogStatus(creditsLog.getLogStatus().getType());
        return this.consumerCreditsLogDAO.insert(entity);
    }

    @Override
    public Long save(CreditsRequest request, CreditsResponse response) {
        if (!this.extractor.supports(request, response)) {
            throw new ThirdpatyException("\u8be5creditsMessage\u4e0d\u652f\u6301");
        }
        ConsumerCreditsLogSaveDto creditsLog = this.extractor.extract(request, response);
        if (creditsLog == null) {
            return 0L;
        }
        return this.save(creditsLog);
    }
}

