/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.service.impl;

import cn.com.duiba.api.bo.addcredits.AddCreditsMsgDto;
import cn.com.duiba.api.bo.credits.CreditsResponse;
import cn.com.duiba.api.bo.subcredits.SubCreditsMsgDto;
import cn.com.duiba.api.bo.subcredits.SubCreditsResultMsgDto;
import cn.com.duiba.api.bo.virtual.VirtualMsgDto;
import cn.com.duiba.api.enums.HttpRequestResultType;
import cn.com.duiba.api.enums.subcredits.SubCreditsType;
import cn.com.duiba.biz.credits.AbchinaApi;
import cn.com.duiba.biz.credits.AddCreditsToDeveloper;
import cn.com.duiba.biz.credits.JJYApi;
import cn.com.duiba.biz.credits.JiuYangApi;
import cn.com.duiba.biz.credits.ReconciliationBizService;
import cn.com.duiba.biz.virtual.supplier.VirtualSupplier;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.constant.DelayNotifyConfig;
import cn.com.duiba.constant.ErweihuoConfig;
import cn.com.duiba.constant.SkipNotifyConfig;
import cn.com.duiba.domain.HttpMessageDO;
import cn.com.duiba.domain.SubCreditsMsgWrapper;
import cn.com.duiba.domain.SupplierRequest;
import cn.com.duiba.mq.RocketMQMsgProducer;
import cn.com.duiba.mq.RocketMQTopicConstant;
import cn.com.duiba.notifycenter.dao.NotifyQueueDAO;
import cn.com.duiba.notifycenter.domain.NotifyQueueDO;
import cn.com.duiba.notifycenter.service.NotifyService;
import cn.com.duiba.order.center.api.dto.CreditsMessage;
import cn.com.duiba.service.ConsumerCreditsLogService;
import cn.com.duiba.service.CreditsService;
import cn.com.duiba.service.CustomService;
import cn.com.duiba.service.HttpAsyncClientPool;
import cn.com.duiba.thirdparty.dto.CreditsMessageDto;
import cn.com.duiba.thirdparty.enums.CallbackChannelTypeEnum;
import cn.com.duiba.thirdparty.enums.DelayMsgConfigNameEnum;
import cn.com.duiba.thirdparty.enums.NotifyTypeEnum;
import cn.com.duiba.thirdparty.mq.msg.NotifyDeveloperMsg;
import cn.com.duiba.tool.AssembleTool;
import cn.com.duiba.tool.HttpRequestLog;
import cn.com.duiba.tool.JsonTool;
import cn.com.duiba.wolf.utils.BeanUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import javax.annotation.Resource;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.entity.GzipDecompressingEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.message.BasicHeader;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CreditsServiceImpl
implements CreditsService {
    private static final Logger LOG = LoggerFactory.getLogger(CreditsServiceImpl.class);
    @Autowired
    private ConsumerCreditsLogService consumerCreditsLogService;
    @Autowired
    private HttpAsyncClientPool httpAsyncClientPool;
    @Autowired
    private CustomService customService;
    @Autowired
    private RocketMQMsgProducer rocketMQMsgProducer;
    @Autowired
    private NotifyQueueDAO notifyQueueDAO;
    @Autowired
    private NotifyService notifyService;
    @Autowired
    private JJYApi jjyApi;
    @Autowired
    private ErweihuoConfig erweihuoConfig;
    @Autowired
    private AbchinaApi abchinaApi;
    @Resource(name="httpCallbackExecutorService")
    private ExecutorService httpCallbackExecutorService;
    @Autowired
    private AddCreditsToDeveloper addCreditsToDeveloper;
    @Autowired
    private VirtualSupplier virtualSupplier;
    @Autowired
    private JiuYangApi jiuYangApi;
    @Autowired
    private ReconciliationBizService reconciliationBizService;
    @Autowired
    private SkipNotifyConfig skipNotifyConfig;
    @Autowired
    private DelayNotifyConfig delayNotifyConfig;
    @Autowired
    private RocketMQTopicConstant rocketMQTopicConstant;

    @Override
    public void subCredits(SubCreditsMsgDto subCreditsMsg) {
        SubCreditsMsgWrapper request;
        if (subCreditsMsg == null) {
            return;
        }
        SubCreditsMsgWrapper subCreditsMsgWrapper = new SubCreditsMsgWrapper(subCreditsMsg);
        try {
            request = this.customService.getRequestCredits(subCreditsMsgWrapper);
            this.reconciliationBizService.saveMqSubCreditsMsg(request);
        }
        catch (BizException e) {
            LOG.info("\u6263\u79ef\u5206\u6d41\u7a0b\u4e2d\u65ad aid={}, cid={}, rid={}, rType={}", new Object[]{subCreditsMsg.getAppId(), subCreditsMsg.getConsumerId(), subCreditsMsg.getRelationId(), subCreditsMsg.getRelationType()});
            return;
        }
        HttpRequestBase http = this.customService.getMqSubCreditsHttpRequest(request);
        if (http == null) {
            if (2 == request.getSubCreditsMsg().getHttpType()) {
                Map authParams = request.getSubCreditsMsg().getAuthParams();
                if (MapUtils.isNotEmpty((Map)authParams)) {
                    authParams.remove("appSecret");
                }
                http = AssembleTool.assembleRequest(request.getHttpUrl(), request.getSubCreditsMsg().getAuthParams());
                HttpRequestLog.logUrl("[action subCredits request][bizId " + request.getSubCreditsMsg().getRelationId() + "] [type " + request.getSubCreditsMsg().getRelationType() + "] [post url " + request.getHttpUrl() + "][authParams " + request.getSubCreditsMsg().getAuthParams() + "][consumerId " + request.getSubCreditsMsg().getConsumerId() + "]");
            } else {
                http = new HttpGet(request.getHttpUrl());
                HttpRequestLog.logUrl("[action subCredits request][bizId " + request.getSubCreditsMsg().getRelationId() + "] [type " + request.getSubCreditsMsg().getRelationType() + "] [get url " + request.getHttpUrl() + "][consumerId " + request.getSubCreditsMsg().getConsumerId() + "]");
            }
        } else {
            HttpRequestLog.logUrl("[action subCredits request][bizId " + request.getSubCreditsMsg().getRelationId() + "] [type " + request.getSubCreditsMsg().getRelationType() + "] [url " + request.getHttpUrl() + "][authParams " + request.getSubCreditsMsg().getAuthParams() + "][consumerId " + request.getSubCreditsMsg().getConsumerId() + "]");
        }
        this.setHttpHeader(request.getSubCreditsMsg(), http, request);
        this.httpAsyncClient(request, http);
    }

    @Override
    public void addCredits(AddCreditsMsgDto addCreditsMsgDto) {
        if (addCreditsMsgDto == null) {
            return;
        }
        Map paramsMap = addCreditsMsgDto.getAuthParams();
        addCreditsMsgDto.getParams().put("callbackMessageType", CallbackChannelTypeEnum.ROCKETMQ.getType());
        CreditsMessageDto dto = new CreditsMessageDto();
        dto.setAppId(String.valueOf(addCreditsMsgDto.getAppId()));
        dto.setRelationId(addCreditsMsgDto.getRelationId());
        dto.setTimestamp(Long.valueOf(System.currentTimeMillis()));
        dto.setConsumerId(String.valueOf(addCreditsMsgDto.getConsumerId()));
        dto.setRelationType(addCreditsMsgDto.getRelationType());
        dto.setParams(addCreditsMsgDto.getParams());
        dto.setHttpUrl(AssembleTool.assembleUrl(addCreditsMsgDto.getHttpUrl(), paramsMap));
        dto.setHttpType("get");
        dto.setAuthParams(paramsMap);
        dto.setCallbackTopic(addCreditsMsgDto.getCallbackTopic());
        dto.setCallbackTag(addCreditsMsgDto.getCallbackTag());
        dto.setCallbackKey(addCreditsMsgDto.getCallbackKey());
        dto.setBizId(addCreditsMsgDto.getRelationId());
        dto.setAddCreditsParams(addCreditsMsgDto.getAddCreditsParams());
        HttpMessageDO message = new HttpMessageDO();
        message.setAppId(addCreditsMsgDto.getAppId());
        message.setBizType("addCredits");
        message.setBizParams(JsonTool.objectToJson(dto));
        message.setNumber(0);
        this.addCreditsToDeveloper.submit(message);
    }

    @Override
    public void virtualExchange(VirtualMsgDto decode) {
        if (decode == null) {
            return;
        }
        Map paramsMap = decode.getVirtualParams().toRequestMap(decode.getAppSecret());
        SupplierRequest request = new SupplierRequest();
        request.setAppId(String.valueOf(decode.getAppId()));
        request.setAuthParams(paramsMap);
        request.setConsumerId(String.valueOf(decode.getConsumerId()));
        request.setParams(decode.getParams());
        request.setOrderId(decode.getOrderId());
        request.setSupplierOrderId(decode.getOrderId());
        request.setHttpUrl(AssembleTool.assembleUrl(decode.getHttpUrl(), paramsMap));
        request.setSupplierName(decode.getSupplierName());
        this.virtualSupplier.asyncSubmit(request, decode.getCallbackTopic(), decode.getCallbackTag(), decode.getCallbackKey());
    }

    private void httpAsyncClient(final SubCreditsMsgWrapper request, HttpRequestBase http) {
        this.httpAsyncClientPool.submit(String.valueOf(request.getSubCreditsMsg().getAppId()), (HttpUriRequest)http, new FutureCallback<HttpResponse>(){
            String body = "";

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void completed(HttpResponse response) {
                SubCreditsResultMsgDto resp = new SubCreditsResultMsgDto();
                try {
                    resp.setResultType(HttpRequestResultType.COMPLETED);
                    Header header = response.getEntity().getContentEncoding();
                    String result = header != null && header.toString().contains("gzip") ? EntityUtils.toString((HttpEntity)new GzipDecompressingEntity(response.getEntity())) : EntityUtils.toString((HttpEntity)response.getEntity());
                    String relationType = null;
                    SubCreditsType subCreditsType = request.getSubCreditsMsg().getRelationType();
                    if (subCreditsType != null) {
                        relationType = subCreditsType.getMsg();
                    }
                    this.body = CreditsServiceImpl.this.customService.getResponseCredits(request.getSubCreditsMsg().getAppId(), result, Boolean.FALSE, request.getSubCreditsMsg().getAuthParams());
                    CreditsServiceImpl.this.reconciliationBizService.updateCreditsRsp(request, this.body, Boolean.FALSE);
                    CreditsServiceImpl.this.parseResponseBody(resp, HttpRequestLog.subBody(this.body), request.getSubCreditsMsg().getAppId(), request.getSubCreditsMsg().getRelationId(), request.getSubCreditsMsg().getRelationType());
                }
                catch (Exception e) {
                    LOG.error("toDeveloper completed", (Throwable)e);
                }
                finally {
                    CreditsServiceImpl.this.finallyBlock(request, resp, request.getSubCreditsMsg().getCallbackTopic(), request.getSubCreditsMsg().getCallbackTag(), request.getSubCreditsMsg().getCallbackTag(), Integer.toString(response.getStatusLine().getStatusCode()), HttpRequestLog.subBody(this.body));
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void failed(Exception ex) {
                LOG.error("toDeveloper failed bizId:" + request.getSubCreditsMsg().getRelationId() + " bizType:" + request.getSubCreditsMsg().getRelationType(), (Throwable)ex);
                SubCreditsResultMsgDto resp = new SubCreditsResultMsgDto();
                try {
                    resp.setResultType(HttpRequestResultType.FAILED);
                    resp.setResponse(ex.getMessage());
                }
                catch (Exception e) {
                    LOG.error("toDeveloper failed", (Throwable)e);
                }
                finally {
                    CreditsServiceImpl.this.finallyBlock(request, resp, request.getSubCreditsMsg().getCallbackTopic(), request.getSubCreditsMsg().getCallbackTag(), request.getSubCreditsMsg().getCallbackTag(), "", HttpRequestLog.subBody(this.body));
                }
            }

            public void cancelled() {
                LOG.info("toDeveloper cancelled bizId:" + request.getSubCreditsMsg().getRelationId() + " bizType:" + request.getSubCreditsMsg().getRelationType());
                SubCreditsResultMsgDto resp = new SubCreditsResultMsgDto();
                try {
                    resp.setResultType(HttpRequestResultType.CANCELLED);
                    resp.setResponse("http cancelled");
                }
                catch (Exception e) {
                    LOG.error("toDeveloper cancelled", (Throwable)e);
                }
                finally {
                    CreditsServiceImpl.this.finallyBlock(request, resp, request.getSubCreditsMsg().getCallbackTopic(), request.getSubCreditsMsg().getCallbackTag(), request.getSubCreditsMsg().getCallbackTag(), "", HttpRequestLog.subBody(this.body));
                }
            }
        });
    }

    @Override
    public void notifyDeveloper(NotifyDeveloperMsg notifyDeveloperMsg) {
        try {
            if (this.skipNotifyConfig.hasNotNotify(notifyDeveloperMsg.getAppId(), notifyDeveloperMsg.getResult())) {
                LOG.info("the app skip notify, appId={}", (Object)notifyDeveloperMsg.getAppId());
                return;
            }
            if (this.erweihuoConfig.getAppIds().contains(notifyDeveloperMsg.getAppId())) {
                return;
            }
            NotifyQueueDO queue = (NotifyQueueDO)BeanUtils.copy((Object)notifyDeveloperMsg, NotifyQueueDO.class);
            if (queue.getTimes() == null) {
                queue.setTimes(0);
            }
            if (queue.getNotifyType() == null) {
                queue.setNotifyType(NotifyTypeEnum.NOTIFY_RESULT.getCode());
            }
            if (NotifyTypeEnum.getByCode((Integer)queue.getNotifyType()) == null) {
                LOG.warn("\u901a\u77e5\u7c7b\u578b\u4e0d\u5b58\u5728;queue:" + JSON.toJSONString((Object)queue));
                return;
            }
            String errorMsg = queue.getError4developer();
            if (StringUtils.isNotBlank((String)errorMsg) && errorMsg.length() > 600) {
                queue.setError4developer(errorMsg.substring(0, 600));
            }
            if (this.delayNotifyConfig.ifNeedDelay(queue.getAppId())) {
                LOG.info("[\u4e07\u8fbe\u9152\u5e97] creditsService mq\u5ef6\u65f6\u53d1\u9001");
                JSONObject json = (JSONObject)JSONObject.toJSON((Object)queue);
                Integer delayLevel = Optional.ofNullable(DelayNotifyConfig.getDelayLevels(queue.getAppId())).orElse(0);
                json.put(DelayMsgConfigNameEnum.DELAY_LEVEL.getName(), (Object)delayLevel);
                this.rocketMQMsgProducer.sendMsg(this.rocketMQTopicConstant.getDelayMsg(), "mq", "", json.toJSONString(), false, null);
                return;
            }
            this.notifyQueueDAO.insert(queue);
            this.notifyService.notify(queue, "remote call");
        }
        catch (Exception e) {
            LOG.error("notify error NotifyDeveloperMsg = " + JSON.toJSONString((Object)notifyDeveloperMsg), (Throwable)e);
        }
    }

    @Override
    public void delayMsgNotify(NotifyQueueDO queue) {
        try {
            this.notifyQueueDAO.insert(queue);
            this.notifyService.notify(queue, "delay msg");
        }
        catch (Exception e) {
            LOG.warn("delay msg error NotifyDeveloperMsg = " + JSON.toJSONString((Object)queue), (Throwable)e);
        }
    }

    private void setHttpHeader(SubCreditsMsgDto request, HttpRequestBase http, SubCreditsMsgWrapper subMsg) {
        Long appId = request.getAppId();
        if (this.customService.isMobike(appId)) {
            String time = (String)request.getParams().get("time");
            if (StringUtils.isNotEmpty((String)time)) {
                http.setHeader((Header)new BasicHeader("time", time));
                http.setHeader((Header)new BasicHeader("accesstoken", (String)request.getParams().get("accesstoken")));
            }
        } else if (this.customService.isCainiao(appId)) {
            http.setHeader("Accept", "text/xml,text/javascript");
            http.setHeader("User-Agent", "top-sdk-java");
            http.setHeader("Content-Type", "application/x-www-form-urlencoded;charset=utf-8");
            http.setHeader("Accept-Encoding", "gzip");
        } else if (this.customService.isHaiDiLao(appId)) {
            CreditsMessage cmg = new CreditsMessage();
            cmg.setHttpType(http.getMethod());
            cmg.setHttpUrl(subMsg.getHttpUrl());
            cmg.setAuthParams(subMsg.getSubCreditsMsg().getAuthParams());
            this.customService.setHaidilaoSubAndAddHttpHeader(cmg, http);
        } else if (this.customService.isRenrenTv(appId)) {
            this.customService.setRenrenTvSubOrAddHttpHeader(request.getAuthParams(), http);
        } else if (this.jjyApi.isJJY(appId)) {
            this.jjyApi.setJJYHttpHead(request.getAuthParams(), http);
        } else if (this.jiuYangApi.isJiuYangAppid(appId).booleanValue()) {
            this.jiuYangApi.setJiuYangHttpHead(http, String.valueOf(appId));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finallyBlock(SubCreditsMsgWrapper req, SubCreditsResultMsgDto resp, String msgTopic, String msgTag, String msgKey, String code, String callbackBody) {
        String body = null;
        try {
            resp.setRelationId(req.getSubCreditsMsg().getRelationId());
            resp.setRelationType(req.getSubCreditsMsg().getRelationType());
            resp.setParams(req.getSubCreditsMsg().getParams());
            resp.setAppId(req.getSubCreditsMsg().getAppId());
            resp.setConsumerId(req.getSubCreditsMsg().getConsumerId());
            resp.setHttpUrl(req.getHttpUrl());
            body = JsonTool.objectToJson(resp);
            this.rocketMQMsgProducer.sendMsg(msgTopic, msgTag, msgKey, body, false, null);
            this.saveCreditsLog(req, resp);
            this.addAbchinaCredits(req, resp);
        }
        catch (Exception e) {
            LOG.error("credits callback: bizId:" + req.getSubCreditsMsg().getRelationId() + " bizType:" + req.getSubCreditsMsg().getRelationType(), (Throwable)e);
        }
        finally {
            HttpRequestLog.logUrl("[action subCredits] [tag response] [code " + code + "] [bizId " + req.getSubCreditsMsg().getRelationId() + "] [type " + req.getSubCreditsMsg().getRelationType() + "] [callback " + resp.getResultType() + "] [body " + callbackBody + "]");
        }
    }

    private void addAbchinaCredits(SubCreditsMsgWrapper req, SubCreditsResultMsgDto resp) {
        try {
            this.abchinaApi.addCreditsNum(req, resp);
        }
        catch (Exception e) {
            LOG.info("abchina addCreditsNum error", (Throwable)e);
        }
    }

    private void parseResponseBody(SubCreditsResultMsgDto subCreditsResultMsg, String body, Long appId, String relationId, SubCreditsType type) {
        JSONObject jsonObject = null;
        try {
            jsonObject = JSONObject.parseObject((String)body);
        }
        catch (Exception e) {
            if (body != null && body.length() > 100) {
                body = body.substring(0, 100);
            }
            if ("46112".equals(appId + "")) {
                LOG.info("parse subCredits json fail, appId={}, bizId={}, type={}, body={}", new Object[]{appId, relationId, type, body});
            } else {
                LOG.warn("parse subCredits json fail, appId={}, bizId={}, type={}, body={}", new Object[]{appId, relationId, type, body});
            }
            subCreditsResultMsg.setCode(2);
            subCreditsResultMsg.setResponse(body);
            return;
        }
        if (jsonObject == null) {
            subCreditsResultMsg.setResponse(body);
            subCreditsResultMsg.setCode(2);
            return;
        }
        JSONObject extraInfo = jsonObject.getJSONObject("extraInfo");
        if ("ok".equalsIgnoreCase((jsonObject = this.getOneDegreeJson(jsonObject)).getString("status"))) {
            subCreditsResultMsg.setCode(1);
            Long credits = jsonObject.getLong("credits");
            if (credits != null && credits >= 0L) {
                subCreditsResultMsg.setCredits(credits);
            }
            String bizId = jsonObject.getString("bizId");
            subCreditsResultMsg.setBizId(bizId);
            if (extraInfo != null && !extraInfo.isEmpty()) {
                for (Map.Entry entry : extraInfo.entrySet()) {
                    if (!(entry.getValue() instanceof String)) continue;
                    subCreditsResultMsg.getExtraInfo().put(entry.getKey(), (String)entry.getValue());
                }
            }
        } else {
            subCreditsResultMsg.setCode(3);
            subCreditsResultMsg.setErrorMessage(jsonObject.getString("errorMessage"));
            subCreditsResultMsg.setResponse(body);
        }
    }

    private JSONObject getOneDegreeJson(JSONObject o) {
        JSONObject json = new JSONObject();
        for (Map.Entry entry : o.entrySet()) {
            if (entry.getValue() instanceof JSONObject) {
                JSONObject json2 = (JSONObject)entry.getValue();
                for (Map.Entry entry2 : json2.entrySet()) {
                    json.put((String)entry2.getKey(), entry2.getValue());
                }
                continue;
            }
            json.put((String)entry.getKey(), entry.getValue());
        }
        return json;
    }

    private void saveCreditsLog(SubCreditsMsgWrapper request, SubCreditsResultMsgDto response) {
        this.httpCallbackExecutorService.execute(() -> {
            try {
                if (HttpRequestResultType.COMPLETED.equals((Object)response.getResultType()) && 1 == response.getCode()) {
                    this.consumerCreditsLogService.save(request, (CreditsResponse)response);
                }
            }
            catch (Exception e) {
                String errMsg = this.getErrMsg(e);
                LOG.info("\u79ef\u5206\u8bb0\u5f55\u4fdd\u5b58\u5931\u8d25, bizId={}, bizType={}", new Object[]{request.getSubCreditsMsg().getRelationId(), request.getSubCreditsMsg().getRelationType(), errMsg});
            }
        });
    }

    private String getErrMsg(Exception e) {
        String causeMsg = "";
        if (StringUtils.isNotBlank((String)e.getMessage())) {
            causeMsg = e.getMessage().length() > 200 ? e.getMessage().substring(0, 200) : e.getMessage();
        }
        return causeMsg;
    }
}

