/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tool;

import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

public class IcbcSignTool {
    private static final String MD5 = "MD5";
    private static final String ZERO = "0";

    public static String createSign(Map<String, ?> paramsMap, String secret) {
        Set<String> keySet = paramsMap.keySet();
        ArrayList<String> paramNames = new ArrayList<String>(keySet);
        Collections.sort(paramNames);
        StringBuilder paramNameValue = new StringBuilder();
        for (String paramName : paramNames) {
            paramNameValue.append(paramName).append(paramsMap.get(paramName));
        }
        String source = secret + paramNameValue.toString() + secret;
        return IcbcSignTool.encryptUpper(source);
    }

    private static String encryptUpper(String input) {
        return IcbcSignTool.encrypt(input).toUpperCase();
    }

    private static String encrypt(String input) {
        if (input == null || "".equals(input)) {
            throw new IllegalArgumentException("The argument input can not be empty.");
        }
        return IcbcSignTool.encrypt(input.getBytes());
    }

    private static String encrypt(byte[] input) {
        if (input == null || input.length == 0) {
            throw new IllegalArgumentException("The argument input can not be empty.");
        }
        try {
            MessageDigest md = MessageDigest.getInstance(MD5);
            byte[] buff = md.digest(input);
            return IcbcSignTool.byte2hex(buff);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static String byte2hex(byte[] bytes) {
        StringBuilder sign = new StringBuilder();
        for (int i = 0; i < bytes.length; ++i) {
            String hex = Integer.toHexString(bytes[i] & 0xFF);
            if (hex.length() == 1) {
                sign.append(ZERO);
            }
            sign.append(hex);
        }
        return sign.toString();
    }
}

