/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.biz.credits;

import cn.com.duiba.credits.sdk.CreditNotifyParams;
import cn.com.duiba.credits.sdk.SignTool;
import cn.com.duiba.domain.SubCreditsMsgWrapper;
import cn.com.duiba.domain.SupplierRequest;
import cn.com.duiba.notifycenter.domain.NotifyQueueDO;
import cn.com.duiba.order.center.api.dto.CreditsMessage;
import cn.com.duiba.tool.AssembleTool;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class BaiduApi {
    private static Logger logger = LoggerFactory.getLogger(BaiduApi.class);
    private String baiduAppSecret = "4Vs1LSp1Xo4KHE6dm3BkFojNFW7N";

    public CreditsMessage getSubCreditsMessage(CreditsMessage request) {
        String url = request.getHttpUrl();
        String host = url.substring(0, url.indexOf(63));
        String params = url.substring(url.indexOf(63) + 1);
        Map<String, String> paramMap = AssembleTool.getUrlParams(params);
        String accessToken = paramMap.get("transfer");
        paramMap.remove("transfer");
        paramMap.remove("sign");
        paramMap.put("access_token", accessToken);
        paramMap.put("appSecret", this.baiduAppSecret);
        String sign = SignTool.sign(paramMap);
        paramMap.remove("appSecret");
        paramMap.put("sign", sign);
        String requestUrl = AssembleTool.assembleUrl(host, paramMap);
        request.setHttpUrl(requestUrl);
        request.setHttpType("get");
        request.setAuthParams(new HashMap());
        return request;
    }

    public SubCreditsMsgWrapper getSubCreditsMessage(SubCreditsMsgWrapper subCreditsMsgWrapper) {
        String url = subCreditsMsgWrapper.getHttpUrl();
        String host = url.substring(0, url.indexOf(63));
        String params = url.substring(url.indexOf(63) + 1);
        Map<String, String> paramMap = AssembleTool.getUrlParams(params);
        String accessToken = paramMap.get("transfer");
        paramMap.remove("transfer");
        paramMap.remove("sign");
        paramMap.put("access_token", accessToken);
        paramMap.put("appSecret", this.baiduAppSecret);
        String sign = SignTool.sign(paramMap);
        paramMap.remove("appSecret");
        paramMap.put("sign", sign);
        String requestUrl = AssembleTool.assembleUrl(host, paramMap);
        subCreditsMsgWrapper.setHttpUrl(requestUrl);
        subCreditsMsgWrapper.getSubCreditsMsg().setHttpType(1);
        return subCreditsMsgWrapper;
    }

    public HttpRequestBase getRequestNotify(String url, NotifyQueueDO record, CreditNotifyParams p) {
        String transfer = record.getTransfer();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("success", Boolean.toString(p.isSuccess()));
        map.put("errorMessage", this.getString(p.getErrorMessage()));
        map.put("bizId", this.getString(p.getBizId()));
        map.put("appKey", this.getString(p.getAppKey()));
        map.put("appSecret", this.baiduAppSecret);
        map.put("timestamp", this.getString(p.getTimestamp().getTime()));
        map.put("uid", this.getString(record.getPartnerUserId()));
        map.put("orderNum", this.getString(p.getOrderNum()));
        map.put("access_token", this.getString(transfer));
        String sign = SignTool.sign(map);
        map.remove("appSecret");
        map.put("sign", sign);
        HttpGet request = new HttpGet(AssembleTool.assembleUrl(url, map));
        request.setConfig(this.getDefaultConfig());
        return request;
    }

    private String getString(Object o) {
        return o == null ? "" : o.toString();
    }

    private RequestConfig getDefaultConfig() {
        return RequestConfig.custom().setConnectTimeout(30000).setConnectionRequestTimeout(30000).setSocketTimeout(30000).build();
    }

    public SupplierRequest getVirtualRequest(SupplierRequest request) {
        String url = request.getHttpUrl();
        String host = url.substring(0, url.indexOf(63));
        String params = url.substring(url.indexOf(63) + 1);
        Map<String, String> paramMap = AssembleTool.getUrlParams(params);
        String accessToken = paramMap.get("transfer");
        paramMap.remove("transfer");
        paramMap.remove("sign");
        paramMap.put("access_token", accessToken);
        paramMap.put("appSecret", this.baiduAppSecret);
        String sign = SignTool.sign(paramMap);
        paramMap.remove("appSecret");
        paramMap.put("sign", sign);
        String requestUrl = AssembleTool.assembleUrl(host, paramMap);
        request.setHttpUrl(requestUrl);
        return request;
    }
}

