/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.biz.credits;

import cn.com.duiba.api.bo.subcredits.SubCreditsMsgDto;
import cn.com.duiba.boot.profiler.DBTimeProfiler;
import cn.com.duiba.constant.ReconciliationConfig;
import cn.com.duiba.credits.sdk.CreditConsumeParams;
import cn.com.duiba.domain.SubCreditsMsgWrapper;
import cn.com.duiba.domain.SupplierRequest;
import cn.com.duiba.order.center.api.dto.CreditsMessage;
import cn.com.duiba.service.reconciliation.ReconciliationRecordService;
import cn.com.duiba.thirdparty.dto.CreditsMessageDto;
import cn.com.duiba.thirdparty.dto.reconciliation.ReconciliationRecordDto;
import cn.com.duiba.thirdparty.enums.reconciliation.ReconciliationLogTypeEnum;
import cn.com.duiba.thirdparty.enums.reconciliation.ReconciliationRespStatusEnum;
import cn.com.duiba.tool.AssembleTool;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ReconciliationBizService {
    private static final Logger logger = LoggerFactory.getLogger(ReconciliationBizService.class);
    @Autowired
    private ReconciliationConfig reconciliationConfig;
    @Resource(name="reconExecutorService")
    private ExecutorService executorService;
    @Autowired
    private ReconciliationRecordService reconciliationRecordService;

    private boolean isReconcile(Long appId) {
        if (appId == null || CollectionUtils.isEmpty(this.reconciliationConfig.getAppIdSet())) {
            return false;
        }
        return this.reconciliationConfig.getAppIdSet().contains(appId);
    }

    public void saveRpcSubCreditsMsg(CreditsMessage request) {
        if (!this.isReconcile(Long.valueOf(request.getAppId()))) {
            return;
        }
        logger.info("reconcile rpc\u51cf\u79ef\u5206\uff1a{}", (Object)JSONObject.toJSONString((Object)request));
        this.executorService.submit(() -> {
            try {
                Map<String, String> authParamMap;
                String url = request.getHttpUrl();
                String orderNum = request.getRelationId();
                if (Objects.equals(request.getHttpType(), "post")) {
                    authParamMap = request.getAuthParams();
                } else {
                    String authParams = url.substring(url.indexOf(63) + 1);
                    authParamMap = AssembleTool.getUrlParams(authParams);
                }
                if (MapUtils.isNotEmpty((Map)authParamMap) && StringUtils.isNotBlank((CharSequence)((CharSequence)authParamMap.get("orderNum")))) {
                    orderNum = authParamMap.get("orderNum");
                }
                ReconciliationRecordDto dto = this.wrapReconciliationLog(Long.valueOf(request.getAppId()), orderNum, request.getRelationType(), authParamMap, request.getParams(), ReconciliationLogTypeEnum.SUB_CREDITS);
                this.reconciliationRecordService.saveOrUpdate(dto);
            }
            catch (Exception e) {
                logger.error("save\u5bf9\u8d26\u8bb0\u5f55\u51fa\u9519, appId:{}, relationId:{}, relationType:{}, ", new Object[]{request.getAppId(), request.getRelationId(), request.getRelationType(), e});
            }
        });
    }

    public void saveMqSubCreditsMsg(SubCreditsMsgWrapper subCreditsMsgWrapper) {
        if (!this.isReconcile(subCreditsMsgWrapper.getSubCreditsMsg().getAppId())) {
            return;
        }
        logger.info("reconcile mq\u51cf\u79ef\u5206\uff1a{}", (Object)JSONObject.toJSONString((Object)subCreditsMsgWrapper));
        this.executorService.submit(() -> {
            try {
                ReconciliationRecordDto dto = this.wrapReconciliationLog(subCreditsMsgWrapper);
                this.reconciliationRecordService.saveOrUpdate(dto);
            }
            catch (Exception e) {
                logger.error("save\u5bf9\u8d26\u8bb0\u5f55\u51fa\u9519, appId:{}, relationId:{}, relationType:{}, ", new Object[]{subCreditsMsgWrapper.getSubCreditsMsg().getAppId(), subCreditsMsgWrapper.getSubCreditsMsg().getRelationId(), subCreditsMsgWrapper.getSubCreditsMsg().getRelationType(), e});
            }
        });
    }

    private ReconciliationRecordDto wrapReconciliationLog(SubCreditsMsgWrapper subCreditsMsgWrapper) {
        SubCreditsMsgDto subCreditsMsgDto = subCreditsMsgWrapper.getSubCreditsMsg();
        CreditConsumeParams creditConsumeParams = subCreditsMsgDto.getCreditConsumeParams();
        Map paramMap = subCreditsMsgDto.getParams();
        Map authParamMap = subCreditsMsgDto.getAuthParams();
        ReconciliationRecordDto reconciliationRecordDto = new ReconciliationRecordDto();
        reconciliationRecordDto.setOrderNum(subCreditsMsgDto.getRelationId());
        reconciliationRecordDto.setPartnerUserId(creditConsumeParams.getUid());
        reconciliationRecordDto.setLogType(Integer.valueOf(ReconciliationLogTypeEnum.SUB_CREDITS.getCode()));
        reconciliationRecordDto.setSendTime(new Date());
        if (MapUtils.isNotEmpty((Map)paramMap)) {
            reconciliationRecordDto.setOptId((String)paramMap.get("opId"));
        }
        if (MapUtils.isNotEmpty((Map)authParamMap) && StringUtils.isNotBlank((CharSequence)((CharSequence)authParamMap.get("orderNum")))) {
            reconciliationRecordDto.setOrderNum((String)authParamMap.get("orderNum"));
        }
        if (subCreditsMsgDto.getRelationType() != null) {
            reconciliationRecordDto.setOptType(subCreditsMsgDto.getRelationType().getMsg());
        }
        reconciliationRecordDto.setCredits(creditConsumeParams.getCredits());
        reconciliationRecordDto.setAppId(subCreditsMsgDto.getAppId());
        return reconciliationRecordDto;
    }

    private ReconciliationRecordDto wrapReconciliationLog(Long appId, String relationId, String relationType, Map<String, String> authParamMap, Map<String, String> paramMap, ReconciliationLogTypeEnum logTypeEnum) {
        String credits;
        ReconciliationRecordDto reconciliationRecordDto = new ReconciliationRecordDto();
        reconciliationRecordDto.setOrderNum(relationId);
        reconciliationRecordDto.setPartnerUserId(authParamMap.get("uid"));
        reconciliationRecordDto.setLogType(Integer.valueOf(logTypeEnum.getCode()));
        reconciliationRecordDto.setSendTime(new Date());
        if (MapUtils.isNotEmpty(paramMap)) {
            reconciliationRecordDto.setOptId(paramMap.get("opId"));
        }
        if (StringUtils.isNotBlank((CharSequence)relationType)) {
            reconciliationRecordDto.setOptType(relationType);
        }
        if (StringUtils.isNotBlank((CharSequence)(credits = authParamMap.get("credits")))) {
            reconciliationRecordDto.setCredits(Long.valueOf(credits));
        }
        reconciliationRecordDto.setAppId(appId);
        return reconciliationRecordDto;
    }

    public void saveAddCreditsMsg(CreditsMessageDto request) {
        if (!this.isReconcile(Long.valueOf(request.getAppId()))) {
            return;
        }
        logger.info("reconcile \u52a0\u79ef\u5206\uff1a{}", (Object)JSONObject.toJSONString((Object)request));
        this.executorService.submit(() -> {
            try {
                Map<String, String> authParamMap;
                String url = request.getHttpUrl();
                String orderNum = request.getRelationId();
                if (Objects.equals(request.getHttpType(), "post")) {
                    authParamMap = request.getAuthParams();
                } else {
                    String authParams = url.substring(url.indexOf(63) + 1);
                    authParamMap = AssembleTool.getUrlParams(authParams);
                }
                if (MapUtils.isNotEmpty((Map)authParamMap) && StringUtils.isNotBlank((CharSequence)((CharSequence)authParamMap.get("orderNum")))) {
                    orderNum = authParamMap.get("orderNum");
                }
                ReconciliationRecordDto dto = this.wrapReconciliationLog(Long.valueOf(request.getAppId()), orderNum, request.getRelationType(), authParamMap, request.getParams(), ReconciliationLogTypeEnum.ADD_CREDITS);
                this.reconciliationRecordService.saveOrUpdate(dto);
            }
            catch (Exception e) {
                logger.error("save\u5bf9\u8d26\u8bb0\u5f55\u51fa\u9519, appId:{}, relationId:{}, relationType:{}, ", new Object[]{request.getAppId(), request.getRelationId(), request.getRelationType(), e});
            }
        });
    }

    public void mallExchangeNotify(ReconciliationRecordDto dto) {
        if (!this.isReconcile(dto.getAppId())) {
            return;
        }
        logger.info("reconcile \u666e\u5151\u8ba2\u5355\uff1a{}", (Object)JSONObject.toJSONString((Object)dto));
        this.reconciliationRecordService.saveOrUpdate(dto);
    }

    public void updateCreditsRsp(CreditsMessageDto request, String body, Boolean addCredits) {
        try {
            Map<String, String> authParamMap;
            Long appId = Long.valueOf(request.getAppId());
            if (!this.isReconcile(appId)) {
                return;
            }
            String relationType = request.getRelationType();
            String relationId = request.getRelationId();
            String url = request.getHttpUrl();
            if (Objects.equals(request.getHttpType(), "post")) {
                authParamMap = request.getAuthParams();
            } else {
                String authParams = url.substring(url.indexOf(63) + 1);
                authParamMap = AssembleTool.getUrlParams(authParams);
            }
            if (MapUtils.isNotEmpty((Map)authParamMap) && StringUtils.isNotBlank((CharSequence)((CharSequence)authParamMap.get("orderNum")))) {
                relationId = authParamMap.get("orderNum");
            }
            logger.info("reconcile update\uff1arelation id:{}, appId:{}, relationType:{}, body:{}", new Object[]{request.getRelationId(), appId, relationType, body});
            this.updateCreditsRsp(appId, body, addCredits, relationId, relationType);
        }
        catch (Exception e) {
            logger.error("\u66f4\u65b0\u5bf9\u8d26\u8bb0\u5f55\u51fa\u9519, request:{}, body:{}, addCredits:{}, ", new Object[]{JSONObject.toJSONString((Object)request), body, addCredits, e});
        }
    }

    public void updateCreditsRsp(CreditsMessage request, String body, Boolean addCredits) {
        try {
            Map<String, String> authParamMap;
            Long appId = Long.valueOf(request.getAppId());
            if (!this.isReconcile(appId)) {
                return;
            }
            String relationType = request.getRelationType();
            String relationId = request.getRelationId();
            String url = request.getHttpUrl();
            if (Objects.equals(request.getHttpType(), "post")) {
                authParamMap = request.getAuthParams();
            } else {
                String authParams = url.substring(url.indexOf(63) + 1);
                authParamMap = AssembleTool.getUrlParams(authParams);
            }
            if (MapUtils.isNotEmpty((Map)authParamMap) && StringUtils.isNotBlank((CharSequence)((CharSequence)authParamMap.get("orderNum")))) {
                relationId = authParamMap.get("orderNum");
            }
            logger.info("reconcile update\uff1arelation id:{}, appId:{}, relationType:{}, body:{}", new Object[]{request.getRelationId(), appId, relationType, body});
            this.updateCreditsRsp(appId, body, addCredits, relationId, relationType);
        }
        catch (Exception e) {
            logger.error("\u66f4\u65b0\u5bf9\u8d26\u8bb0\u5f55\u51fa\u9519, request:{}, body:{}, addCredits:{}, ", new Object[]{JSONObject.toJSONString((Object)request), body, addCredits, e});
        }
    }

    public void updateCreditsRsp(SubCreditsMsgWrapper subCreditsMsgWrapper, String body, Boolean addCredits) {
        try {
            SubCreditsMsgDto request = subCreditsMsgWrapper.getSubCreditsMsg();
            Long appId = (long)request.getAppId();
            if (!this.isReconcile(appId)) {
                return;
            }
            String relationId = request.getRelationId();
            Map authParamMap = request.getAuthParams();
            if (MapUtils.isNotEmpty((Map)authParamMap) && StringUtils.isNotBlank((CharSequence)((CharSequence)authParamMap.get("orderNum")))) {
                relationId = (String)authParamMap.get("orderNum");
            }
            String relationType = null;
            if (request.getRelationType() != null) {
                relationType = request.getRelationType().getMsg();
            }
            logger.info("reconcile update\uff1arelation id:{}, appId:{}, relationType:{}, body:{}", new Object[]{request.getRelationId(), appId, relationType, body});
            this.updateCreditsRsp(appId, body, addCredits, relationId, relationType);
        }
        catch (Exception e) {
            logger.error("\u66f4\u65b0\u5bf9\u8d26\u8bb0\u5f55\u51fa\u9519, request:{}, body:{}, addCredits:{}, ", new Object[]{JSONObject.toJSONString((Object)subCreditsMsgWrapper.getSubCreditsMsg()), body, addCredits, e});
        }
    }

    private void updateCreditsRsp(Long appId, String body, Boolean addCredits, String relationId, String relationType) {
        if (!this.isReconcile(appId)) {
            return;
        }
        logger.info("reconcile update\uff1arelation id:{}, appId:{}, relationType:{}, body:{}", new Object[]{relationId, appId, relationType, body});
        this.executorService.submit(() -> {
            try {
                ReconciliationRecordDto reconciliationRecordDto = new ReconciliationRecordDto();
                reconciliationRecordDto.setOrderNum(relationId);
                reconciliationRecordDto.setLogType(Integer.valueOf(ReconciliationLogTypeEnum.SUB_CREDITS.getCode()));
                reconciliationRecordDto.setAppId(appId);
                reconciliationRecordDto.setOptType(relationType);
                if (addCredits.booleanValue()) {
                    reconciliationRecordDto.setLogType(Integer.valueOf(ReconciliationLogTypeEnum.ADD_CREDITS.getCode()));
                }
                this.parseRespBody(body, reconciliationRecordDto);
                Pair<Integer, Boolean> pair = this.reconciliationRecordService.update(reconciliationRecordDto);
                if (BooleanUtils.isFalse((Boolean)((Boolean)pair.getRight()))) {
                    this.retry(0, reconciliationRecordDto);
                }
            }
            catch (Exception e) {
                logger.error("update\u54cd\u5e94\u7ed3\u679c\u51fa\u9519, appId:{}, relationId:{}, relationType:{}, body:{}, ", new Object[]{appId, relationId, relationType, body, e});
            }
        });
    }

    @DBTimeProfiler
    private void retry(int retryTimes, ReconciliationRecordDto reconciliationRecordDto) {
        ++retryTimes;
        try {
            if (retryTimes > 3) {
                logger.error("\u5bf9\u8d26\u66f4\u65b0\u91cd\u8bd5{}\u6b21\uff0c\u4f9d\u65e7\u5931\u8d25\uff0c\u53d6\u6d88\u91cd\u8bd5\uff0cdto={}", (Object)3, (Object)JSONObject.toJSONString((Object)reconciliationRecordDto));
                return;
            }
            TimeUnit.SECONDS.sleep(1L);
            Pair<Integer, Boolean> pair = this.reconciliationRecordService.update(reconciliationRecordDto);
            if (BooleanUtils.isFalse((Boolean)((Boolean)pair.getRight()))) {
                this.retry(retryTimes, reconciliationRecordDto);
            }
        }
        catch (InterruptedException e) {
            logger.warn("", (Throwable)e);
        }
        catch (Exception e) {
            logger.warn("", (Throwable)e);
            this.retry(retryTimes, reconciliationRecordDto);
        }
    }

    private void parseRespBody(String body, ReconciliationRecordDto dto) {
        String respBody = body;
        if (StringUtils.isNotBlank((CharSequence)body)) {
            dto.setResponseStatus(Integer.valueOf(ReconciliationRespStatusEnum.FAIL.getCode()));
            JSONObject json = JSON.parseObject((String)body);
            if (json != null && ("success".equalsIgnoreCase(json.getString("status")) || "ok".equalsIgnoreCase(json.getString("status")))) {
                dto.setResponseStatus(Integer.valueOf(ReconciliationRespStatusEnum.SUCCESS.getCode()));
            }
            if (respBody.length() > 255) {
                respBody = respBody.substring(0, 255);
            }
            dto.setResponseBody(respBody);
        }
    }

    public void saveVirtualAddCreditsMsg(SupplierRequest request) {
        if (!this.isReconcile(Long.valueOf(request.getAppId()))) {
            return;
        }
        if (!request.isSaveReconciliationRecord()) {
            return;
        }
        logger.info("saveVirtualAddCreditsMsg \u52a0\u79ef\u5206\uff1a{}", (Object)JSONObject.toJSONString((Object)request));
        this.executorService.submit(() -> {
            try {
                Map<String, String> authParamMap = request.getAuthParams();
                String orderNum = authParamMap.get("orderNum");
                ReconciliationRecordDto dto = this.wrapReconciliationLog(Long.valueOf(request.getAppId()), orderNum, null, authParamMap, null, ReconciliationLogTypeEnum.ADD_CREDITS);
                this.reconciliationRecordService.saveOrUpdate(dto);
            }
            catch (Exception e) {
                logger.error("save\u5bf9\u8d26\u8bb0\u5f55\u51fa\u9519, SupplierRequest:{}, ", (Object)JSON.toJSONString((Object)request), (Object)e);
            }
        });
    }

    public void updateVirtualAddCreditsRsp(SupplierRequest request, String body) {
        try {
            Long appId = Long.valueOf(request.getAppId());
            if (!this.isReconcile(appId)) {
                return;
            }
            if (!request.isSaveReconciliationRecord()) {
                return;
            }
            Map<String, String> authParamMap = request.getAuthParams();
            String relationId = authParamMap.get("orderNum");
            logger.info("reconcile update\uff1arelation id:{}, appId:{}, relationType:{}, body:{}", (Object)JSONObject.toJSONString((Object)request), (Object)body);
            this.updateCreditsRsp(appId, body, true, relationId, null);
        }
        catch (Exception e) {
            logger.error("\u66f4\u65b0\u5bf9\u8d26\u8bb0\u5f55\u51fa\u9519", (Throwable)e);
        }
    }
}

