/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.biz.credits.strategy;

import cn.com.duiba.biz.credits.strategy.ApiStrategy;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApiStrategyRouter {
    private static final Logger log = LoggerFactory.getLogger(ApiStrategyRouter.class);
    private static Map<Long, ApiStrategy> apiStrategyMap = new ConcurrentHashMap<Long, ApiStrategy>(256);

    public static void register(Set<Long> appIds, ApiStrategy apiStrategy) {
        log.info("\u7b56\u7565\u8def\u7531\u7c7b\u6ce8\u518c apiStrategy:{},appIds:{}", (Object)apiStrategy, appIds);
        for (Long appId : appIds) {
            apiStrategyMap.put(appId, apiStrategy);
        }
        log.info("apiStrategyMap:{}", apiStrategyMap);
    }

    public static ApiStrategy route(Long appId) {
        ApiStrategy apiStrategy = apiStrategyMap.get(appId);
        return apiStrategy;
    }
}

