/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.biz.phonebill.supplier;

import cn.com.duiba.domain.SupplierRequest;
import cn.com.duiba.domain.SupplierResponse;
import cn.com.duiba.mq.RocketMQMsgProducer;
import cn.com.duiba.service.HttpAsyncClientPool;
import cn.com.duiba.service.MessageService;
import cn.com.duiba.tool.AssembleTool;
import cn.com.duiba.tool.HttpRequestLog;
import cn.com.duiba.tool.JsonTool;
import cn.com.duiba.tool.ParserUtil;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class XiangShangPhoneBillSupplier {
    private static Logger log = LoggerFactory.getLogger(XiangShangPhoneBillSupplier.class);
    private static final int MAX_TIMEOUT = 5000;
    @Autowired
    private MessageService messageService;
    @Autowired
    private RocketMQMsgProducer rocketMQMsgProducer;
    @Autowired
    private HttpAsyncClientPool httpAsyncClientPool;

    public void asyncSubmit(final SupplierRequest message, final String callbackTopic, final String msgTag, final String msgKey) {
        if (!this.messageService.messageUniqueCheck(message.getSupplierOrderId(), "phonebill")) {
            return;
        }
        String bodyContent = message.getParams().get("entity");
        log.info("\u5411\u4e0a\u8bdd\u8d39\u5145\u503c\uff0c\u8bf7\u6c42\uff0curl={}\uff0cbody={}", (Object)message.getHttpUrl(), (Object)bodyContent);
        HttpPost post = AssembleTool.assembleRequest(message.getHttpUrl(), ParserUtil.parseAttr2KVMap(bodyContent));
        RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(5000).setConnectTimeout(5000).build();
        post.setConfig(requestConfig);
        HttpRequestLog.logUrl("[action phonebill] [tag request] [bizId " + message.getOrderId() + "] [url " + message.getHttpUrl() + "]");
        this.httpAsyncClientPool.submit(message.getAppId(), (HttpUriRequest)post, new FutureCallback<HttpResponse>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void completed(HttpResponse response) {
                SupplierResponse resp = new SupplierResponse();
                try {
                    XiangShangPhoneBillSupplier.this.buildSupplierResponse(resp, message);
                    resp.setCallbackType("completed");
                    String body = EntityUtils.toString((HttpEntity)response.getEntity());
                    resp.setBody(body);
                }
                catch (Exception e) {
                    log.error("XiangShangPhoneBillSupplier completed", (Throwable)e);
                }
                finally {
                    XiangShangPhoneBillSupplier.this.finallyBlock(message, resp, callbackTopic, msgTag, msgKey);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void failed(Exception ex) {
                log.error("XiangShangPhoneBillSupplier failed orderId:" + message.getOrderId(), (Throwable)ex);
                SupplierResponse resp = new SupplierResponse();
                try {
                    XiangShangPhoneBillSupplier.this.buildSupplierResponse(resp, message);
                    resp.setCallbackType("failed");
                    resp.setErrorMessage(ex.getClass().getName() + ":" + ex.getMessage());
                }
                catch (Exception e) {
                    log.error("XiangShangPhoneBillSupplier completed", (Throwable)e);
                }
                finally {
                    XiangShangPhoneBillSupplier.this.finallyBlock(message, resp, callbackTopic, msgTag, msgKey);
                }
            }

            public void cancelled() {
                SupplierResponse resp = new SupplierResponse();
                try {
                    XiangShangPhoneBillSupplier.this.buildSupplierResponse(resp, message);
                    resp.setCallbackType("cancelled");
                }
                catch (Exception e) {
                    log.error("XiangShangPhoneBillSupplier cancelled", (Throwable)e);
                }
                finally {
                    XiangShangPhoneBillSupplier.this.finallyBlock(message, resp, callbackTopic, msgTag, msgKey);
                }
            }
        });
    }

    private void buildSupplierResponse(SupplierResponse resp, SupplierRequest message) {
        resp.setUrl(message.getHttpUrl());
        resp.setSupplierName(message.getSupplierName());
        resp.setSupplierOrderId(message.getSupplierOrderId());
        resp.setOrderId(message.getOrderId());
        resp.setAppId(message.getAppId());
        resp.setConsumerId(message.getConsumerId());
    }

    private void finallyBlock(SupplierRequest message, SupplierResponse response, String callbackTopic, String msgTag, String msgKey) {
        try {
            String body = JsonTool.objectToJson(response);
            log.info("\u5411\u4e0a\u8bdd\u8d39\u5145\u503c\uff0c\u54cd\u5e94\uff0curl={}\uff0cbody={}", (Object)message.getHttpUrl(), (Object)body);
            HttpRequestLog.logUrl("[action phonebill] [tag response] [callback " + response.getCallbackType() + "] [bizId " + message.getOrderId() + "] [body " + response.getBody() + "]");
            if (callbackTopic.contains("MQ")) {
                this.rocketMQMsgProducer.sendMsg(callbackTopic, msgTag, msgKey, body, false, null);
            } else {
                this.messageService.sendMsg(callbackTopic, msgTag, msgKey, body);
            }
        }
        catch (Exception e) {
            log.error("XiangShangPhoneBillSupplier callback:" + message.getOrderId(), (Throwable)e);
        }
    }
}

